<?php

namespace App\DataFixtures\Countries;

use App\Entity\Country;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Common\Persistence\ObjectManager;
use Doctrine\Bundle\FixturesBundle\FixtureGroupInterface;

class CountryFixtures extends Fixture implements FixtureGroupInterface {

    public static function getGroups(): array {
        return ['countries'];
    }

    public function load(ObjectManager $manager) {

        $countries_en = array(
            'BD' => 'Bangladesh',
            'BE' => 'Belgium',
            'BF' => 'Burkina Faso',
            'BG' => 'Bulgaria',
            'BA' => 'Bosnia and Herzegovina',
            'BB' => 'Barbados',
            'WF' => 'Wallis and Futuna',
            'BL' => 'Saint Barthelemy',
            'BM' => 'Bermuda',
            'BN' => 'Brunei',
            'BO' => 'Bolivia',
            'BH' => 'Bahrain',
            'BI' => 'Burundi',
            'BJ' => 'Benin',
            'BT' => 'Bhutan',
            'JM' => 'Jamaica',
            'BV' => 'Bouvet Island',
            'BW' => 'Botswana',
            'WS' => 'Samoa',
            'BQ' => 'Bonaire, Saint Eustatius and Saba',
            'BR' => 'Brazil',
            'BS' => 'Bahamas',
            'JE' => 'Jersey',
            'BY' => 'Belarus',
            'BZ' => 'Belize',
            'RU' => 'Russia',
            'RW' => 'Rwanda',
            'RS' => 'Serbia',
            'TL' => 'East Timor',
            'RE' => 'Reunion',
            'TM' => 'Turkmenistan',
            'TJ' => 'Tajikistan',
            'RO' => 'Romania',
            'TK' => 'Tokelau',
            'GW' => 'Guinea-Bissau',
            'GU' => 'Guam',
            'GT' => 'Guatemala',
            'GS' => 'South Georgia and the South Sandwich Islands',
            'GR' => 'Greece',
            'GQ' => 'Equatorial Guinea',
            'GP' => 'Guadeloupe',
            'JP' => 'Japan',
            'GY' => 'Guyana',
            'GG' => 'Guernsey',
            'GF' => 'French Guiana',
            'GE' => 'Georgia',
            'GD' => 'Grenada',
            'GB' => 'United Kingdom',
            'GA' => 'Gabon',
            'SV' => 'El Salvador',
            'GN' => 'Guinea',
            'GM' => 'Gambia',
            'GL' => 'Greenland',
            'GI' => 'Gibraltar',
            'GH' => 'Ghana',
            'OM' => 'Oman',
            'TN' => 'Tunisia',
            'JO' => 'Jordan',
            'HR' => 'Croatia',
            'HT' => 'Haiti',
            'HU' => 'Hungary',
            'HK' => 'Hong Kong',
            'HN' => 'Honduras',
            'HM' => 'Heard Island and McDonald Islands',
            'VE' => 'Venezuela',
            'PR' => 'Puerto Rico',
            'PS' => 'Palestinian Territory',
            'PW' => 'Palau',
            'PT' => 'Portugal',
            'SJ' => 'Svalbard and Jan Mayen',
            'PY' => 'Paraguay',
            'IQ' => 'Iraq',
            'PA' => 'Panama',
            'PF' => 'French Polynesia',
            'PG' => 'Papua New Guinea',
            'PE' => 'Peru',
            'PK' => 'Pakistan',
            'PH' => 'Philippines',
            'PN' => 'Pitcairn',
            'PL' => 'Poland',
            'PM' => 'Saint Pierre and Miquelon',
            'ZM' => 'Zambia',
            'EH' => 'Western Sahara',
            'EE' => 'Estonia',
            'EG' => 'Egypt',
            'ZA' => 'South Africa',
            'EC' => 'Ecuador',
            'IT' => 'Italy',
            'VN' => 'Vietnam',
            'SB' => 'Solomon Islands',
            'ET' => 'Ethiopia',
            'SO' => 'Somalia',
            'ZW' => 'Zimbabwe',
            'SA' => 'Saudi Arabia',
            'ES' => 'Spain',
            'ER' => 'Eritrea',
            'ME' => 'Montenegro',
            'MD' => 'Moldova',
            'MG' => 'Madagascar',
            'MF' => 'Saint Martin',
            'MA' => 'Morocco',
            'MC' => 'Monaco',
            'UZ' => 'Uzbekistan',
            'MM' => 'Myanmar',
            'ML' => 'Mali',
            'MO' => 'Macao',
            'MN' => 'Mongolia',
            'MH' => 'Marshall Islands',
            'MK' => 'Macedonia',
            'MU' => 'Mauritius',
            'MT' => 'Malta',
            'MW' => 'Malawi',
            'MV' => 'Maldives',
            'MQ' => 'Martinique',
            'MP' => 'Northern Mariana Islands',
            'MS' => 'Montserrat',
            'MR' => 'Mauritania',
            'IM' => 'Isle of Man',
            'UG' => 'Uganda',
            'TZ' => 'Tanzania',
            'MY' => 'Malaysia',
            'MX' => 'Mexico',
            'FR' => 'France',
            'IO' => 'British Indian Ocean Territory',
            'SH' => 'Saint Helena',
            'FI' => 'Finland',
            'FJ' => 'Fiji',
            'FK' => 'Falkland Islands',
            'FM' => 'Micronesia',
            'FO' => 'Faroe Islands',
            'NI' => 'Nicaragua',
            'NL' => 'Netherlands',
            'NO' => 'Norway',
            'NA' => 'Namibia',
            'VU' => 'Vanuatu',
            'NC' => 'New Caledonia',
            'NE' => 'Niger',
            'NF' => 'Norfolk Island',
            'NG' => 'Nigeria',
            'NZ' => 'New Zealand',
            'NP' => 'Nepal',
            'NR' => 'Nauru',
            'NU' => 'Niue',
            'CK' => 'Cook Islands',
            'XK' => 'Kosovo',
            'CI' => 'Ivory Coast',
            'CH' => 'Switzerland',
            'CO' => 'Colombia',
            'CN' => 'China',
            'CM' => 'Cameroon',
            'CL' => 'Chile',
            'CC' => 'Cocos Islands',
            'CA' => 'Canada',
            'CG' => 'Republic of the Congo',
            'CF' => 'Central African Republic',
            'CD' => 'Democratic Republic of the Congo',
            'CZ' => 'Czech Republic',
            'CY' => 'Cyprus',
            'CX' => 'Christmas Island',
            'CR' => 'Costa Rica',
            'CW' => 'Curacao',
            'CV' => 'Cape Verde',
            'CU' => 'Cuba',
            'SZ' => 'Swaziland',
            'SY' => 'Syria',
            'SX' => 'Sint Maarten',
            'KG' => 'Kyrgyzstan',
            'KE' => 'Kenya',
            'SS' => 'South Sudan',
            'SR' => 'Suriname',
            'KI' => 'Kiribati',
            'KH' => 'Cambodia',
            'KN' => 'Saint Kitts and Nevis',
            'KM' => 'Comoros',
            'ST' => 'Sao Tome and Principe',
            'SK' => 'Slovakia',
            'KR' => 'South Korea',
            'SI' => 'Slovenia',
            'KP' => 'North Korea',
            'KW' => 'Kuwait',
            'SN' => 'Senegal',
            'SM' => 'San Marino',
            'SL' => 'Sierra Leone',
            'SC' => 'Seychelles',
            'KZ' => 'Kazakhstan',
            'KY' => 'Cayman Islands',
            'SG' => 'Singapore',
            'SE' => 'Sweden',
            'SD' => 'Sudan',
            'DO' => 'Dominican Republic',
            'DM' => 'Dominica',
            'DJ' => 'Djibouti',
            'DK' => 'Denmark',
            'VG' => 'British Virgin Islands',
            'DE' => 'Germany',
            'YE' => 'Yemen',
            'DZ' => 'Algeria',
            'US' => 'United States',
            'UY' => 'Uruguay',
            'YT' => 'Mayotte',
            'UM' => 'United States Minor Outlying Islands',
            'LB' => 'Lebanon',
            'LC' => 'Saint Lucia',
            'LA' => 'Laos',
            'TV' => 'Tuvalu',
            'TW' => 'Taiwan',
            'TT' => 'Trinidad and Tobago',
            'TR' => 'Turkey',
            'LK' => 'Sri Lanka',
            'LI' => 'Liechtenstein',
            'LV' => 'Latvia',
            'TO' => 'Tonga',
            'LT' => 'Lithuania',
            'LU' => 'Luxembourg',
            'LR' => 'Liberia',
            'LS' => 'Lesotho',
            'TH' => 'Thailand',
            'TF' => 'French Southern Territories',
            'TG' => 'Togo',
            'TD' => 'Chad',
            'TC' => 'Turks and Caicos Islands',
            'LY' => 'Libya',
            'VA' => 'Vatican',
            'VC' => 'Saint Vincent and the Grenadines',
            'AE' => 'United Arab Emirates',
            'AD' => 'Andorra',
            'AG' => 'Antigua and Barbuda',
            'AF' => 'Afghanistan',
            'AI' => 'Anguilla',
            'VI' => 'U.S. Virgin Islands',
            'IS' => 'Iceland',
            'IR' => 'Iran',
            'AM' => 'Armenia',
            'AL' => 'Albania',
            'AO' => 'Angola',
            'AQ' => 'Antarctica',
            'AS' => 'American Samoa',
            'AR' => 'Argentina',
            'AU' => 'Australia',
            'AT' => 'Austria',
            'AW' => 'Aruba',
            'IN' => 'India',
            'AX' => 'Aland Islands',
            'AZ' => 'Azerbaijan',
            'IE' => 'Ireland',
            'ID' => 'Indonesia',
            'UA' => 'Ukraine',
            'QA' => 'Qatar',
            'MZ' => 'Mozambique',
        );

        $countries_zh = array(
            'BD' => '孟加拉国',
            'BE' => '比利时',
            'BF' => '布基纳法索',
            'BG' => '保加利亚',
            'BA' => '波斯尼亚和黑塞哥维那',
            'BB' => '巴巴多斯',
            'WF' => '瓦利斯和富图纳群岛',
            'BL' => '瓦利斯和富图纳群岛',
            'BM' => '百慕大',
            'BN' => '文莱',
            'BO' => '玻利维亚',
            'BH' => '巴林',
            'BI' => '布隆迪',
            'BJ' => '贝宁',
            'BT' => '不丹',
            'JM' => '牙买加',
            'BV' => '布维岛',
            'BW' => '博茨瓦纳',
            'WS' => '萨摩亚',
            'BQ' => '博内尔岛，圣尤斯特歇斯岛和萨巴岛',
            'BR' => '巴西',
            'BS' => '巴哈马',
            'JE' => '新泽西',
            'BY' => '白俄罗斯',
            'BZ' => '伯利兹',
            'RU' => '俄国',
            'RW' => '卢旺达',
            'RS' => '塞尔维亚',
            'TL' => '东帝汶',
            'RE' => '团圆',
            'TM' => '土库曼斯坦',
            'TJ' => '塔吉克斯坦',
            'RO' => '罗马尼亚',
            'TK' => '托克劳',
            'GW' => '几内亚比绍',
            'GU' => '关岛',
            'GT' => '危地马拉',
            'GS' => '南乔治亚岛和南桑威奇群岛',
            'GR' => '希腊',
            'GQ' => '赤道几内亚',
            'GP' => '瓜德罗普岛',
            'JP' => '日本',
            'GY' => '圭亚那',
            'GG' => '根西岛',
            'GF' => '法属圭亚那',
            'GE' => '格鲁吉亚',
            'GD' => '格林纳达',
            'GB' => '英国',
            'GA' => '加蓬',
            'SV' => '萨尔瓦多',
            'GN' => '几内亚',
            'GM' => '冈比亚',
            'GL' => '格陵兰',
            'GI' => '直布罗陀',
            'GH' => '加纳',
            'OM' => '阿曼',
            'TN' => '突尼斯',
            'JO' => '约旦',
            'HR' => '克罗地亚',
            'HT' => '海地',
            'HU' => '匈牙利',
            'HK' => '香港',
            'HN' => '洪都拉斯',
            'HM' => '赫德岛和麦当劳群岛',
            'VE' => '委内瑞拉',
            'PR' => '波多黎各',
            'PS' => '巴勒斯坦领土',
            'PW' => '帕劳',
            'PT' => '葡萄牙',
            'SJ' => '斯瓦尔巴和扬马延',
            'PY' => '巴拉圭',
            'IQ' => '伊拉克',
            'PA' => '巴拿马',
            'PF' => '法属波利尼西亚',
            'PG' => '巴布亚新几内亚',
            'PE' => '秘鲁',
            'PK' => '巴基斯坦',
            'PH' => '菲律宾',
            'PN' => '皮特凯恩',
            'PL' => '波兰',
            'PM' => '圣皮埃尔和密克隆',
            'ZM' => '赞比亚',
            'EH' => '撒哈拉沙漠西部',
            'EE' => '爱沙尼亚',
            'EG' => '埃及',
            'ZA' => '南非',
            'EC' => '厄瓜多尔',
            'IT' => '意大利',
            'VN' => '越南',
            'SB' => '所罗门群岛',
            'ET' => '埃塞俄比亚',
            'SO' => '索马里',
            'ZW' => '津巴布韦',
            'SA' => '沙特阿拉伯',
            'ES' => '西班牙',
            'ER' => '厄立特里亚',
            'ME' => '黑山',
            'MD' => '摩尔多瓦',
            'MG' => '马达加斯加',
            'MF' => '圣马丁',
            'MA' => '摩洛哥',
            'MC' => '摩纳哥',
            'UZ' => '乌兹别克斯坦',
            'MM' => '缅甸',
            'ML' => '马里',
            'MO' => '澳门',
            'MN' => '蒙古',
            'MH' => '马绍尔群岛',
            'MK' => '马其顿',
            'MU' => '毛里求斯',
            'MT' => '马耳他',
            'MW' => '马拉维',
            'MV' => '马尔代夫',
            'MQ' => '马提尼克',
            'MP' => '北马里亚纳群岛',
            'MS' => '蒙特塞拉特',
            'MR' => '毛里塔尼亚',
            'IM' => '马恩岛',
            'UG' => '乌干达',
            'TZ' => '坦桑尼亚',
            'MY' => '马来西亚',
            'MX' => '墨西哥',
            'FR' => '法国',
            'IO' => '英属印度洋领地',
            'SH' => '圣赫勒拿岛',
            'FI' => '芬兰',
            'FJ' => '斐',
            'FK' => '福克兰群岛',
            'FM' => '密克罗尼西亚',
            'FO' => '法罗群岛',
            'NI' => '尼加拉瓜',
            'NL' => '荷兰',
            'NO' => '挪威',
            'NA' => '纳米比亚',
            'VU' => '瓦努阿图',
            'NC' => '新喀里多尼亚',
            'NE' => '尼日尔',
            'NF' => '诺福克岛',
            'NG' => '尼日利亚',
            'NZ' => '新西兰',
            'NP' => '尼泊尔',
            'NR' => '瑙鲁',
            'NU' => '纽埃',
            'CK' => '库克群岛',
            'XK' => '科索沃',
            'CI' => '象牙海岸',
            'CH' => '瑞士',
            'CO' => '哥伦比亚',
            'CN' => '中国',
            'CM' => '喀麦隆',
            'CL' => '智利',
            'CC' => '科科斯群岛',
            'CA' => '加拿大',
            'CG' => '刚果共和国',
            'CF' => '中非共和国',
            'CD' => '刚果民主共和国',
            'CZ' => '捷克共和国',
            'CY' => '塞浦路斯',
            'CX' => '圣诞岛',
            'CR' => '哥斯达黎加',
            'CW' => '库拉索',
            'CV' => '佛得角',
            'CU' => '古巴',
            'SZ' => '斯威士兰',
            'SY' => '叙利亚',
            'SX' => '圣马丁岛',
            'KG' => '吉尔吉斯斯坦',
            'KE' => '肯尼亚',
            'SS' => '南苏丹',
            'SR' => '苏里南',
            'KI' => '基里巴斯',
            'KH' => '柬埔寨',
            'KN' => '圣基茨和尼维斯',
            'KM' => '科摩罗',
            'ST' => '圣多美和普林西比',
            'SK' => '斯洛伐克',
            'KR' => '韩国',
            'SI' => '斯洛文尼亚',
            'KP' => '北朝鲜',
            'KW' => '科威特',
            'SN' => '塞内加尔',
            'SM' => '圣马力诺',
            'SL' => '塞拉利昂',
            'SC' => '塞舌尔',
            'KZ' => '哈萨克斯坦',
            'KY' => '开曼群岛',
            'SG' => '新加坡',
            'SE' => '瑞典',
            'SD' => '苏丹',
            'DO' => '多明尼加共和国',
            'DM' => '多米尼加',
            'DJ' => '吉布提',
            'DK' => '丹麦',
            'VG' => '英属维尔京群岛',
            'DE' => '德国',
            'YE' => '也门',
            'DZ' => '阿尔及利亚',
            'US' => '美国',
            'UY' => '乌拉圭',
            'YT' => '马约特',
            'UM' => '美国本土外小岛屿',
            'LB' => '黎巴嫩',
            'LC' => '圣卢西亚',
            'LA' => '老挝',
            'TV' => '图瓦卢',
            'TW' => '台湾',
            'TT' => '特立尼达和多巴哥',
            'TR' => '火鸡',
            'LK' => '斯里兰卡',
            'LI' => '列支敦士登',
            'LV' => '拉脱维亚',
            'TO' => '汤加',
            'LT' => '立陶宛',
            'LU' => '卢森堡',
            'LR' => '利比里亚',
            'LS' => '莱索托',
            'TH' => '泰国',
            'TF' => '法属南部领土',
            'TG' => '多哥',
            'TD' => '乍得',
            'TC' => '特克斯和凯科斯群岛',
            'LY' => '利比亚',
            'VA' => '教廷',
            'VC' => '圣文森特和格林纳丁斯',
            'AE' => '阿拉伯联合酋长国',
            'AD' => '安道尔',
            'AG' => '安提瓜和巴布达',
            'AF' => '阿富汗',
            'AI' => '安圭拉',
            'VI' => '美属维尔京群岛',
            'IS' => '冰岛',
            'IR' => '伊朗',
            'AM' => '亚美尼亚',
            'AL' => '阿尔巴尼亚',
            'AO' => '安哥拉',
            'AQ' => '南极洲',
            'AS' => '美属萨摩亚',
            'AR' => '阿根廷',
            'AU' => '澳大利亚',
            'AT' => '奥地利',
            'AW' => '阿鲁巴',
            'IN' => '印度',
            'AX' => '奥兰群岛',
            'AZ' => '阿塞拜疆',
            'IE' => '爱尔兰',
            'ID' => '印度尼西亚',
            'UA' => '乌克兰',
            'QA' => '卡塔尔',
            'MZ' => '莫桑比克',
        );

        $countries_es = array(
            'BD' => 'Bangladesh',
            'BE' => 'Bélgica',
            'BF' => 'Burkina Faso',
            'BG' => 'Bulgaria',
            'BA' => 'Bosnia y Herzegovina',
            'BB' => 'Barbadas',
            'WF' => 'Wallis y Futuna',
            'BL' => 'San Bartolomé',
            'BM' => 'islas Bermudas',
            'BN' => 'Brunei',
            'BO' => 'Bolivia',
            'BH' => 'Bahrein',
            'BI' => 'Burundi',
            'BJ' => 'Benin',
            'BT' => 'Bután',
            'JM' => 'Jamaica',
            'BV' => 'Isla Bouvet',
            'BW' => 'Botsuana',
            'WS' => 'Samoa',
            'BQ' => 'Bonaire, San Eustaquio y Saba',
            'BR' => 'Brasil',
            'BS' => 'Bahamas',
            'JE' => 'Jersey',
            'BY' => 'Bielorrusia',
            'BZ' => 'Belice',
            'RU' => 'Rusia',
            'RW' => 'Ruanda',
            'RS' => 'Serbia',
            'TL' => 'Timor oriental',
            'RE' => 'Reunión',
            'TM' => 'Turkmenistán',
            'TJ' => 'Tayikistan',
            'RO' => 'Rumania',
            'TK' => 'Tokelau',
            'GW' => 'Guinea-Bissau',
            'GU' => 'Guam',
            'GT' => 'Guatemala',
            'GS' => 'Georgia del sur y las islas Sandwich del sur',
            'GR' => 'Grecia',
            'GQ' => 'Guinea Ecuatorial',
            'GP' => 'Guadalupe',
            'JP' => 'Japón',
            'GY' => 'Guayana',
            'GG' => 'Guernsey',
            'GF' => 'Guayana Francesa',
            'GE' => 'Georgia',
            'GD' => 'Granada',
            'GB' => 'Reino Unido',
            'GA' => 'Gabón',
            'SV' => 'El Salvador',
            'GN' => 'Guinea',
            'GM' => 'Gambia',
            'GL' => 'Tierra Verde',
            'GI' => 'Gibraltar',
            'GH' => 'Ghana',
            'OM' => 'Omán',
            'TN' => 'Túnez',
            'JO' => 'Jordán',
            'HR' => 'Croacia',
            'HT' => 'Haití',
            'HU' => 'Hungría',
            'HK' => 'Hong Kong',
            'HN' => 'Honduras',
            'HM' => 'Islas Heard y McDonald',
            'VE' => 'Venezuela',
            'PR' => 'Puerto Rico',
            'PS' => 'Territorio Palestino',
            'PW' => 'Palau',
            'PT' => 'Portugal',
            'SJ' => 'Svalbard y Jan Mayen',
            'PY' => 'Paraguay',
            'IQ' => 'Irak',
            'PA' => 'Panamá',
            'PF' => 'Polinesia francés',
            'PG' => 'Papúa Nueva Guinea',
            'PE' => 'Perú',
            'PK' => 'Pakistán',
            'PH' => 'Filipinos',
            'PN' => 'Pitcairn',
            'PL' => 'Polonia',
            'PM' => 'San Pedro y Miquelón',
            'ZM' => 'Zambia',
            'EH' => 'Sahara Occidental',
            'EE' => 'Estonia',
            'EG' => 'Egipto',
            'ZA' => 'Sudáfrica',
            'EC' => 'Ecuador',
            'IT' => 'Italia',
            'VN' => 'Vietnam',
            'SB' => 'Islas Salomón',
            'ET' => 'Etiopía',
            'SO' => 'Somalia',
            'ZW' => 'Zimbabue',
            'SA' => 'Arabia Saudita',
            'ES' => 'España',
            'ER' => 'Eritrea',
            'ME' => 'Montenegro',
            'MD' => 'Moldavia',
            'MG' => 'Madagascar',
            'MF' => 'San Martín',
            'MA' => 'Marruecos',
            'MC' => 'Mónaco',
            'UZ' => 'Uzbekistán',
            'MM' => 'Myanmar',
            'ML' => 'Mali',
            'MO' => 'Macao',
            'MN' => 'Mongolia',
            'MH' => 'Islas Marshall',
            'MK' => 'Macedonia',
            'MU' => 'Mauricio',
            'MT' => 'Malta',
            'MW' => 'Malawi',
            'MV' => 'Maldivos',
            'MQ' => 'Martinica',
            'MP' => 'Islas Marianas del Norte',
            'MS' => 'Montserrat',
            'MR' => 'Mauritania',
            'IM' => 'Isla del hombre',
            'UG' => 'Uganda',
            'TZ' => 'Tanzania',
            'MY' => 'Malasia',
            'MX' => 'Mexico',
            'FR' => 'Francia',
            'IO' => 'Territorio Británico del Océano Índico',
            'SH' => 'Santa helena',
            'FI' => 'Finlandia',
            'FJ' => 'Fiyi',
            'FK' => 'Islas Malvinas',
            'FM' => 'Micronesia',
            'FO' => 'Islas Faroe',
            'NI' => 'Nicaragua',
            'NL' => 'Países Bajos',
            'NO' => 'Noruega',
            'NA' => 'Namibia',
            'VU' => 'Vanuatu',
            'NC' => 'Nueva Caledonia',
            'NE' => 'Níger',
            'NF' => 'Isla Norfolk',
            'NG' => 'Nigeria',
            'NZ' => 'Nueva Zelanda',
            'NP' => 'Nepal',
            'NR' => 'Nauru',
            'NU' => 'Niue',
            'CK' => 'Islas Cook',
            'XK' => 'Kosovo',
            'CI' => 'Costa de Marfil',
            'CH' => 'Suiza',
            'CO' => 'Colombia',
            'CN' => 'China',
            'CM' => 'Camerún',
            'CL' => 'Chile',
            'CC' => 'Islas cocos',
            'CA' => 'Canadá',
            'CG' => 'Republica del congo',
            'CF' => 'República Centroafricana',
            'CD' => 'República Democrática del Congo',
            'CZ' => 'Republica checa',
            'CY' => 'Chipre',
            'CX' => 'Isla de Navidad',
            'CR' => 'Costa Rica',
            'CW' => 'Curazao',
            'CV' => 'Cabo Verde',
            'CU' => 'Cuba',
            'SZ' => 'Suazilandia',
            'SY' => 'Siria',
            'SX' => 'San Martín',
            'KG' => 'Kirguizstán',
            'KE' => 'Kenia',
            'SS' => 'Sudán del Sur',
            'SR' => 'Surinam',
            'KI' => 'Kiribati',
            'KH' => 'Camboya',
            'KN' => 'San Cristóbal y Nieves',
            'KM' => 'Comoras',
            'ST' => 'Santo Tomé y Príncipe',
            'SK' => 'Eslovaquia',
            'KR' => 'Corea del Sur',
            'SI' => 'Eslovenia',
            'KP' => 'Corea del Norte',
            'KW' => 'Kuwait',
            'SN' => 'Senegal',
            'SM' => 'San Marino',
            'SL' => 'Sierra Leona',
            'SC' => 'Seychelles',
            'KZ' => 'Kazajstán',
            'KY' => 'Islas Caimán',
            'SG' => 'Singapur',
            'SE' => 'Suecia',
            'SD' => 'Sudán',
            'DO' => 'República Dominicana',
            'DM' => 'Dominica',
            'DJ' => 'Djibouti',
            'DK' => 'Dinamarca',
            'VG' => 'Islas Vírgenes Británicas',
            'DE' => 'Alemania',
            'YE' => 'Yemen',
            'DZ' => 'Argelia',
            'US' => 'Estados Unidos',
            'UY' => 'Uruguay',
            'YT' => 'Mayotte',
            'UM' => 'Islas menores alejadas de los Estados Unidos',
            'LB' => 'Líbano',
            'LC' => 'Santa Lucía',
            'LA' => 'Laos',
            'TV' => 'Tuvalu',
            'TW' => 'Taiwán',
            'TT' => 'Trinidad y Tobago',
            'TR' => 'Turquía',
            'LK' => 'Sri Lanka',
            'LI' => 'Liechtenstein',
            'LV' => 'Letonia',
            'TO' => 'Tonga',
            'LT' => 'Lituania',
            'LU' => 'Luxemburgo',
            'LR' => 'Liberia',
            'LS' => 'Lesoto',
            'TH' => 'Tailandia',
            'TF' => 'Territorios Franceses del Sur',
            'TG' => 'Togo',
            'TD' => 'Chad',
            'TC' => 'Islas Turcas y Caicos',
            'LY' => 'Libia',
            'VA' => 'Vaticano',
            'VC' => 'San Vicente y las Granadinas',
            'AE' => 'Emiratos Árabes Unidos',
            'AD' => 'Andorra',
            'AG' => 'Antigua y Barbuda',
            'AF' => 'Afganistán',
            'AI' => 'Anguila',
            'VI' => 'Islas Vírgenes de EE.UU',
            'IS' => 'Islandia',
            'IR' => 'Iran',
            'AM' => 'Armenia',
            'AL' => 'Albania',
            'AO' => 'Angola',
            'AQ' => 'Antártida',
            'AS' => 'Samoa Americana',
            'AR' => 'Argentina',
            'AU' => 'Australia',
            'AT' => 'Austria',
            'AW' => 'Aruba',
            'IN' => 'India',
            'AX' => 'Islas Aland',
            'AZ' => 'Azerbaiyán',
            'IE' => 'Irlanda',
            'ID' => 'Indonesia',
            'UA' => 'Ucrania',
            'QA' => 'Katar',
            'MZ' => 'Mozambique',
        );

        $countries_fr = array(
            'BD' => 'Bangladesh',
            'BE' => 'Belgique',
            'BF' => 'Burkina Faso',
            'BG' => 'Bulgarie',
            'BA' => 'Bosnie Herzégovine',
            'BB' => 'La Barbade',
            'WF' => 'Wallis et Futuna',
            'BL' => 'Saint Barthélemy',
            'BM' => 'Bermudes',
            'BN' => 'Brunei',
            'BO' => 'Bolivie',
            'BH' => 'Bahreïn',
            'BI' => 'Burundi',
            'BJ' => 'Bénin',
            'BT' => 'Bhoutan',
            'JM' => 'Jamaïque',
            'BV' => 'Île Bouvet',
            'BW' => 'Botswana',
            'WS' => 'Samoa',
            'BQ' => 'Bonaire, Saint Eustache et Saba',
            'BR' => 'Brésil',
            'BS' => 'Bahamas',
            'JE' => 'Jersey',
            'BY' => 'Biélorussie',
            'BZ' => 'Belize',
            'RU' => 'Russie',
            'RW' => 'Rwanda',
            'RS' => 'Serbie',
            'TL' => 'Timor oriental',
            'RE' => 'Réunion',
            'TM' => 'Turkménistan',
            'TJ' => 'Tadjikistan',
            'RO' => 'Roumanie',
            'TK' => 'Tokelau',
            'GW' => 'Guinée-Bissau',
            'GU' => 'Guam',
            'GT' => 'Guatemala',
            'GS' => 'Géorgie du Sud et les îles Sandwich du Sud',
            'GR' => 'Grèce',
            'GQ' => 'Guinée Équatoriale',
            'GP' => 'La guadeloupe',
            'JP' => 'Japon',
            'GY' => 'Guyane',
            'GG' => 'Guernesey',
            'GF' => 'Guinée Française',
            'GE' => 'Géorgie',
            'GD' => 'Grenade',
            'GB' => 'Royaume-Uni',
            'GA' => 'Gabon',
            'SV' => 'Le Salvador',
            'GN' => 'Guinée',
            'GM' => 'Gambie',
            'GL' => 'Groenland',
            'GI' => 'Gibraltar',
            'GH' => 'Ghana',
            'OM' => 'Oman',
            'TN' => 'Tunisie',
            'JO' => 'Jordan',
            'HR' => 'Croatie',
            'HT' => 'Haïti',
            'HU' => 'Hongrie',
            'HK' => 'Hong Kong',
            'HN' => 'Honduras',
            'HM' => 'Îles Heard et McDonald',
            'VE' => 'Venezuela',
            'PR' => 'Porto Rico',
            'PS' => 'Territoire Palestinien',
            'PW' => 'Palau',
            'PT' => 'Portugal',
            'SJ' => 'Svalbard et Jan Mayen',
            'PY' => 'Paraguay',
            'IQ' => 'Irak',
            'PA' => 'Panama',
            'PF' => 'Polynésie française',
            'PG' => 'Papouasie Nouvelle Guinée',
            'PE' => 'Pérou',
            'PK' => 'Pakistan',
            'PH' => 'Philippines',
            'PN' => 'Pitcairn',
            'PL' => 'Pologne',
            'PM' => 'Saint Pierre et Miquelon',
            'ZM' => 'Zambie',
            'EH' => 'Sahara occidental',
            'EE' => 'Estonie',
            'EG' => 'Egypte',
            'ZA' => 'Afrique du Sud',
            'EC' => 'L\'Équateur',
            'IT' => 'Italie',
            'VN' => 'Vietnam',
            'SB' => 'Les îles Salomon',
            'ET' => 'Ethiopie',
            'SO' => 'Somalie',
            'ZW' => 'Zimbabwe',
            'SA' => 'Arabie Saoudite',
            'ES' => 'Espagne',
            'ER' => 'Erythrée',
            'ME' => 'Monténégro',
            'MD' => 'La Moldavie',
            'MG' => 'Madagascar',
            'MF' => 'Saint Martin',
            'MA' => 'Maroc',
            'MC' => 'Monaco',
            'UZ' => 'Ouzbékistan',
            'MM' => 'Myanmar',
            'ML' => 'Mali',
            'MO' => 'Macao',
            'MN' => 'Mongolie',
            'MH' => 'Iles Marshall',
            'MK' => 'Macedonia',
            'MU' => 'Maurice',
            'MT' => 'Malte',
            'MW' => 'Malawi',
            'MV' => 'Maldives',
            'MQ' => 'Martinique',
            'MP' => 'Northern Mariana Islands',
            'MS' => 'Montserrat',
            'MR' => 'Mauritanie',
            'IM' => 'Ile de Man',
            'UG' => 'Ouganda',
            'TZ' => 'Tanzanie',
            'MY' => 'Malaisie',
            'MX' => 'Mexique',
            'FR' => 'France',
            'IO' => 'Territoire britannique de l\'océan Indien',
            'SH' => 'Sainte Hélène',
            'FI' => 'Finlande',
            'FJ' => 'Fidji',
            'FK' => 'les îles Falkland',
            'FM' => 'Micronésie',
            'FO' => 'Îles Féroé',
            'NI' => 'Nicaragua',
            'NL' => 'Pays-Bas',
            'NO' => 'Norvège',
            'NA' => 'Namibie',
            'VU' => 'Vanuatu',
            'NC' => 'Nouvelle Calédonie',
            'NE' => 'Niger',
            'NF' => 'l\'ile de Norfolk',
            'NG' => 'Nigeria',
            'NZ' => 'Nouvelle-Zélande',
            'NP' => 'Népal',
            'NR' => 'Nauru',
            'NU' => 'Niue',
            'CK' => 'les Îles Cook',
            'XK' => 'Kosovo',
            'CI' => 'Côte d\'Ivoire',
            'CH' => 'Suisse',
            'CO' => 'Colombie',
            'CN' => 'Chine',
            'CM' => 'Cameroun',
            'CL' => 'Chili',
            'CC' => 'Îles Cocos',
            'CA' => 'Canada',
            'CG' => 'République du Congo',
            'CF' => 'République centrafricaine',
            'CD' => 'République Démocratique du Congo',
            'CZ' => 'République Tchèque',
            'CY' => 'Chypre',
            'CX' => 'L\'île de noël',
            'CR' => 'Costa Rica',
            'CW' => 'Curacao',
            'CV' => 'Cap-Vert',
            'CU' => 'Cuba',
            'SZ' => 'Swaziland',
            'SY' => 'Syria',
            'SX' => 'Sint Maarten',
            'KG' => 'Kirghizistan',
            'KE' => 'Kenya',
            'SS' => 'Soudan du sud',
            'SR' => 'Suriname',
            'KI' => 'Kiribati',
            'KH' => 'Cambodge',
            'KN' => 'Saint-Christophe-et-Niévès',
            'KM' => 'Comores',
            'ST' => 'Sao Tomé et Principe',
            'SK' => 'La slovaquie',
            'KR' => 'Corée du Sud',
            'SI' => 'La slovénie',
            'KP' => 'Corée du Nord',
            'KW' => 'Koweit',
            'SN' => 'Sénégal',
            'SM' => 'Saint Marin',
            'SL' => 'Sierra Leone',
            'SC' => 'les Seychelles',
            'KZ' => 'Le kazakhstan',
            'KY' => 'Îles Caïmans',
            'SG' => 'Singapour',
            'SE' => 'Suède',
            'SD' => 'Soudan',
            'DO' => 'République Dominicaine',
            'DM' => 'Dominique',
            'DJ' => 'Djibouti',
            'DK' => 'Danemark',
            'VG' => 'Îles Vierges britanniques',
            'DE' => 'Allemagne',
            'YE' => 'Yémen',
            'DZ' => 'Algérie',
            'US' => 'États Unis',
            'UY' => 'Uruguay',
            'YT' => 'Mayotte',
            'UM' => 'Îles mineures éloignées des États-Unis',
            'LB' => 'Liban',
            'LC' => 'Sainte-Lucie',
            'LA' => 'Laos',
            'TV' => 'Tuvalu',
            'TW' => 'Taïwan',
            'TT' => 'Trinité-et-Tobago',
            'TR' => 'la Turquie',
            'LK' => 'Sri Lanka',
            'LI' => 'Le Liechtenstein',
            'LV' => 'Lettonie',
            'TO' => 'Tonga',
            'LT' => 'Lituanie',
            'LU' => 'Luxembourg',
            'LR' => 'Libéria',
            'LS' => 'Lesotho',
            'TH' => 'Thaïlande',
            'TF' => 'Terres australes françaises',
            'TG' => 'Togo',
            'TD' => 'Le tchad',
            'TC' => 'îles Turques-et-Caïques',
            'LY' => 'Libye',
            'VA' => 'Vatican',
            'VC' => 'Saint-Vincent-et-les-Grenadines',
            'AE' => 'Emirats Arabes Unis',
            'AD' => 'Andorre',
            'AG' => 'Antigua-et-Barbuda',
            'AF' => 'L\'Afghanistan',
            'AI' => 'Anguilla',
            'VI' => 'Îles Vierges américaines',
            'IS' => 'Islande',
            'IR' => 'Iran',
            'AM' => 'Arménie',
            'AL' => 'Albanie',
            'AO' => 'Angola',
            'AQ' => 'Antarctique',
            'AS' => 'Samoa américaines',
            'AR' => 'Argentine',
            'AU' => 'Australie',
            'AT' => 'L\'Autriche',
            'AW' => 'Aruba',
            'IN' => 'Inde',
            'AX' => 'Iles Aland',
            'AZ' => 'Azerbaïdjan',
            'IE' => 'Irlande',
            'ID' => 'Indonésie',
            'UA' => 'Ukraine',
            'QA' => 'Qatar',
            'MZ' => 'Mozambique',
        );

        $countries_ar = array(
            'BD' => 'بنغلاديش',
            'BE' => 'بلجيكا',
            'BF' => 'بوركينا فاسو',
            'BG' => 'بلغاريا',
            'BA' => 'البوسنة والهرسك',
            'BB' => 'بربادوس',
            'WF' => 'واليس وفوتونا',
            'BL' => 'سانت بارتيليمي',
            'BM' => 'برمودا',
            'BN' => 'بروناي',
            'BO' => 'بوليفيا',
            'BH' => 'البحرين',
            'BI' => 'بوروندي',
            'BJ' => 'بنين',
            'BT' => 'بوتان',
            'JM' => 'جامايكا',
            'BV' => 'جزيرة بوفيت',
            'BW' => 'بوتسوانا',
            'WS' => 'ساموا',
            'BQ' => 'ونير وسانت اوستاتيوس وسابا',
            'BR' => 'البرازيل',
            'BS' => 'الباهاماس',
            'JE' => 'جيرسي',
            'BY' => 'روسيا البيضاء',
            'BZ' => 'بليز',
            'RU' => 'روسيا',
            'RW' => 'رواندا',
            'RS' => 'صربيا',
            'TL' => 'تيمور الشرقية',
            'RE' => 'ريونيون',
            'TM' => 'تركمانستان',
            'TJ' => 'طاجيكستان',
            'RO' => 'رومانيا',
            'TK' => 'توكيلاو',
            'GW' => 'غينيا بيساو',
            'GU' => 'غوام',
            'GT' => 'غواتيمالا',
            'GS' => 'جورجيا الجنوبية وجزر ساندويتش الجنوبية',
            'GR' => 'اليونان',
            'GQ' => 'غينيا الإستوائية',
            'GP' => 'جوادلوب',
            'JP' => 'اليابان',
            'GY' => 'غيانا',
            'GG' => 'غيرنسي',
            'GF' => 'غيانا الفرنسية',
            'GE' => 'جورجيا',
            'GD' => 'غرينادا',
            'GB' => 'المملكة المتحدة',
            'GA' => 'الغابون',
            'SV' => 'السلفادور',
            'GN' => 'غينيا',
            'GM' => 'غامبيا',
            'GL' => 'الأرض الخضراء',
            'GI' => 'جبل طارق',
            'GH' => 'غانا',
            'OM' => 'سلطنة عمان',
            'TN' => 'تونس',
            'JO' => 'الأردن',
            'HR' => 'كرواتيا',
            'HT' => 'هايتي',
            'HU' => 'المجر',
            'HK' => 'هونغ كونغ',
            'HN' => 'هندوراس',
            'HM' => 'قلب الجزيرة وجزر ماكدونالز',
            'VE' => 'فنزويلا',
            'PR' => 'بورتوريكو',
            'PS' => 'الأراضي الفلسطينية',
            'PW' => 'بالاو',
            'PT' => 'البرتغال',
            'SJ' => 'سفالبارد وجان مايان',
            'PY' => 'باراغواي',
            'IQ' => 'العراق',
            'PA' => 'بنما',
            'PF' => 'بولينيزيا الفرنسية',
            'PG' => 'بابوا غينيا الجديدة',
            'PE' => 'بيرو',
            'PK' => 'باكستان',
            'PH' => 'الفلبين',
            'PN' => 'بيتكيرن',
            'PL' => 'بولندا',
            'PM' => 'سانت بيير وميكلون',
            'ZM' => 'زامبيا',
            'EH' => 'الصحراء الغربية',
            'EE' => 'استونيا',
            'EG' => 'مصر',
            'ZA' => 'جنوب أفريقيا',
            'EC' => 'الإكوادور',
            'IT' => 'إيطاليا',
            'VN' => 'فيتنام',
            'SB' => 'جزر سليمان',
            'ET' => 'أثيوبيا',
            'SO' => 'الصومال',
            'ZW' => 'زيمبابوي',
            'SA' => 'المملكة العربية السعودية',
            'ES' => 'إسبانيا',
            'ER' => 'إريتريا',
            'ME' => 'الجبل الأسود',
            'MD' => 'مولدوفا',
            'MG' => 'مدغشقر',
            'MF' => 'القديس مارتن',
            'MA' => 'المغرب',
            'MC' => 'موناكو',
            'UZ' => 'أوزبكستان',
            'MM' => 'ميانمار',
            'ML' => 'مالي',
            'MO' => 'ماكاو',
            'MN' => 'منغوليا',
            'MH' => 'جزر مارشال',
            'MK' => 'مقدونيا',
            'MU' => 'موريشيوس',
            'MT' => 'مالطا',
            'MW' => 'مالاوي',
            'MV' => 'جزر المالديف',
            'MQ' => 'مارتينيك',
            'MP' => 'جزر مريانا الشمالية',
            'MS' => 'مونتسيرات',
            'MR' => 'موريتانيا',
            'IM' => 'جزيرة آيل أوف مان',
            'UG' => 'أوغندا',
            'TZ' => 'تنزانيا',
            'MY' => 'ماليزيا',
            'MX' => 'المكسيك',
            'FR' => 'فرنسا',
            'IO' => 'إقليم المحيط البريطاني الهندي',
            'SH' => 'سانت هيلانة',
            'FI' => 'فنلندا',
            'FJ' => 'فيجي',
            'FK' => 'جزر فوكلاند',
            'FM' => 'ميكرونيزيا',
            'FO' => 'جزر فارو',
            'NI' => 'نيكاراغوا',
            'NL' => 'هولندا',
            'NO' => 'النرويج',
            'NA' => 'ناميبيا',
            'VU' => 'فانواتو',
            'NC' => 'كاليدونيا الجديدة',
            'NE' => 'النيجر',
            'NF' => 'جزيرة نورفولك',
            'NG' => 'نيجيريا',
            'NZ' => 'نيوزيلاندا',
            'NP' => 'نيبال',
            'NR' => 'ناورو',
            'NU' => 'نيوي',
            'CK' => 'جزر كوك',
            'XK' => 'كوسوفو',
            'CI' => 'ساحل العاج',
            'CH' => 'سويسرا',
            'CO' => 'كولومبيا',
            'CN' => 'الصين',
            'CM' => 'الكاميرون',
            'CL' => 'تشيلي',
            'CC' => 'جزر كوكوس',
            'CA' => 'كندا',
            'CG' => 'جمهورية الكونغو',
            'CF' => 'جمهورية افريقيا الوسطى',
            'CD' => 'جمهورية الكونغو الديموقراطية',
            'CZ' => 'جمهورية التشيك',
            'CY' => 'قبرص',
            'CX' => 'جزيرة الكريسماس',
            'CR' => 'كوستا ريكا',
            'CW' => 'كوراكاو',
            'CV' => 'الرأس الأخضر',
            'CU' => 'كوبا',
            'SZ' => 'سوازيلاند',
            'SY' => 'سوريا',
            'SX' => 'سينت مارتن',
            'KG' => 'قرغيزستان',
            'KE' => 'كينيا',
            'SS' => 'جنوب السودان',
            'SR' => 'سورينام',
            'KI' => 'كيريباس',
            'KH' => 'كمبوديا',
            'KN' => 'سانت كيتس ونيفيس',
            'KM' => 'جزر القمر',
            'ST' => 'ساو تومي وبرنسيبي',
            'SK' => 'سلوفاكيا',
            'KR' => 'كوريا الجنوبية',
            'SI' => 'سلوفينيا',
            'KP' => 'كوريا الشمالية',
            'KW' => 'الكويت',
            'SN' => 'السنغال',
            'SM' => 'سان مارينو',
            'SL' => 'سيرا ليون',
            'SC' => 'سيشيل',
            'KZ' => 'كازاخستان',
            'KY' => 'جزر كايمان',
            'SG' => 'سنغافورة',
            'SE' => 'السويد',
            'SD' => 'سودان',
            'DO' => 'جمهورية الدومنيكان',
            'DM' => 'دومينيكا',
            'DJ' => 'جيبوتي',
            'DK' => 'الدنمارك',
            'VG' => 'جزر فيرجن البريطانية',
            'DE' => 'ألمانيا',
            'YE' => 'اليمن',
            'DZ' => 'الجزائر',
            'US' => 'الولايات المتحدة الأمريكية',
            'UY' => 'أوروغواي',
            'YT' => 'مايوت',
            'UM' => 'جزر الولايات المتحدة البعيدة الصغرى',
            'LB' => 'لبنان',
            'LC' => 'القديسة لوسيا',
            'LA' => 'لاوس',
            'TV' => 'توفالو',
            'TW' => 'تايوان',
            'TT' => 'ترينداد وتوباغو',
            'TR' => 'تركيا',
            'LK' => 'سيريلانكا',
            'LI' => 'ليختنشتاين',
            'LV' => 'لاتفيا',
            'TO' => 'تونغا',
            'LT' => 'ليتوانيا',
            'LU' => 'لوكسمبورغ',
            'LR' => 'ليبيريا',
            'LS' => 'ليسوتو',
            'TH' => 'تايلاند',
            'TF' => 'المناطق الجنوبية لفرنسا',
            'TG' => 'توغو',
            'TD' => 'تشاد',
            'TC' => 'جزر تركس وكايكوس',
            'LY' => 'ليبيا',
            'VA' => 'الفاتيكان',
            'VC' => 'سانت فنسنت وجزر غرينادين',
            'AE' => 'الإمارات العربية المتحدة',
            'AD' => 'أندورا',
            'AG' => 'أنتيغوا وبربودا',
            'AF' => 'أفغانستان',
            'AI' => 'أنغيلا',
            'VI' => 'جزر فيرجن الأمريكية',
            'IS' => 'أيسلندا',
            'IR' => 'إيران',
            'AM' => 'أرمينيا',
            'AL' => 'ألبانيا',
            'AO' => 'أنغولا',
            'AQ' => 'القارة القطبية الجنوبية',
            'AS' => 'ساموا الأمريكية',
            'AR' => 'الأرجنتين',
            'AU' => 'أستراليا',
            'AT' => 'النمسا',
            'AW' => 'أروبا',
            'IN' => 'الهند',
            'AX' => 'جزر آلاند',
            'AZ' => 'أذربيجان',
            'IE' => 'أيرلندا',
            'ID' => 'أندونيسيا',
            'UA' => 'أوكرانيا',
            'QA' => 'دولة قطر',
            'MZ' => 'موزمبيق',
        );

        foreach ($countries_en as $code => $countryname) {
            $country = new Country();
            $country->setCode($code);

            $country->translate('en')->setName($countryname);
            $country->translate('zh')->setName($countries_zh[$code]);
            $country->translate('es')->setName($countries_es[$code]);
            $country->translate('fr')->setName($countries_fr[$code]);
            $country->translate('ar')->setName($countries_ar[$code]);
            $country->mergeNewTranslations();
            $manager->persist($country);
        }

        $manager->flush();
    }

}
