<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20200523204709 extends AbstractMigration
{
    public function getDescription() : string
    {
        return '';
    }

    public function up(Schema $schema) : void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('CREATE TABLE eventic_amenity (id INT AUTO_INCREMENT NOT NULL, icon VARCHAR(50) NOT NULL, hidden TINYINT(1) NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_amenity_translation (id INT AUTO_INCREMENT NOT NULL, translatable_id INT DEFAULT NULL, name VARCHAR(50) NOT NULL, slug VARCHAR(80) NOT NULL, locale VARCHAR(255) NOT NULL, UNIQUE INDEX UNIQ_3C354FF8989D9B62 (slug), INDEX IDX_3C354FF82C2AC5D3 (translatable_id), UNIQUE INDEX eventic_amenity_translation_unique_translation (translatable_id, locale), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_audience (id INT AUTO_INCREMENT NOT NULL, image_name VARCHAR(50) DEFAULT NULL, image_size INT DEFAULT NULL, image_mime_type VARCHAR(50) DEFAULT NULL, image_original_name VARCHAR(1000) DEFAULT NULL, image_dimensions LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:simple_array)\', hidden TINYINT(1) NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_audience_translation (id INT AUTO_INCREMENT NOT NULL, translatable_id INT DEFAULT NULL, name VARCHAR(50) NOT NULL, slug VARCHAR(80) NOT NULL, locale VARCHAR(255) NOT NULL, UNIQUE INDEX UNIQ_5CF81D36989D9B62 (slug), INDEX IDX_5CF81D362C2AC5D3 (translatable_id), UNIQUE INDEX eventic_audience_translation_unique_translation (translatable_id, locale), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_blog_post (id INT AUTO_INCREMENT NOT NULL, category_id INT DEFAULT NULL, readtime INT DEFAULT NULL, image_name VARCHAR(50) DEFAULT NULL, image_size INT DEFAULT NULL, image_mime_type VARCHAR(50) DEFAULT NULL, image_original_name VARCHAR(1000) DEFAULT NULL, image_dimensions LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:simple_array)\', views INT DEFAULT NULL, hidden TINYINT(1) NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, INDEX IDX_E66028C712469DE2 (category_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_blog_post_category (id INT AUTO_INCREMENT NOT NULL, hidden TINYINT(1) NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_blog_post_category_translation (id INT AUTO_INCREMENT NOT NULL, translatable_id INT DEFAULT NULL, name VARCHAR(50) NOT NULL, slug VARCHAR(80) NOT NULL, locale VARCHAR(255) NOT NULL, UNIQUE INDEX UNIQ_BAF151EA989D9B62 (slug), INDEX IDX_BAF151EA2C2AC5D3 (translatable_id), UNIQUE INDEX eventic_blog_post_category_translation_unique_translation (translatable_id, locale), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_blog_post_translation (id INT AUTO_INCREMENT NOT NULL, translatable_id INT DEFAULT NULL, name VARCHAR(80) NOT NULL, content LONGTEXT NOT NULL, tags VARCHAR(500) DEFAULT NULL, slug VARCHAR(100) NOT NULL, locale VARCHAR(255) NOT NULL, UNIQUE INDEX UNIQ_6A7C548D989D9B62 (slug), INDEX IDX_6A7C548D2C2AC5D3 (translatable_id), UNIQUE INDEX eventic_blog_post_translation_unique_translation (translatable_id, locale), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_cart_element (id INT AUTO_INCREMENT NOT NULL, user_id INT DEFAULT NULL, eventticket_id INT DEFAULT NULL, quantity INT DEFAULT NULL, ticket_fee NUMERIC(10, 2) DEFAULT NULL, created_at DATETIME NOT NULL, updated_at DATETIME DEFAULT NULL, INDEX IDX_FFABA270A76ED395 (user_id), INDEX IDX_FFABA270182CEB62 (eventticket_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_category (id INT AUTO_INCREMENT NOT NULL, icon VARCHAR(50) NOT NULL, image_name VARCHAR(50) DEFAULT NULL, image_size INT DEFAULT NULL, image_mime_type VARCHAR(50) DEFAULT NULL, image_original_name VARCHAR(1000) DEFAULT NULL, image_dimensions LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:simple_array)\', hidden TINYINT(1) NOT NULL, featured TINYINT(1) NOT NULL, featuredorder INT DEFAULT NULL, created_at DATETIME NOT NULL, updated_at DATETIME DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_category_translation (id INT AUTO_INCREMENT NOT NULL, translatable_id INT DEFAULT NULL, name VARCHAR(50) NOT NULL, slug VARCHAR(80) NOT NULL, locale VARCHAR(255) NOT NULL, UNIQUE INDEX UNIQ_3CFC55AB989D9B62 (slug), INDEX IDX_3CFC55AB2C2AC5D3 (translatable_id), UNIQUE INDEX eventic_category_translation_unique_translation (translatable_id, locale), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_comment (id INT AUTO_INCREMENT NOT NULL, thread_id VARCHAR(255) DEFAULT NULL, author_id INT DEFAULT NULL, body LONGTEXT NOT NULL, ancestors VARCHAR(1024) NOT NULL, depth INT NOT NULL, created_at DATETIME NOT NULL, state INT NOT NULL, score INT NOT NULL, INDEX IDX_E58109F5E2904019 (thread_id), INDEX IDX_E58109F5F675F31B (author_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_country (id INT AUTO_INCREMENT NOT NULL, code VARCHAR(2) NOT NULL, hidden TINYINT(1) NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_country_translation (id INT AUTO_INCREMENT NOT NULL, translatable_id INT DEFAULT NULL, name VARCHAR(50) NOT NULL, slug VARCHAR(80) NOT NULL, locale VARCHAR(255) NOT NULL, UNIQUE INDEX UNIQ_1AAA1D02989D9B62 (slug), INDEX IDX_1AAA1D022C2AC5D3 (translatable_id), UNIQUE INDEX eventic_country_translation_unique_translation (translatable_id, locale), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_currency (id INT AUTO_INCREMENT NOT NULL, ccy VARCHAR(3) NOT NULL, symbol VARCHAR(50) DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_event (id INT AUTO_INCREMENT NOT NULL, category_id INT DEFAULT NULL, country_id INT DEFAULT NULL, organizer_id INT DEFAULT NULL, isonhomepageslider_id INT DEFAULT NULL, reference VARCHAR(255) NOT NULL, views INT NOT NULL, youtubeurl VARCHAR(255) DEFAULT NULL, externallink VARCHAR(255) DEFAULT NULL, phonenumber VARCHAR(50) DEFAULT NULL, email VARCHAR(255) DEFAULT NULL, twitter VARCHAR(255) DEFAULT NULL, instagram VARCHAR(255) DEFAULT NULL, facebook VARCHAR(255) DEFAULT NULL, googleplus VARCHAR(255) DEFAULT NULL, linkedin VARCHAR(255) DEFAULT NULL, artists VARCHAR(500) DEFAULT NULL, tags VARCHAR(500) DEFAULT NULL, year VARCHAR(5) DEFAULT NULL, image_name VARCHAR(50) DEFAULT NULL, image_size INT DEFAULT NULL, image_mime_type VARCHAR(50) DEFAULT NULL, image_original_name VARCHAR(1000) DEFAULT NULL, image_dimensions LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:simple_array)\', created_at DATETIME NOT NULL, updated_at DATETIME DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, published TINYINT(1) NOT NULL, enablereviews TINYINT(1) NOT NULL, showattendees TINYINT(1) NOT NULL, INDEX IDX_E1933DCB12469DE2 (category_id), INDEX IDX_E1933DCBF92F3E70 (country_id), INDEX IDX_E1933DCB876C4DDA (organizer_id), INDEX IDX_E1933DCB376C51EF (isonhomepageslider_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_event_language (Event_id INT NOT NULL, Language_Id INT NOT NULL, INDEX IDX_DD794B6A88818ADD (Event_id), INDEX IDX_DD794B6A91E91181 (Language_Id), PRIMARY KEY(Event_id, Language_Id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_event_subtitle (Event_id INT NOT NULL, Language_Id INT NOT NULL, INDEX IDX_5827AD6E88818ADD (Event_id), INDEX IDX_5827AD6E91E91181 (Language_Id), PRIMARY KEY(Event_id, Language_Id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_event_audience (Event_id INT NOT NULL, Audience_Id INT NOT NULL, INDEX IDX_F46FAEC788818ADD (Event_id), INDEX IDX_F46FAEC797946D63 (Audience_Id), PRIMARY KEY(Event_id, Audience_Id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_favorites (Event_id INT NOT NULL, User_Id INT NOT NULL, INDEX IDX_B853A82F88818ADD (Event_id), INDEX IDX_B853A82FFD57CEAB (User_Id), PRIMARY KEY(Event_id, User_Id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_event_date (id INT AUTO_INCREMENT NOT NULL, event_id INT DEFAULT NULL, venue_id INT DEFAULT NULL, online TINYINT(1) NOT NULL, active TINYINT(1) NOT NULL, reference VARCHAR(10) NOT NULL, startdate DATETIME DEFAULT NULL, enddate DATETIME DEFAULT NULL, INDEX IDX_D30F7AD371F7E88B (event_id), INDEX IDX_D30F7AD340A73EBA (venue_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_eventdate_scanner (eventdate_id INT NOT NULL, scanner_id INT NOT NULL, INDEX IDX_A9110493733DA6BA (eventdate_id), INDEX IDX_A911049367C89E33 (scanner_id), PRIMARY KEY(eventdate_id, scanner_id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_eventdate_pointofsale (eventdate_id INT NOT NULL, pointofsale_id INT NOT NULL, INDEX IDX_7E37EBFC733DA6BA (eventdate_id), INDEX IDX_7E37EBFC18E07BF3 (pointofsale_id), PRIMARY KEY(eventdate_id, pointofsale_id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_event_image (id INT AUTO_INCREMENT NOT NULL, event_id INT DEFAULT NULL, image_name VARCHAR(50) DEFAULT NULL, image_size INT DEFAULT NULL, image_mime_type VARCHAR(50) DEFAULT NULL, image_original_name VARCHAR(1000) DEFAULT NULL, image_dimensions LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:simple_array)\', position INT DEFAULT NULL, updated_at DATETIME DEFAULT NULL, INDEX IDX_6A4E8E5E71F7E88B (event_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_event_date_ticket (id INT AUTO_INCREMENT NOT NULL, eventdate_id INT DEFAULT NULL, active TINYINT(1) NOT NULL, reference VARCHAR(10) NOT NULL, name VARCHAR(50) NOT NULL, description VARCHAR(255) DEFAULT NULL, free TINYINT(1) NOT NULL, price NUMERIC(10, 2) DEFAULT NULL, promotionalprice NUMERIC(10, 2) DEFAULT NULL, quantity INT DEFAULT NULL, ticketsperattendee INT DEFAULT NULL, salesstartdate DATETIME DEFAULT NULL, salesenddate DATETIME DEFAULT NULL, position INT NOT NULL, INDEX IDX_E8B0FCF9733DA6BA (eventdate_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_event_translation (id INT AUTO_INCREMENT NOT NULL, translatable_id INT DEFAULT NULL, name VARCHAR(100) NOT NULL, description LONGTEXT DEFAULT NULL, slug VARCHAR(150) NOT NULL, locale VARCHAR(255) NOT NULL, UNIQUE INDEX UNIQ_2FCD2BD6989D9B62 (slug), INDEX IDX_2FCD2BD62C2AC5D3 (translatable_id), UNIQUE INDEX eventic_event_translation_unique_translation (translatable_id, locale), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_help_center_article (id INT AUTO_INCREMENT NOT NULL, category_id INT DEFAULT NULL, views INT DEFAULT NULL, hidden TINYINT(1) NOT NULL, featured TINYINT(1) NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, INDEX IDX_75F977E312469DE2 (category_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_help_center_article_translation (id INT AUTO_INCREMENT NOT NULL, translatable_id INT DEFAULT NULL, title VARCHAR(80) NOT NULL, slug VARCHAR(100) NOT NULL, content LONGTEXT NOT NULL, tags VARCHAR(150) DEFAULT NULL, locale VARCHAR(255) NOT NULL, UNIQUE INDEX UNIQ_54AB4030989D9B62 (slug), INDEX IDX_54AB40302C2AC5D3 (translatable_id), UNIQUE INDEX eventic_help_center_article_translation_unique_translation (translatable_id, locale), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_help_center_category (id INT AUTO_INCREMENT NOT NULL, parent_id INT DEFAULT NULL, icon VARCHAR(50) DEFAULT NULL, hidden TINYINT(1) NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, INDEX IDX_9BE9AD17727ACA70 (parent_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_help_center_category_translation (id INT AUTO_INCREMENT NOT NULL, translatable_id INT DEFAULT NULL, name VARCHAR(50) NOT NULL, slug VARCHAR(80) NOT NULL, locale VARCHAR(255) NOT NULL, UNIQUE INDEX UNIQ_2B8AFEF5989D9B62 (slug), INDEX IDX_2B8AFEF52C2AC5D3 (translatable_id), UNIQUE INDEX eventic_help_center_category_translation_unique_translation (translatable_id, locale), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_homepage_hero_setting (id INT AUTO_INCREMENT NOT NULL, content VARCHAR(15) NOT NULL, custom_background_name VARCHAR(50) DEFAULT NULL, custom_background_size INT DEFAULT NULL, custom_background_mime_type VARCHAR(50) DEFAULT NULL, custom_background_original_name VARCHAR(1000) DEFAULT NULL, custom_background_dimensions LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:simple_array)\', show_search_box TINYINT(1) DEFAULT NULL, updated_at DATETIME DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_homepage_hero_setting_translation (id INT AUTO_INCREMENT NOT NULL, translatable_id INT DEFAULT NULL, title VARCHAR(100) DEFAULT NULL, paragraph VARCHAR(500) DEFAULT NULL, locale VARCHAR(255) NOT NULL, INDEX IDX_5DD4B1372C2AC5D3 (translatable_id), UNIQUE INDEX eventic_homepage_hero_setting_translation_unique_translation (translatable_id, locale), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_language (id INT AUTO_INCREMENT NOT NULL, code VARCHAR(2) NOT NULL, hidden TINYINT(1) NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_language_translation (id INT AUTO_INCREMENT NOT NULL, translatable_id INT DEFAULT NULL, name VARCHAR(50) NOT NULL, slug VARCHAR(80) NOT NULL, locale VARCHAR(255) NOT NULL, UNIQUE INDEX UNIQ_E8216272989D9B62 (slug), INDEX IDX_E82162722C2AC5D3 (translatable_id), UNIQUE INDEX eventic_language_translation_unique_translation (translatable_id, locale), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_order (id INT AUTO_INCREMENT NOT NULL, user_id INT DEFAULT NULL, paymentgateway_id INT DEFAULT NULL, payment_id INT DEFAULT NULL, reference VARCHAR(15) NOT NULL, note VARCHAR(1000) DEFAULT NULL, status INT NOT NULL, ticket_fee NUMERIC(10, 2) NOT NULL, ticket_price_percentage_cut INT NOT NULL, currency_ccy VARCHAR(10) NOT NULL, currency_symbol VARCHAR(10) NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, INDEX IDX_2F14A4F4A76ED395 (user_id), INDEX IDX_2F14A4F459CA0035 (paymentgateway_id), UNIQUE INDEX UNIQ_2F14A4F44C3A3BB (payment_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_order_element (id INT AUTO_INCREMENT NOT NULL, order_id INT DEFAULT NULL, eventticket_id INT DEFAULT NULL, unitprice NUMERIC(10, 2) DEFAULT NULL, quantity INT DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, INDEX IDX_261BAAD18D9F6D38 (order_id), INDEX IDX_261BAAD1182CEB62 (eventticket_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_order_ticket (id INT AUTO_INCREMENT NOT NULL, orderelement_id INT DEFAULT NULL, reference VARCHAR(20) NOT NULL, scanned TINYINT(1) NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, INDEX IDX_111E8938EE04F0C1 (orderelement_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_organizer (id INT AUTO_INCREMENT NOT NULL, user_id INT DEFAULT NULL, country_id INT DEFAULT NULL, name VARCHAR(25) NOT NULL, slug VARCHAR(35) NOT NULL, description VARCHAR(1000) DEFAULT NULL, website VARCHAR(50) DEFAULT NULL, email VARCHAR(50) DEFAULT NULL, phone VARCHAR(50) DEFAULT NULL, facebook VARCHAR(100) DEFAULT NULL, twitter VARCHAR(100) DEFAULT NULL, instagram VARCHAR(100) DEFAULT NULL, googleplus VARCHAR(100) DEFAULT NULL, linkedin VARCHAR(100) DEFAULT NULL, youtubeurl VARCHAR(255) DEFAULT NULL, logo_name VARCHAR(50) DEFAULT NULL, logo_size INT DEFAULT NULL, logo_mime_type VARCHAR(50) DEFAULT NULL, logo_original_name VARCHAR(1000) DEFAULT NULL, logo_dimensions LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:simple_array)\', cover_name VARCHAR(50) DEFAULT NULL, cover_size INT DEFAULT NULL, cover_mime_type VARCHAR(50) DEFAULT NULL, cover_original_name VARCHAR(1000) DEFAULT NULL, cover_dimensions LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:simple_array)\', created_at DATETIME NOT NULL, updated_at DATETIME DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, views INT NOT NULL, showvenuesmap TINYINT(1) NOT NULL, showfollowers TINYINT(1) NOT NULL, showreviews TINYINT(1) NOT NULL, show_event_date_stats_on_scanner_app TINYINT(1) DEFAULT NULL, allow_tap_to_check_in_on_scanner_app TINYINT(1) DEFAULT NULL, UNIQUE INDEX UNIQ_C5EEB9A9989D9B62 (slug), UNIQUE INDEX UNIQ_C5EEB9A9A76ED395 (user_id), INDEX IDX_C5EEB9A9F92F3E70 (country_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_organizer_category (Organizer_id INT NOT NULL, Category_Id INT NOT NULL, INDEX IDX_BB88F7D79F5D9622 (Organizer_id), INDEX IDX_BB88F7D715E3697 (Category_Id), PRIMARY KEY(Organizer_id, Category_Id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_following (Organizer_id INT NOT NULL, User_Id INT NOT NULL, INDEX IDX_2D8545399F5D9622 (Organizer_id), INDEX IDX_2D854539FD57CEAB (User_Id), PRIMARY KEY(Organizer_id, User_Id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_page (id INT AUTO_INCREMENT NOT NULL, updated_at DATETIME DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_page_translation (id INT AUTO_INCREMENT NOT NULL, translatable_id INT DEFAULT NULL, title VARCHAR(35) NOT NULL, slug VARCHAR(70) NOT NULL, content LONGTEXT DEFAULT NULL, locale VARCHAR(255) NOT NULL, UNIQUE INDEX UNIQ_3B97CBF2989D9B62 (slug), INDEX IDX_3B97CBF22C2AC5D3 (translatable_id), UNIQUE INDEX eventic_page_translation_unique_translation (translatable_id, locale), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_payment (id INT AUTO_INCREMENT NOT NULL, order_id INT DEFAULT NULL, country_id INT DEFAULT NULL, number VARCHAR(255) DEFAULT NULL, description VARCHAR(255) DEFAULT NULL, client_email VARCHAR(255) DEFAULT NULL, client_id VARCHAR(255) DEFAULT NULL, total_amount INT DEFAULT NULL, currency_code VARCHAR(255) DEFAULT NULL, details JSON NOT NULL COMMENT \'(DC2Type:json_array)\', firstname VARCHAR(20) DEFAULT NULL, lastname VARCHAR(20) DEFAULT NULL, state VARCHAR(50) DEFAULT NULL, city VARCHAR(50) DEFAULT NULL, postalcode VARCHAR(50) DEFAULT NULL, street VARCHAR(50) DEFAULT NULL, street2 VARCHAR(50) DEFAULT NULL, created_at DATETIME NOT NULL, updated_at DATETIME DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, UNIQUE INDEX UNIQ_1CDDDF948D9F6D38 (order_id), INDEX IDX_1CDDDF94F92F3E70 (country_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_payment_gateway (id INT AUTO_INCREMENT NOT NULL, organizer_id INT DEFAULT NULL, gateway_name VARCHAR(255) NOT NULL, factory_name VARCHAR(255) NOT NULL, config JSON NOT NULL COMMENT \'(DC2Type:json_array)\', name VARCHAR(50) NOT NULL, slug VARCHAR(70) NOT NULL, gateway_logo_name VARCHAR(255) DEFAULT NULL, enabled TINYINT(1) NOT NULL, number INT DEFAULT NULL, updated_at DATETIME NOT NULL, UNIQUE INDEX UNIQ_9D4780D7989D9B62 (slug), INDEX IDX_9D4780D7876C4DDA (organizer_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_payment_token (hash VARCHAR(255) NOT NULL, details LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:object)\', after_url LONGTEXT DEFAULT NULL, target_url LONGTEXT NOT NULL, gateway_name VARCHAR(255) NOT NULL, PRIMARY KEY(hash)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_payout_request (id INT AUTO_INCREMENT NOT NULL, organizer_id INT DEFAULT NULL, payment_gateway_id INT DEFAULT NULL, event_date_id INT DEFAULT NULL, payment JSON DEFAULT NULL COMMENT \'(DC2Type:json_array)\', reference VARCHAR(15) NOT NULL, note VARCHAR(1000) DEFAULT NULL, status INT NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, INDEX IDX_4AE2AE43876C4DDA (organizer_id), INDEX IDX_4AE2AE4362890FD5 (payment_gateway_id), INDEX IDX_4AE2AE433DC09FC4 (event_date_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_pointofsale (id INT AUTO_INCREMENT NOT NULL, organizer_id INT DEFAULT NULL, user_id INT DEFAULT NULL, name VARCHAR(25) NOT NULL, INDEX IDX_5D78D6FA876C4DDA (organizer_id), UNIQUE INDEX UNIQ_5D78D6FAA76ED395 (user_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_review (id INT AUTO_INCREMENT NOT NULL, event_id INT DEFAULT NULL, user_id INT DEFAULT NULL, rating INT NOT NULL, headline VARCHAR(100) DEFAULT NULL, slug VARCHAR(120) NOT NULL, details VARCHAR(500) DEFAULT NULL, created_at DATETIME NOT NULL, updated_at DATETIME DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, visible TINYINT(1) NOT NULL, UNIQUE INDEX UNIQ_3D9D9182989D9B62 (slug), INDEX IDX_3D9D918271F7E88B (event_id), INDEX IDX_3D9D9182A76ED395 (user_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_scanner (id INT AUTO_INCREMENT NOT NULL, organizer_id INT DEFAULT NULL, user_id INT DEFAULT NULL, name VARCHAR(25) NOT NULL, INDEX IDX_241A84B0876C4DDA (organizer_id), UNIQUE INDEX UNIQ_241A84B0A76ED395 (user_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_settings (id INT AUTO_INCREMENT NOT NULL, `key` VARCHAR(50) NOT NULL, value VARCHAR(500) DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_thread (id VARCHAR(255) NOT NULL, permalink VARCHAR(255) NOT NULL, is_commentable TINYINT(1) NOT NULL, num_comments INT NOT NULL, last_comment_at DATETIME DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_ticket_reservation (id INT AUTO_INCREMENT NOT NULL, eventticket_id INT DEFAULT NULL, user_id INT DEFAULT NULL, orderelement_id INT DEFAULT NULL, quantity INT DEFAULT NULL, created_at DATETIME NOT NULL, expires_at DATETIME NOT NULL, deleted_at DATETIME DEFAULT NULL, INDEX IDX_716DEA9F182CEB62 (eventticket_id), INDEX IDX_716DEA9FA76ED395 (user_id), INDEX IDX_716DEA9FEE04F0C1 (orderelement_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_user (id INT AUTO_INCREMENT NOT NULL, organizer_id INT DEFAULT NULL, scanner_id INT DEFAULT NULL, pointofsale_id INT DEFAULT NULL, isorganizeronhomepageslider_id INT DEFAULT NULL, country_id INT DEFAULT NULL, username VARCHAR(180) NOT NULL, username_canonical VARCHAR(180) NOT NULL, email VARCHAR(180) NOT NULL, email_canonical VARCHAR(180) NOT NULL, enabled TINYINT(1) NOT NULL, salt VARCHAR(255) DEFAULT NULL, password VARCHAR(255) NOT NULL, last_login DATETIME DEFAULT NULL, confirmation_token VARCHAR(180) DEFAULT NULL, password_requested_at DATETIME DEFAULT NULL, roles LONGTEXT NOT NULL COMMENT \'(DC2Type:array)\', gender VARCHAR(10) DEFAULT NULL, firstname VARCHAR(20) DEFAULT NULL, lastname VARCHAR(20) DEFAULT NULL, slug VARCHAR(30) NOT NULL, street VARCHAR(50) DEFAULT NULL, street2 VARCHAR(50) DEFAULT NULL, city VARCHAR(50) DEFAULT NULL, state VARCHAR(50) DEFAULT NULL, postalcode VARCHAR(15) DEFAULT NULL, phone VARCHAR(50) DEFAULT NULL, birthdate DATE DEFAULT NULL, avatar_name VARCHAR(50) DEFAULT NULL, avatar_size INT DEFAULT NULL, avatar_mime_type VARCHAR(50) DEFAULT NULL, avatar_original_name VARCHAR(1000) DEFAULT NULL, avatar_dimensions LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:simple_array)\', created_at DATETIME NOT NULL, updated_at DATETIME DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, facebook_id VARCHAR(255) DEFAULT NULL, facebook_access_token VARCHAR(255) DEFAULT NULL, google_id VARCHAR(255) DEFAULT NULL, google_access_token VARCHAR(255) DEFAULT NULL, api_key VARCHAR(255) DEFAULT NULL, UNIQUE INDEX UNIQ_D01C6A2292FC23A8 (username_canonical), UNIQUE INDEX UNIQ_D01C6A22A0D96FBF (email_canonical), UNIQUE INDEX UNIQ_D01C6A22C05FB297 (confirmation_token), UNIQUE INDEX UNIQ_D01C6A22989D9B62 (slug), UNIQUE INDEX UNIQ_D01C6A22C912ED9D (api_key), UNIQUE INDEX UNIQ_D01C6A22876C4DDA (organizer_id), UNIQUE INDEX UNIQ_D01C6A2267C89E33 (scanner_id), UNIQUE INDEX UNIQ_D01C6A2218E07BF3 (pointofsale_id), INDEX IDX_D01C6A22F2709FF9 (isorganizeronhomepageslider_id), INDEX IDX_D01C6A22F92F3E70 (country_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_venue (id INT AUTO_INCREMENT NOT NULL, organizer_id INT DEFAULT NULL, type_id INT DEFAULT NULL, country_id INT DEFAULT NULL, seatedguests INT DEFAULT NULL, standingguests INT DEFAULT NULL, neighborhoods VARCHAR(100) DEFAULT NULL, foodbeverage VARCHAR(500) DEFAULT NULL, pricing VARCHAR(500) DEFAULT NULL, availibility VARCHAR(500) DEFAULT NULL, hidden TINYINT(1) NOT NULL, showmap TINYINT(1) NOT NULL, quoteform TINYINT(1) NOT NULL, street VARCHAR(50) NOT NULL, street2 VARCHAR(50) DEFAULT NULL, city VARCHAR(50) NOT NULL, state VARCHAR(50) NOT NULL, postalcode VARCHAR(15) NOT NULL, lat VARCHAR(255) DEFAULT NULL, lng VARCHAR(255) DEFAULT NULL, listedondirectory TINYINT(1) NOT NULL, contactemail VARCHAR(50) DEFAULT NULL, created_at DATETIME NOT NULL, updated_at DATETIME DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, INDEX IDX_4BAC2C61876C4DDA (organizer_id), INDEX IDX_4BAC2C61C54C8C93 (type_id), INDEX IDX_4BAC2C61F92F3E70 (country_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_venue_amenity (Venue_id INT NOT NULL, Amenity_Id INT NOT NULL, INDEX IDX_8A89D31EB9D15CEC (Venue_id), INDEX IDX_8A89D31E45463477 (Amenity_Id), PRIMARY KEY(Venue_id, Amenity_Id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_venue_image (id INT AUTO_INCREMENT NOT NULL, venue_id INT DEFAULT NULL, image_name VARCHAR(50) DEFAULT NULL, image_size INT DEFAULT NULL, image_mime_type VARCHAR(50) DEFAULT NULL, image_original_name VARCHAR(1000) DEFAULT NULL, image_dimensions LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:simple_array)\', position INT DEFAULT NULL, updated_at DATETIME DEFAULT NULL, INDEX IDX_F3EE32A540A73EBA (venue_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_venue_translation (id INT AUTO_INCREMENT NOT NULL, translatable_id INT DEFAULT NULL, name VARCHAR(50) NOT NULL, description LONGTEXT NOT NULL, slug VARCHAR(80) NOT NULL, locale VARCHAR(255) NOT NULL, UNIQUE INDEX UNIQ_3A06BD63989D9B62 (slug), INDEX IDX_3A06BD632C2AC5D3 (translatable_id), UNIQUE INDEX eventic_venue_translation_unique_translation (translatable_id, locale), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_venue_type (id INT AUTO_INCREMENT NOT NULL, hidden TINYINT(1) NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_venue_type_translation (id INT AUTO_INCREMENT NOT NULL, translatable_id INT DEFAULT NULL, name VARCHAR(50) NOT NULL, slug VARCHAR(80) NOT NULL, locale VARCHAR(255) NOT NULL, UNIQUE INDEX UNIQ_9FD9786F989D9B62 (slug), INDEX IDX_9FD9786F2C2AC5D3 (translatable_id), UNIQUE INDEX eventic_venue_type_translation_unique_translation (translatable_id, locale), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE eventic_vote (id INT AUTO_INCREMENT NOT NULL, comment_id INT DEFAULT NULL, voter_id INT DEFAULT NULL, created_at DATETIME NOT NULL, value INT NOT NULL, INDEX IDX_79F390FF8697D13 (comment_id), INDEX IDX_79F390FEBB4B8AD (voter_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('ALTER TABLE eventic_amenity_translation ADD CONSTRAINT FK_3C354FF82C2AC5D3 FOREIGN KEY (translatable_id) REFERENCES eventic_amenity (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE eventic_audience_translation ADD CONSTRAINT FK_5CF81D362C2AC5D3 FOREIGN KEY (translatable_id) REFERENCES eventic_audience (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE eventic_blog_post ADD CONSTRAINT FK_E66028C712469DE2 FOREIGN KEY (category_id) REFERENCES eventic_blog_post_category (id)');
        $this->addSql('ALTER TABLE eventic_blog_post_category_translation ADD CONSTRAINT FK_BAF151EA2C2AC5D3 FOREIGN KEY (translatable_id) REFERENCES eventic_blog_post_category (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE eventic_blog_post_translation ADD CONSTRAINT FK_6A7C548D2C2AC5D3 FOREIGN KEY (translatable_id) REFERENCES eventic_blog_post (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE eventic_cart_element ADD CONSTRAINT FK_FFABA270A76ED395 FOREIGN KEY (user_id) REFERENCES eventic_user (id)');
        $this->addSql('ALTER TABLE eventic_cart_element ADD CONSTRAINT FK_FFABA270182CEB62 FOREIGN KEY (eventticket_id) REFERENCES eventic_event_date_ticket (id)');
        $this->addSql('ALTER TABLE eventic_category_translation ADD CONSTRAINT FK_3CFC55AB2C2AC5D3 FOREIGN KEY (translatable_id) REFERENCES eventic_category (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE eventic_comment ADD CONSTRAINT FK_E58109F5E2904019 FOREIGN KEY (thread_id) REFERENCES eventic_thread (id)');
        $this->addSql('ALTER TABLE eventic_comment ADD CONSTRAINT FK_E58109F5F675F31B FOREIGN KEY (author_id) REFERENCES eventic_user (id)');
        $this->addSql('ALTER TABLE eventic_country_translation ADD CONSTRAINT FK_1AAA1D022C2AC5D3 FOREIGN KEY (translatable_id) REFERENCES eventic_country (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE eventic_event ADD CONSTRAINT FK_E1933DCB12469DE2 FOREIGN KEY (category_id) REFERENCES eventic_category (id)');
        $this->addSql('ALTER TABLE eventic_event ADD CONSTRAINT FK_E1933DCBF92F3E70 FOREIGN KEY (country_id) REFERENCES eventic_country (id)');
        $this->addSql('ALTER TABLE eventic_event ADD CONSTRAINT FK_E1933DCB876C4DDA FOREIGN KEY (organizer_id) REFERENCES eventic_organizer (id)');
        $this->addSql('ALTER TABLE eventic_event ADD CONSTRAINT FK_E1933DCB376C51EF FOREIGN KEY (isonhomepageslider_id) REFERENCES eventic_homepage_hero_setting (id)');
        $this->addSql('ALTER TABLE eventic_event_language ADD CONSTRAINT FK_DD794B6A88818ADD FOREIGN KEY (Event_id) REFERENCES eventic_event (id)');
        $this->addSql('ALTER TABLE eventic_event_language ADD CONSTRAINT FK_DD794B6A91E91181 FOREIGN KEY (Language_Id) REFERENCES eventic_language (id)');
        $this->addSql('ALTER TABLE eventic_event_subtitle ADD CONSTRAINT FK_5827AD6E88818ADD FOREIGN KEY (Event_id) REFERENCES eventic_event (id)');
        $this->addSql('ALTER TABLE eventic_event_subtitle ADD CONSTRAINT FK_5827AD6E91E91181 FOREIGN KEY (Language_Id) REFERENCES eventic_language (id)');
        $this->addSql('ALTER TABLE eventic_event_audience ADD CONSTRAINT FK_F46FAEC788818ADD FOREIGN KEY (Event_id) REFERENCES eventic_event (id)');
        $this->addSql('ALTER TABLE eventic_event_audience ADD CONSTRAINT FK_F46FAEC797946D63 FOREIGN KEY (Audience_Id) REFERENCES eventic_audience (id)');
        $this->addSql('ALTER TABLE eventic_favorites ADD CONSTRAINT FK_B853A82F88818ADD FOREIGN KEY (Event_id) REFERENCES eventic_event (id)');
        $this->addSql('ALTER TABLE eventic_favorites ADD CONSTRAINT FK_B853A82FFD57CEAB FOREIGN KEY (User_Id) REFERENCES eventic_user (id)');
        $this->addSql('ALTER TABLE eventic_event_date ADD CONSTRAINT FK_D30F7AD371F7E88B FOREIGN KEY (event_id) REFERENCES eventic_event (id)');
        $this->addSql('ALTER TABLE eventic_event_date ADD CONSTRAINT FK_D30F7AD340A73EBA FOREIGN KEY (venue_id) REFERENCES eventic_venue (id)');
        $this->addSql('ALTER TABLE eventic_eventdate_scanner ADD CONSTRAINT FK_A9110493733DA6BA FOREIGN KEY (eventdate_id) REFERENCES eventic_event_date (id)');
        $this->addSql('ALTER TABLE eventic_eventdate_scanner ADD CONSTRAINT FK_A911049367C89E33 FOREIGN KEY (scanner_id) REFERENCES eventic_scanner (id)');
        $this->addSql('ALTER TABLE eventic_eventdate_pointofsale ADD CONSTRAINT FK_7E37EBFC733DA6BA FOREIGN KEY (eventdate_id) REFERENCES eventic_event_date (id)');
        $this->addSql('ALTER TABLE eventic_eventdate_pointofsale ADD CONSTRAINT FK_7E37EBFC18E07BF3 FOREIGN KEY (pointofsale_id) REFERENCES eventic_pointofsale (id)');
        $this->addSql('ALTER TABLE eventic_event_image ADD CONSTRAINT FK_6A4E8E5E71F7E88B FOREIGN KEY (event_id) REFERENCES eventic_event (id)');
        $this->addSql('ALTER TABLE eventic_event_date_ticket ADD CONSTRAINT FK_E8B0FCF9733DA6BA FOREIGN KEY (eventdate_id) REFERENCES eventic_event_date (id)');
        $this->addSql('ALTER TABLE eventic_event_translation ADD CONSTRAINT FK_2FCD2BD62C2AC5D3 FOREIGN KEY (translatable_id) REFERENCES eventic_event (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE eventic_help_center_article ADD CONSTRAINT FK_75F977E312469DE2 FOREIGN KEY (category_id) REFERENCES eventic_help_center_category (id)');
        $this->addSql('ALTER TABLE eventic_help_center_article_translation ADD CONSTRAINT FK_54AB40302C2AC5D3 FOREIGN KEY (translatable_id) REFERENCES eventic_help_center_article (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE eventic_help_center_category ADD CONSTRAINT FK_9BE9AD17727ACA70 FOREIGN KEY (parent_id) REFERENCES eventic_help_center_category (id)');
        $this->addSql('ALTER TABLE eventic_help_center_category_translation ADD CONSTRAINT FK_2B8AFEF52C2AC5D3 FOREIGN KEY (translatable_id) REFERENCES eventic_help_center_category (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE eventic_homepage_hero_setting_translation ADD CONSTRAINT FK_5DD4B1372C2AC5D3 FOREIGN KEY (translatable_id) REFERENCES eventic_homepage_hero_setting (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE eventic_language_translation ADD CONSTRAINT FK_E82162722C2AC5D3 FOREIGN KEY (translatable_id) REFERENCES eventic_language (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE eventic_order ADD CONSTRAINT FK_2F14A4F4A76ED395 FOREIGN KEY (user_id) REFERENCES eventic_user (id)');
        $this->addSql('ALTER TABLE eventic_order ADD CONSTRAINT FK_2F14A4F459CA0035 FOREIGN KEY (paymentgateway_id) REFERENCES eventic_payment_gateway (id)');
        $this->addSql('ALTER TABLE eventic_order ADD CONSTRAINT FK_2F14A4F44C3A3BB FOREIGN KEY (payment_id) REFERENCES eventic_payment (id)');
        $this->addSql('ALTER TABLE eventic_order_element ADD CONSTRAINT FK_261BAAD18D9F6D38 FOREIGN KEY (order_id) REFERENCES eventic_order (id)');
        $this->addSql('ALTER TABLE eventic_order_element ADD CONSTRAINT FK_261BAAD1182CEB62 FOREIGN KEY (eventticket_id) REFERENCES eventic_event_date_ticket (id)');
        $this->addSql('ALTER TABLE eventic_order_ticket ADD CONSTRAINT FK_111E8938EE04F0C1 FOREIGN KEY (orderelement_id) REFERENCES eventic_order_element (id)');
        $this->addSql('ALTER TABLE eventic_organizer ADD CONSTRAINT FK_C5EEB9A9A76ED395 FOREIGN KEY (user_id) REFERENCES eventic_user (id)');
        $this->addSql('ALTER TABLE eventic_organizer ADD CONSTRAINT FK_C5EEB9A9F92F3E70 FOREIGN KEY (country_id) REFERENCES eventic_country (id)');
        $this->addSql('ALTER TABLE eventic_organizer_category ADD CONSTRAINT FK_BB88F7D79F5D9622 FOREIGN KEY (Organizer_id) REFERENCES eventic_organizer (id)');
        $this->addSql('ALTER TABLE eventic_organizer_category ADD CONSTRAINT FK_BB88F7D715E3697 FOREIGN KEY (Category_Id) REFERENCES eventic_category (id)');
        $this->addSql('ALTER TABLE eventic_following ADD CONSTRAINT FK_2D8545399F5D9622 FOREIGN KEY (Organizer_id) REFERENCES eventic_organizer (id)');
        $this->addSql('ALTER TABLE eventic_following ADD CONSTRAINT FK_2D854539FD57CEAB FOREIGN KEY (User_Id) REFERENCES eventic_user (id)');
        $this->addSql('ALTER TABLE eventic_page_translation ADD CONSTRAINT FK_3B97CBF22C2AC5D3 FOREIGN KEY (translatable_id) REFERENCES eventic_page (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE eventic_payment ADD CONSTRAINT FK_1CDDDF948D9F6D38 FOREIGN KEY (order_id) REFERENCES eventic_order (id)');
        $this->addSql('ALTER TABLE eventic_payment ADD CONSTRAINT FK_1CDDDF94F92F3E70 FOREIGN KEY (country_id) REFERENCES eventic_country (id)');
        $this->addSql('ALTER TABLE eventic_payment_gateway ADD CONSTRAINT FK_9D4780D7876C4DDA FOREIGN KEY (organizer_id) REFERENCES eventic_organizer (id)');
        $this->addSql('ALTER TABLE eventic_payout_request ADD CONSTRAINT FK_4AE2AE43876C4DDA FOREIGN KEY (organizer_id) REFERENCES eventic_organizer (id)');
        $this->addSql('ALTER TABLE eventic_payout_request ADD CONSTRAINT FK_4AE2AE4362890FD5 FOREIGN KEY (payment_gateway_id) REFERENCES eventic_payment_gateway (id)');
        $this->addSql('ALTER TABLE eventic_payout_request ADD CONSTRAINT FK_4AE2AE433DC09FC4 FOREIGN KEY (event_date_id) REFERENCES eventic_event_date (id)');
        $this->addSql('ALTER TABLE eventic_pointofsale ADD CONSTRAINT FK_5D78D6FA876C4DDA FOREIGN KEY (organizer_id) REFERENCES eventic_organizer (id)');
        $this->addSql('ALTER TABLE eventic_pointofsale ADD CONSTRAINT FK_5D78D6FAA76ED395 FOREIGN KEY (user_id) REFERENCES eventic_user (id)');
        $this->addSql('ALTER TABLE eventic_review ADD CONSTRAINT FK_3D9D918271F7E88B FOREIGN KEY (event_id) REFERENCES eventic_event (id)');
        $this->addSql('ALTER TABLE eventic_review ADD CONSTRAINT FK_3D9D9182A76ED395 FOREIGN KEY (user_id) REFERENCES eventic_user (id)');
        $this->addSql('ALTER TABLE eventic_scanner ADD CONSTRAINT FK_241A84B0876C4DDA FOREIGN KEY (organizer_id) REFERENCES eventic_organizer (id)');
        $this->addSql('ALTER TABLE eventic_scanner ADD CONSTRAINT FK_241A84B0A76ED395 FOREIGN KEY (user_id) REFERENCES eventic_user (id)');
        $this->addSql('ALTER TABLE eventic_ticket_reservation ADD CONSTRAINT FK_716DEA9F182CEB62 FOREIGN KEY (eventticket_id) REFERENCES eventic_event_date_ticket (id)');
        $this->addSql('ALTER TABLE eventic_ticket_reservation ADD CONSTRAINT FK_716DEA9FA76ED395 FOREIGN KEY (user_id) REFERENCES eventic_user (id)');
        $this->addSql('ALTER TABLE eventic_ticket_reservation ADD CONSTRAINT FK_716DEA9FEE04F0C1 FOREIGN KEY (orderelement_id) REFERENCES eventic_order_element (id)');
        $this->addSql('ALTER TABLE eventic_user ADD CONSTRAINT FK_D01C6A22876C4DDA FOREIGN KEY (organizer_id) REFERENCES eventic_organizer (id)');
        $this->addSql('ALTER TABLE eventic_user ADD CONSTRAINT FK_D01C6A2267C89E33 FOREIGN KEY (scanner_id) REFERENCES eventic_scanner (id)');
        $this->addSql('ALTER TABLE eventic_user ADD CONSTRAINT FK_D01C6A2218E07BF3 FOREIGN KEY (pointofsale_id) REFERENCES eventic_pointofsale (id)');
        $this->addSql('ALTER TABLE eventic_user ADD CONSTRAINT FK_D01C6A22F2709FF9 FOREIGN KEY (isorganizeronhomepageslider_id) REFERENCES eventic_homepage_hero_setting (id)');
        $this->addSql('ALTER TABLE eventic_user ADD CONSTRAINT FK_D01C6A22F92F3E70 FOREIGN KEY (country_id) REFERENCES eventic_country (id)');
        $this->addSql('ALTER TABLE eventic_venue ADD CONSTRAINT FK_4BAC2C61876C4DDA FOREIGN KEY (organizer_id) REFERENCES eventic_organizer (id)');
        $this->addSql('ALTER TABLE eventic_venue ADD CONSTRAINT FK_4BAC2C61C54C8C93 FOREIGN KEY (type_id) REFERENCES eventic_venue_type (id)');
        $this->addSql('ALTER TABLE eventic_venue ADD CONSTRAINT FK_4BAC2C61F92F3E70 FOREIGN KEY (country_id) REFERENCES eventic_country (id)');
        $this->addSql('ALTER TABLE eventic_venue_amenity ADD CONSTRAINT FK_8A89D31EB9D15CEC FOREIGN KEY (Venue_id) REFERENCES eventic_venue (id)');
        $this->addSql('ALTER TABLE eventic_venue_amenity ADD CONSTRAINT FK_8A89D31E45463477 FOREIGN KEY (Amenity_Id) REFERENCES eventic_amenity (id)');
        $this->addSql('ALTER TABLE eventic_venue_image ADD CONSTRAINT FK_F3EE32A540A73EBA FOREIGN KEY (venue_id) REFERENCES eventic_venue (id)');
        $this->addSql('ALTER TABLE eventic_venue_translation ADD CONSTRAINT FK_3A06BD632C2AC5D3 FOREIGN KEY (translatable_id) REFERENCES eventic_venue (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE eventic_venue_type_translation ADD CONSTRAINT FK_9FD9786F2C2AC5D3 FOREIGN KEY (translatable_id) REFERENCES eventic_venue_type (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE eventic_vote ADD CONSTRAINT FK_79F390FF8697D13 FOREIGN KEY (comment_id) REFERENCES eventic_comment (id)');
        $this->addSql('ALTER TABLE eventic_vote ADD CONSTRAINT FK_79F390FEBB4B8AD FOREIGN KEY (voter_id) REFERENCES eventic_user (id)');
    }

    public function down(Schema $schema) : void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('ALTER TABLE eventic_amenity_translation DROP FOREIGN KEY FK_3C354FF82C2AC5D3');
        $this->addSql('ALTER TABLE eventic_venue_amenity DROP FOREIGN KEY FK_8A89D31E45463477');
        $this->addSql('ALTER TABLE eventic_audience_translation DROP FOREIGN KEY FK_5CF81D362C2AC5D3');
        $this->addSql('ALTER TABLE eventic_event_audience DROP FOREIGN KEY FK_F46FAEC797946D63');
        $this->addSql('ALTER TABLE eventic_blog_post_translation DROP FOREIGN KEY FK_6A7C548D2C2AC5D3');
        $this->addSql('ALTER TABLE eventic_blog_post DROP FOREIGN KEY FK_E66028C712469DE2');
        $this->addSql('ALTER TABLE eventic_blog_post_category_translation DROP FOREIGN KEY FK_BAF151EA2C2AC5D3');
        $this->addSql('ALTER TABLE eventic_category_translation DROP FOREIGN KEY FK_3CFC55AB2C2AC5D3');
        $this->addSql('ALTER TABLE eventic_event DROP FOREIGN KEY FK_E1933DCB12469DE2');
        $this->addSql('ALTER TABLE eventic_organizer_category DROP FOREIGN KEY FK_BB88F7D715E3697');
        $this->addSql('ALTER TABLE eventic_vote DROP FOREIGN KEY FK_79F390FF8697D13');
        $this->addSql('ALTER TABLE eventic_country_translation DROP FOREIGN KEY FK_1AAA1D022C2AC5D3');
        $this->addSql('ALTER TABLE eventic_event DROP FOREIGN KEY FK_E1933DCBF92F3E70');
        $this->addSql('ALTER TABLE eventic_organizer DROP FOREIGN KEY FK_C5EEB9A9F92F3E70');
        $this->addSql('ALTER TABLE eventic_payment DROP FOREIGN KEY FK_1CDDDF94F92F3E70');
        $this->addSql('ALTER TABLE eventic_user DROP FOREIGN KEY FK_D01C6A22F92F3E70');
        $this->addSql('ALTER TABLE eventic_venue DROP FOREIGN KEY FK_4BAC2C61F92F3E70');
        $this->addSql('ALTER TABLE eventic_event_language DROP FOREIGN KEY FK_DD794B6A88818ADD');
        $this->addSql('ALTER TABLE eventic_event_subtitle DROP FOREIGN KEY FK_5827AD6E88818ADD');
        $this->addSql('ALTER TABLE eventic_event_audience DROP FOREIGN KEY FK_F46FAEC788818ADD');
        $this->addSql('ALTER TABLE eventic_favorites DROP FOREIGN KEY FK_B853A82F88818ADD');
        $this->addSql('ALTER TABLE eventic_event_date DROP FOREIGN KEY FK_D30F7AD371F7E88B');
        $this->addSql('ALTER TABLE eventic_event_image DROP FOREIGN KEY FK_6A4E8E5E71F7E88B');
        $this->addSql('ALTER TABLE eventic_event_translation DROP FOREIGN KEY FK_2FCD2BD62C2AC5D3');
        $this->addSql('ALTER TABLE eventic_review DROP FOREIGN KEY FK_3D9D918271F7E88B');
        $this->addSql('ALTER TABLE eventic_eventdate_scanner DROP FOREIGN KEY FK_A9110493733DA6BA');
        $this->addSql('ALTER TABLE eventic_eventdate_pointofsale DROP FOREIGN KEY FK_7E37EBFC733DA6BA');
        $this->addSql('ALTER TABLE eventic_event_date_ticket DROP FOREIGN KEY FK_E8B0FCF9733DA6BA');
        $this->addSql('ALTER TABLE eventic_payout_request DROP FOREIGN KEY FK_4AE2AE433DC09FC4');
        $this->addSql('ALTER TABLE eventic_cart_element DROP FOREIGN KEY FK_FFABA270182CEB62');
        $this->addSql('ALTER TABLE eventic_order_element DROP FOREIGN KEY FK_261BAAD1182CEB62');
        $this->addSql('ALTER TABLE eventic_ticket_reservation DROP FOREIGN KEY FK_716DEA9F182CEB62');
        $this->addSql('ALTER TABLE eventic_help_center_article_translation DROP FOREIGN KEY FK_54AB40302C2AC5D3');
        $this->addSql('ALTER TABLE eventic_help_center_article DROP FOREIGN KEY FK_75F977E312469DE2');
        $this->addSql('ALTER TABLE eventic_help_center_category DROP FOREIGN KEY FK_9BE9AD17727ACA70');
        $this->addSql('ALTER TABLE eventic_help_center_category_translation DROP FOREIGN KEY FK_2B8AFEF52C2AC5D3');
        $this->addSql('ALTER TABLE eventic_event DROP FOREIGN KEY FK_E1933DCB376C51EF');
        $this->addSql('ALTER TABLE eventic_homepage_hero_setting_translation DROP FOREIGN KEY FK_5DD4B1372C2AC5D3');
        $this->addSql('ALTER TABLE eventic_user DROP FOREIGN KEY FK_D01C6A22F2709FF9');
        $this->addSql('ALTER TABLE eventic_event_language DROP FOREIGN KEY FK_DD794B6A91E91181');
        $this->addSql('ALTER TABLE eventic_event_subtitle DROP FOREIGN KEY FK_5827AD6E91E91181');
        $this->addSql('ALTER TABLE eventic_language_translation DROP FOREIGN KEY FK_E82162722C2AC5D3');
        $this->addSql('ALTER TABLE eventic_order_element DROP FOREIGN KEY FK_261BAAD18D9F6D38');
        $this->addSql('ALTER TABLE eventic_payment DROP FOREIGN KEY FK_1CDDDF948D9F6D38');
        $this->addSql('ALTER TABLE eventic_order_ticket DROP FOREIGN KEY FK_111E8938EE04F0C1');
        $this->addSql('ALTER TABLE eventic_ticket_reservation DROP FOREIGN KEY FK_716DEA9FEE04F0C1');
        $this->addSql('ALTER TABLE eventic_event DROP FOREIGN KEY FK_E1933DCB876C4DDA');
        $this->addSql('ALTER TABLE eventic_organizer_category DROP FOREIGN KEY FK_BB88F7D79F5D9622');
        $this->addSql('ALTER TABLE eventic_following DROP FOREIGN KEY FK_2D8545399F5D9622');
        $this->addSql('ALTER TABLE eventic_payment_gateway DROP FOREIGN KEY FK_9D4780D7876C4DDA');
        $this->addSql('ALTER TABLE eventic_payout_request DROP FOREIGN KEY FK_4AE2AE43876C4DDA');
        $this->addSql('ALTER TABLE eventic_pointofsale DROP FOREIGN KEY FK_5D78D6FA876C4DDA');
        $this->addSql('ALTER TABLE eventic_scanner DROP FOREIGN KEY FK_241A84B0876C4DDA');
        $this->addSql('ALTER TABLE eventic_user DROP FOREIGN KEY FK_D01C6A22876C4DDA');
        $this->addSql('ALTER TABLE eventic_venue DROP FOREIGN KEY FK_4BAC2C61876C4DDA');
        $this->addSql('ALTER TABLE eventic_page_translation DROP FOREIGN KEY FK_3B97CBF22C2AC5D3');
        $this->addSql('ALTER TABLE eventic_order DROP FOREIGN KEY FK_2F14A4F44C3A3BB');
        $this->addSql('ALTER TABLE eventic_order DROP FOREIGN KEY FK_2F14A4F459CA0035');
        $this->addSql('ALTER TABLE eventic_payout_request DROP FOREIGN KEY FK_4AE2AE4362890FD5');
        $this->addSql('ALTER TABLE eventic_eventdate_pointofsale DROP FOREIGN KEY FK_7E37EBFC18E07BF3');
        $this->addSql('ALTER TABLE eventic_user DROP FOREIGN KEY FK_D01C6A2218E07BF3');
        $this->addSql('ALTER TABLE eventic_eventdate_scanner DROP FOREIGN KEY FK_A911049367C89E33');
        $this->addSql('ALTER TABLE eventic_user DROP FOREIGN KEY FK_D01C6A2267C89E33');
        $this->addSql('ALTER TABLE eventic_comment DROP FOREIGN KEY FK_E58109F5E2904019');
        $this->addSql('ALTER TABLE eventic_cart_element DROP FOREIGN KEY FK_FFABA270A76ED395');
        $this->addSql('ALTER TABLE eventic_comment DROP FOREIGN KEY FK_E58109F5F675F31B');
        $this->addSql('ALTER TABLE eventic_favorites DROP FOREIGN KEY FK_B853A82FFD57CEAB');
        $this->addSql('ALTER TABLE eventic_order DROP FOREIGN KEY FK_2F14A4F4A76ED395');
        $this->addSql('ALTER TABLE eventic_organizer DROP FOREIGN KEY FK_C5EEB9A9A76ED395');
        $this->addSql('ALTER TABLE eventic_following DROP FOREIGN KEY FK_2D854539FD57CEAB');
        $this->addSql('ALTER TABLE eventic_pointofsale DROP FOREIGN KEY FK_5D78D6FAA76ED395');
        $this->addSql('ALTER TABLE eventic_review DROP FOREIGN KEY FK_3D9D9182A76ED395');
        $this->addSql('ALTER TABLE eventic_scanner DROP FOREIGN KEY FK_241A84B0A76ED395');
        $this->addSql('ALTER TABLE eventic_ticket_reservation DROP FOREIGN KEY FK_716DEA9FA76ED395');
        $this->addSql('ALTER TABLE eventic_vote DROP FOREIGN KEY FK_79F390FEBB4B8AD');
        $this->addSql('ALTER TABLE eventic_event_date DROP FOREIGN KEY FK_D30F7AD340A73EBA');
        $this->addSql('ALTER TABLE eventic_venue_amenity DROP FOREIGN KEY FK_8A89D31EB9D15CEC');
        $this->addSql('ALTER TABLE eventic_venue_image DROP FOREIGN KEY FK_F3EE32A540A73EBA');
        $this->addSql('ALTER TABLE eventic_venue_translation DROP FOREIGN KEY FK_3A06BD632C2AC5D3');
        $this->addSql('ALTER TABLE eventic_venue DROP FOREIGN KEY FK_4BAC2C61C54C8C93');
        $this->addSql('ALTER TABLE eventic_venue_type_translation DROP FOREIGN KEY FK_9FD9786F2C2AC5D3');
        $this->addSql('DROP TABLE eventic_amenity');
        $this->addSql('DROP TABLE eventic_amenity_translation');
        $this->addSql('DROP TABLE eventic_audience');
        $this->addSql('DROP TABLE eventic_audience_translation');
        $this->addSql('DROP TABLE eventic_blog_post');
        $this->addSql('DROP TABLE eventic_blog_post_category');
        $this->addSql('DROP TABLE eventic_blog_post_category_translation');
        $this->addSql('DROP TABLE eventic_blog_post_translation');
        $this->addSql('DROP TABLE eventic_cart_element');
        $this->addSql('DROP TABLE eventic_category');
        $this->addSql('DROP TABLE eventic_category_translation');
        $this->addSql('DROP TABLE eventic_comment');
        $this->addSql('DROP TABLE eventic_country');
        $this->addSql('DROP TABLE eventic_country_translation');
        $this->addSql('DROP TABLE eventic_currency');
        $this->addSql('DROP TABLE eventic_event');
        $this->addSql('DROP TABLE eventic_event_language');
        $this->addSql('DROP TABLE eventic_event_subtitle');
        $this->addSql('DROP TABLE eventic_event_audience');
        $this->addSql('DROP TABLE eventic_favorites');
        $this->addSql('DROP TABLE eventic_event_date');
        $this->addSql('DROP TABLE eventic_eventdate_scanner');
        $this->addSql('DROP TABLE eventic_eventdate_pointofsale');
        $this->addSql('DROP TABLE eventic_event_image');
        $this->addSql('DROP TABLE eventic_event_date_ticket');
        $this->addSql('DROP TABLE eventic_event_translation');
        $this->addSql('DROP TABLE eventic_help_center_article');
        $this->addSql('DROP TABLE eventic_help_center_article_translation');
        $this->addSql('DROP TABLE eventic_help_center_category');
        $this->addSql('DROP TABLE eventic_help_center_category_translation');
        $this->addSql('DROP TABLE eventic_homepage_hero_setting');
        $this->addSql('DROP TABLE eventic_homepage_hero_setting_translation');
        $this->addSql('DROP TABLE eventic_language');
        $this->addSql('DROP TABLE eventic_language_translation');
        $this->addSql('DROP TABLE eventic_order');
        $this->addSql('DROP TABLE eventic_order_element');
        $this->addSql('DROP TABLE eventic_order_ticket');
        $this->addSql('DROP TABLE eventic_organizer');
        $this->addSql('DROP TABLE eventic_organizer_category');
        $this->addSql('DROP TABLE eventic_following');
        $this->addSql('DROP TABLE eventic_page');
        $this->addSql('DROP TABLE eventic_page_translation');
        $this->addSql('DROP TABLE eventic_payment');
        $this->addSql('DROP TABLE eventic_payment_gateway');
        $this->addSql('DROP TABLE eventic_payment_token');
        $this->addSql('DROP TABLE eventic_payout_request');
        $this->addSql('DROP TABLE eventic_pointofsale');
        $this->addSql('DROP TABLE eventic_review');
        $this->addSql('DROP TABLE eventic_scanner');
        $this->addSql('DROP TABLE eventic_settings');
        $this->addSql('DROP TABLE eventic_thread');
        $this->addSql('DROP TABLE eventic_ticket_reservation');
        $this->addSql('DROP TABLE eventic_user');
        $this->addSql('DROP TABLE eventic_venue');
        $this->addSql('DROP TABLE eventic_venue_amenity');
        $this->addSql('DROP TABLE eventic_venue_image');
        $this->addSql('DROP TABLE eventic_venue_translation');
        $this->addSql('DROP TABLE eventic_venue_type');
        $this->addSql('DROP TABLE eventic_venue_type_translation');
        $this->addSql('DROP TABLE eventic_vote');
    }
}
