<?php

use Symfony\Component\Translation\MessageCatalogue;

$catalogue = new MessageCatalogue('sr_Latn', array (
  'validators' => 
  array (
    'This value should be false.' => 'Vrednost bi trebalo da bude netačna.',
    'This value should be true.' => 'Vrednost bi trebalo da bude tačna.',
    'This value should be of type {{ type }}.' => 'Vrednost bi trebalo da bude tipa {{ type }}.',
    'This value should be blank.' => 'Vrednost bi trebalo da bude prazna.',
    'The value you selected is not a valid choice.' => 'Odabrana vrednost nije validan izbor.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'Morate odabrati bar {{ limit }} mogućnost.|Morate odabrati bar {{ limit }} mogućnosti.|Morate odabrati bar {{ limit }} mogućnosti.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'Morate odabrati najviše {{ limit }} mogućnost.|Morate odabrati najviše {{ limit }} mogućnosti.|Morate odabrati najviše {{ limit }} mogućnosti.',
    'One or more of the given values is invalid.' => 'Jedna ili više vrednosti nisu validne.',
    'This field was not expected.' => 'Ovo polje nije bilo očekivano.',
    'This field is missing.' => 'Ovo polje nedostaje.',
    'This value is not a valid date.' => 'Vrednost nije validan datum.',
    'This value is not a valid datetime.' => 'Vrednost nije validno vreme.',
    'This value is not a valid email address.' => 'Vrednost nije validna adresa elektronske pošte.',
    'The file could not be found.' => 'Datoteka ne može biti pronađena.',
    'The file is not readable.' => 'Datoteka nije čitljiva.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'Datoteka je prevelika ({{ size }} {{ suffix }}). Najveća dozvoljena veličina je {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'MIME tip datoteke nije validan ({{ type }}). Dozvoljeni MIME tipovi su {{ types }}.',
    'This value should be {{ limit }} or less.' => 'Vrednost bi trebalo da bude {{ limit }} ili manje.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'Vrednost je predugačka. Trebalo bi da ima {{ limit }} karakter ili manje.|Vrednost je predugačka. Trebalo bi da ima {{ limit }} karaktera ili manje.|Vrednost je predugačka. Trebalo bi da ima {{ limit }} karaktera ili manje.',
    'This value should be {{ limit }} or more.' => 'Vrednost bi trebalo da bude {{ limit }} ili više.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'Vrednost je prekratka. Trebalo bi da ima {{ limit }} karakter ili više.|Vrednost je prekratka. Trebalo bi da ima {{ limit }} karaktera ili više.|Vrednost je prekratka. Trebalo bi da ima {{ limit }} karaktera ili više.',
    'This value should not be blank.' => 'Vrednost ne bi trebalo da bude prazna.',
    'This value should not be null.' => 'Vrednost ne bi trebalo da bude prazna.',
    'This value should be null.' => 'Vrednost bi trebalo da bude prazna.',
    'This value is not valid.' => 'Vrednost nije validna.',
    'This value is not a valid time.' => 'Vrednost nije validno vreme.',
    'This value is not a valid URL.' => 'Vrednost nije validan URL.',
    'The two values should be equal.' => 'Obe vrednosti bi trebalo da budu jednake.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'Datoteka je prevelika. Najveća dozvoljena veličina je {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'Datoteka je prevelika.',
    'The file could not be uploaded.' => 'Datoteka ne može biti otpremljena.',
    'This value should be a valid number.' => 'Vrednost bi trebalo da bude validan broj.',
    'This file is not a valid image.' => 'Ova datoteka nije validna slika.',
    'This is not a valid IP address.' => 'Ovo nije validna IP adresa.',
    'This value is not a valid language.' => 'Vrednost nije validan jezik.',
    'This value is not a valid locale.' => 'Vrednost nije validna međunarodna oznaka jezika.',
    'This value is not a valid country.' => 'Vrednost nije validna država.',
    'This value is already used.' => 'Vrednost je već iskorišćena.',
    'The size of the image could not be detected.' => 'Veličina slike ne može biti određena.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'Širina slike je prevelika ({{ width }} piksela). Najveća dozvoljena širina je {{ max_width }} piksela.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'Širina slike je premala ({{ width }} piksela). Najmanja dozvoljena širina je {{ min_width }} piksela.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'Visina slike je prevelika ({{ height }} piksela). Najveća dozvoljena visina je {{ max_height }} piksela.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'Visina slike je premala ({{ height }} piksela). Najmanja dozvoljena visina je {{ min_height }} piksela.',
    'This value should be the user\'s current password.' => 'Vrednost bi trebalo da bude trenutna korisnička lozinka.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'Vrednost bi trebalo da ima tačno {{ limit }} karakter.|Vrednost bi trebalo da ima tačno {{ limit }} karaktera.|Vrednost bi trebalo da ima tačno {{ limit }} karaktera.',
    'The file was only partially uploaded.' => 'Datoteka je samo parcijalno otpremljena.',
    'No file was uploaded.' => 'Datoteka nije otpremljena.',
    'No temporary folder was configured in php.ini.' => 'Privremeni direktorijum nije konfigurisan u php.ini.',
    'Cannot write temporary file to disk.' => 'Nemoguće pisanje privremene datoteke na disk.',
    'A PHP extension caused the upload to fail.' => 'PHP ekstenzija je prouzrokovala neuspeh otpremanja datoteke.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'Ova kolekcija bi trebalo da sadrži {{ limit }} ili više elemenata.|Ova kolekcija bi trebalo da sadrži {{ limit }} ili više elemenata.|Ova kolekcija bi trebalo da sadrži {{ limit }} ili više elemenata.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'Ova kolekcija bi trebalo da sadrži {{ limit }} ili manje elemenata.|Ova kolekcija bi trebalo da sadrži {{ limit }} ili manje elemenata.|Ova kolekcija bi trebalo da sadrži {{ limit }} ili manje elemenata.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'Ova kolekcija bi trebalo da sadrži tačno {{ limit }} element.|Ova kolekcija bi trebalo da sadrži tačno {{ limit }} elementa.|Ova kolekcija bi trebalo da sadrži tačno {{ limit }} elemenata.',
    'Invalid card number.' => 'Broj kartice nije validan.',
    'Unsupported card type or invalid card number.' => 'Tip kartice nije podržan ili broj kartice nije validan.',
    'This is not a valid International Bank Account Number (IBAN).' => 'Ovo nije validan međunarodni broj bankovnog računa (IBAN).',
    'This value is not a valid ISBN-10.' => 'Ovo nije validan ISBN-10.',
    'This value is not a valid ISBN-13.' => 'Ovo nije validan ISBN-13.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'Ovo nije validan ISBN-10 ili ISBN-13.',
    'This value is not a valid ISSN.' => 'Ovo nije validan ISSN.',
    'This value is not a valid currency.' => 'Ovo nije validna valuta.',
    'This value should be equal to {{ compared_value }}.' => 'Ova vrednost bi trebalo da bude jednaka {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'Ova vrednost bi trebalo da bude veća od {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'Ova vrednost bi trebalo da bude veća ili jednaka {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Ova vrednost bi trebalo da bude identična sa {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'Ova vrednost bi trebalo da bude manja od {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'Ova vrednost bi trebalo da bude manja ili jednaka {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'Ova vrednost ne bi trebalo da bude jednaka {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Ova vrednost ne bi trebalo da bude identična sa {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'Razmera ove slike je prevelika ({{ ratio }}). Maksimalna dozvoljena razmera je {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'Razmera ove slike je premala ({{ ratio }}). Minimalna očekivana razmera je {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'Slika je kvadratna ({{ width }}x{{ height }} piksela). Kvadratne slike nisu dozvoljene.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'Slika je pejzažno orijentisana ({{ width }}x{{ height }} piksela). Pejzažna orijentisane slike nisu dozvoljene.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'Slika je portretno orijentisana ({{ width }}x{{ height }} piksela). Portretno orijentisane slike nisu dozvoljene.',
    'An empty file is not allowed.' => 'Prazna datoteka nije dozvoljena.',
    'The host could not be resolved.' => 'Nije moguće odrediti poslužitelja.',
    'This value does not match the expected {{ charset }} charset.' => 'Vrednost se ne poklapa sa očekivanim {{ charset }} setom karaktera.',
    'This is not a valid Business Identifier Code (BIC).' => 'Ovo nije validan BIC.',
    'Error' => 'Greška',
    'This is not a valid UUID.' => 'Ovo nije validan univerzalni unikatni identifikator (UUID).',
    'This value should be a multiple of {{ compared_value }}.' => 'Ova vrednost bi trebalo da bude deljiva sa {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'BIC kod nije povezan sa IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'Ova vrednost bi trebalo da bude validan JSON.',
    'This collection should contain only unique elements.' => 'Ova kolekcija bi trebala da sadrži samo jedinstvene elemente.',
    'This value should be positive.' => 'Ova vrednost bi trebala biti pozitivna.',
    'This value should be either positive or zero.' => 'Ova vrednost bi trebala biti pozitivna ili nula.',
    'This value should be negative.' => 'Ova vrednost bi trebala biti negativna.',
    'This value should be either negative or zero.' => 'Ova vrednost bi trebala biti pozitivna ili nula.',
    'This value is not a valid timezone.' => 'Ova vrednost nije validna vremenska zona.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'Ova lozinka je kompromitovana prilikom prethodnih napada, nemojte je koristiti. Koristite drugu lozinku.',
    'This value should be between {{ min }} and {{ max }}.' => 'Ova vrednost treba da bude između {{ min }} i {{ max }}.',
    'This form should not contain extra fields.' => 'Ovaj formular ne treba da sadrži dodatna polja.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'Otpremljena datoteka je bila prevelika. Molim pokušajte otpremanje manje datoteke.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'CSRF vrednost je nevalidna. Pokušajte ponovo.',
    'fos_user.username.already_used' => 'Korisničko ime već postoji.',
    'fos_user.username.blank' => 'Molimo, unesite korisničko ime.',
    'fos_user.username.short' => 'Korisničko ime je prekratko.',
    'fos_user.username.long' => 'Korisničko ime je predugo.',
    'fos_user.email.already_used' => 'Adresa e-pošte već postoji.',
    'fos_user.email.blank' => 'Molimo, unesite adresu e-pošte.',
    'fos_user.email.short' => 'Adresa e-pošte je prekratka.',
    'fos_user.email.long' => 'Adresa e-pošte je preduga.',
    'fos_user.email.invalid' => 'Adresa e-pošte nije validna.',
    'fos_user.password.blank' => 'Molimo, unesite lozinku.',
    'fos_user.password.short' => 'Lozinka je prekratka.',
    'fos_user.new_password.blank' => 'Molimo, unesite novu lozinku.',
    'fos_user.new_password.short' => 'Nova lozinka je prekratka.',
    'fos_user.current_password.invalid' => 'Lozinka nije validna.',
    'fos_user.group.blank' => 'Molimo unesite naziv.',
    'fos_user.group.short' => 'Naziv je prekratak.',
    'fos_user.group.long' => 'Naziv je predug.',
    'fos_group.name.already_used' => 'Ovo ime već postoji.',
    'This value is not a valid captcha.' => 'Ova vrijednost nije ispravna captcha.',
    'The captcha was not resolved on the right domain.' => 'Captcha nije rešena na ispravnom domenu.',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'Izuzetak pri autentifikaciji.',
    'Authentication credentials could not be found.' => 'Autentifikacioni podaci nisu pronađeni.',
    'Authentication request could not be processed due to a system problem.' => 'Zahtev za autentifikaciju ne može biti obrađen zbog sistemskih problema.',
    'Invalid credentials.' => 'Nevalidni podaci za autentifikaciju.',
    'Cookie has already been used by someone else.' => 'Kolačić je već iskorišćen od strane nekog drugog.',
    'Not privileged to request the resource.' => 'Nemate prava pristupa ovom resursu.',
    'Invalid CSRF token.' => 'Nevalidan CSRF token.',
    'No authentication provider found to support the authentication token.' => 'Autentifikacioni provajder za podršku tokena nije pronađen.',
    'No session available, it either timed out or cookies are not enabled.' => 'Sesija nije dostupna, istekla je ili su kolačići isključeni.',
    'No token could be found.' => 'Token ne može biti pronađen.',
    'Username could not be found.' => 'Korisničko ime ne može biti pronađeno.',
    'Account has expired.' => 'Nalog je istekao.',
    'Credentials have expired.' => 'Podaci za autentifikaciju su istekli.',
    'Account is disabled.' => 'Nalog je onemogućen.',
    'Account is locked.' => 'Nalog je zaključan.',
  ),
  'FOSUserBundle' => 
  array (
    'group.edit.submit' => 'Ažuriraj grupu',
    'group.show.name' => 'Naziv grupe',
    'group.new.submit' => 'Kreiraj grupu',
    'group.flash.updated' => 'Grupa je ažurirana.',
    'group.flash.created' => 'Grupa je kreirana.',
    'group.flash.deleted' => 'Grupa je obrisana.',
    'security.login.username' => 'Korisničko ime',
    'security.login.password' => 'Lozinka',
    'security.login.remember_me' => 'Zapamti me',
    'security.login.submit' => 'Prijavi se',
    'profile.show.username' => 'Korisničko ime',
    'profile.show.email' => 'Adresa e-pošte',
    'profile.edit.submit' => 'Ažuriraj',
    'profile.flash.updated' => 'Profil je ažuriran.',
    'change_password.submit' => 'Izmeni lozinku',
    'change_password.flash.success' => 'Lozinka je izmenjena.',
    'registration.check_email' => 'Poruka je poslata na adresu %email%. Ona sadrži aktivacioni link koji morate kliknuti da bi aktivirali Vaš nalog.',
    'registration.confirmed' => 'Čestitamo %username%, Vaš nalog je sada aktivan.',
    'registration.back' => 'Nazad na prethodnu stranu.',
    'registration.submit' => 'Registruj se',
    'registration.flash.user_created' => 'Korisnički nalog je uspešno kreiran.',
    'registration.email.subject' => 'Dobrodošli %username%!',
    'registration.email.message' => 'Zdravo %username%!

Da bi aktivirali Vaš nalog posetite %confirmationUrl%

Ovaj link možete upotrebiti samo jednom da biste potvrdili Vaš nalog.

S poštovanjem,
tim sajta.
',
    'resetting.check_email' => 'Poruka je poslata na adresu %email%. Ona sadrži link koji morate kliknuti da bi resetovali Vašu lozinku.',
    'resetting.request.username' => 'Korisničko ime ili adresa e-pošte',
    'resetting.request.submit' => 'Resetuj lozinku',
    'resetting.reset.submit' => 'Izmeni lozinku',
    'resetting.flash.success' => 'Lozinka je uspešno resetovana.',
    'resetting.email.subject' => 'Resetovanje lozinke',
    'resetting.email.message' => 'Zdravo %username%!

Da bi resetovali Vašu lozinku posetite %confirmationUrl%

S poštovanjem,
tim sajta.
',
    'layout.logout' => 'Odjavljivanje',
    'layout.login' => 'Prijavljivanje',
    'layout.register' => 'Registracija',
    'layout.logged_in_as' => 'Prijavljen kao %username%',
    'form.group_name' => 'Naziv grupe',
    'form.username' => 'Korisničko ime',
    'form.email' => 'Adresa e-pošte',
    'form.current_password' => 'Trenutna lozinka',
    'form.password' => 'Lozinka',
    'form.password_confirmation' => 'Potvrda lozinke',
    'form.new_password' => 'Nova lozinka',
    'form.new_password_confirmation' => 'Potvrda lozinke',
  ),
  'time' => 
  array (
    'diff.ago.year' => 'pre 1 godine|%count% godina',
    'diff.ago.month' => 'pre 1 meseca|%count% meseci',
    'diff.ago.day' => 'pre 1 dan|%count% dana',
    'diff.ago.hour' => 'pre 1 sat|%count% sati',
    'diff.ago.minute' => 'pre 1 minute|%count% minuta',
    'diff.ago.second' => 'pre 1 sekunde|%count% sekundi',
    'diff.empty' => 'trenutno',
    'diff.in.second' => 'u 1 sekundi|%count% sekundi',
    'diff.in.hour' => 'u 1 satu|%count% sati',
    'diff.in.minute' => 'u 1 minuti|%count% minuti',
    'diff.in.day' => 'u 1 danu|%count% dana',
    'diff.in.month' => 'u 1 mesecu|%count% meseca',
    'diff.in.year' => 'u 1 godini|%count% godine',
  ),
  'FOSCommentBundle' => 
  array (
    'fos_comment_comment_new_headline_first' => 'Ostavite prvi komentar',
    'fos_comment_comment_new_headline' => 'Dodaj novi komentar',
    'fos_comment_comment_new_submit' => 'Pošalji',
    'fos_comment_comment_new_cancel' => 'Otkaži',
    'fos_comment_comment_edit_submit' => 'Pošalji',
    'fos_comment_comment_edit_cancel' => 'Otkaži',
    'fos_comment_comment_reply_reply_to' => 'Odgovori %name%',
    'fos_comment_comment_reply_cancel' => 'Otkaži',
    'fos_comment_comment_show_by' => 'Komentar',
    'fos_comment_comment_show_voteup' => 'Glasaj za',
    'fos_comment_comment_show_votedown' => 'Glasaj protiv',
    'fos_comment_comment_show_reply' => 'Odgovori',
    'fos_comment_comment_vote_score' => 'Glasova: ',
    'fos_comment_comment_tree_load_more' => 'Učitaj još odgovora',
    'fos_comment_rss_feed' => 'RSS kanal',
    'fos_comment_thread_close' => 'Zatvori diskusiju',
    'fos_comment_thread_open' => 'Otvori diskusiju',
    'fos_comment_thread_comment_count' => '%count% komentar|%count% komentara|%count% komentara',
    'fos_comment_comment_edit' => 'Izmeni',
    'fos_comment_comment_delete' => 'Obriši komentar',
    'fos_comment_comment_undelete' => 'Obnovi komentar',
    'fos_comment_comment_deleted' => '[obrisano]',
  ),
));

$catalogueEn = new MessageCatalogue('en', array (
  'validators' => 
  array (
    'This value should be false.' => 'This value should be false.',
    'This value should be true.' => 'This value should be true.',
    'This value should be of type {{ type }}.' => 'This value should be of type {{ type }}.',
    'This value should be blank.' => 'This value should be blank.',
    'The value you selected is not a valid choice.' => 'The value you selected is not a valid choice.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.',
    'One or more of the given values is invalid.' => 'One or more of the given values is invalid.',
    'This field was not expected.' => 'This field was not expected.',
    'This field is missing.' => 'This field is missing.',
    'This value is not a valid date.' => 'This value is not a valid date.',
    'This value is not a valid datetime.' => 'This value is not a valid datetime.',
    'This value is not a valid email address.' => 'This value is not a valid email address.',
    'The file could not be found.' => 'The file could not be found.',
    'The file is not readable.' => 'The file is not readable.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.',
    'This value should be {{ limit }} or less.' => 'This value should be {{ limit }} or less.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.',
    'This value should be {{ limit }} or more.' => 'This value should be {{ limit }} or more.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.',
    'This value should not be blank.' => 'This value should not be blank.',
    'This value should not be null.' => 'This value should not be null.',
    'This value should be null.' => 'This value should be null.',
    'This value is not valid.' => 'This value is not valid.',
    'This value is not a valid time.' => 'This value is not a valid time.',
    'This value is not a valid URL.' => 'This value is not a valid URL.',
    'The two values should be equal.' => 'The two values should be equal.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'The file is too large.',
    'The file could not be uploaded.' => 'The file could not be uploaded.',
    'This value should be a valid number.' => 'This value should be a valid number.',
    'This file is not a valid image.' => 'This file is not a valid image.',
    'This is not a valid IP address.' => 'This is not a valid IP address.',
    'This value is not a valid language.' => 'This value is not a valid language.',
    'This value is not a valid locale.' => 'This value is not a valid locale.',
    'This value is not a valid country.' => 'This value is not a valid country.',
    'This value is already used.' => 'This value is already used.',
    'The size of the image could not be detected.' => 'The size of the image could not be detected.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'This value should be the user\'s current password.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.',
    'The file was only partially uploaded.' => 'The file was only partially uploaded.',
    'No file was uploaded.' => 'No file was uploaded.',
    'No temporary folder was configured in php.ini.' => 'No temporary folder was configured in php.ini, or the configured folder does not exist.',
    'Cannot write temporary file to disk.' => 'Cannot write temporary file to disk.',
    'A PHP extension caused the upload to fail.' => 'A PHP extension caused the upload to fail.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.',
    'Invalid card number.' => 'Invalid card number.',
    'Unsupported card type or invalid card number.' => 'Unsupported card type or invalid card number.',
    'This is not a valid International Bank Account Number (IBAN).' => 'This is not a valid International Bank Account Number (IBAN).',
    'This value is not a valid ISBN-10.' => 'This value is not a valid ISBN-10.',
    'This value is not a valid ISBN-13.' => 'This value is not a valid ISBN-13.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'This value is neither a valid ISBN-10 nor a valid ISBN-13.',
    'This value is not a valid ISSN.' => 'This value is not a valid ISSN.',
    'This value is not a valid currency.' => 'This value is not a valid currency.',
    'This value should be equal to {{ compared_value }}.' => 'This value should be equal to {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'This value should be greater than {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'This value should be greater than or equal to {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should be identical to {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'This value should be less than {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'This value should be less than or equal to {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'This value should not be equal to {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.',
    'An empty file is not allowed.' => 'An empty file is not allowed.',
    'The host could not be resolved.' => 'The host could not be resolved.',
    'This value does not match the expected {{ charset }} charset.' => 'This value does not match the expected {{ charset }} charset.',
    'This is not a valid Business Identifier Code (BIC).' => 'This is not a valid Business Identifier Code (BIC).',
    'Error' => 'Error',
    'This is not a valid UUID.' => 'This is not a valid UUID.',
    'This value should be a multiple of {{ compared_value }}.' => 'This value should be a multiple of {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'This value should be valid JSON.',
    'This collection should contain only unique elements.' => 'This collection should contain only unique elements.',
    'This value should be positive.' => 'This value should be positive.',
    'This value should be either positive or zero.' => 'This value should be either positive or zero.',
    'This value should be negative.' => 'This value should be negative.',
    'This value should be either negative or zero.' => 'This value should be either negative or zero.',
    'This value is not a valid timezone.' => 'This value is not a valid timezone.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'This password has been leaked in a data breach, it must not be used. Please use another password.',
    'This value should be between {{ min }} and {{ max }}.' => 'This value should be between {{ min }} and {{ max }}.',
    'This value is not a valid hostname.' => 'This value is not a valid hostname.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'The number of elements in this collection should be a multiple of {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'This value should satisfy at least one of the following constraints:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Each element of this collection should satisfy its own set of constraints.',
    'This form should not contain extra fields.' => 'This form should not contain extra fields.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'The uploaded file was too large. Please try to upload a smaller file.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'The CSRF token is invalid. Please try to resubmit the form.',
    'fos_user.username.already_used' => 'The username is already used.',
    'fos_user.username.blank' => 'Please enter a username.',
    'fos_user.username.short' => 'The username is too short.',
    'fos_user.username.long' => 'The username is too long.',
    'fos_user.email.already_used' => 'The email is already used.',
    'fos_user.email.blank' => 'Please enter an email.',
    'fos_user.email.short' => 'The email is too short.',
    'fos_user.email.long' => 'The email is too long.',
    'fos_user.email.invalid' => 'The email is not valid.',
    'fos_user.password.blank' => 'Please enter a password.',
    'fos_user.password.short' => 'The password is too short.',
    'fos_user.password.mismatch' => 'The entered passwords don\'t match.',
    'fos_user.new_password.blank' => 'Please enter a new password.',
    'fos_user.new_password.short' => 'The new password is too short.',
    'fos_user.current_password.invalid' => 'The entered password is invalid.',
    'fos_user.group.blank' => 'Please enter a name.',
    'fos_user.group.short' => 'The name is too short.',
    'fos_user.group.long' => 'The name is too long.',
    'fos_group.name.already_used' => 'The name is already used.',
    'This value is not a valid captcha.' => 'This value is not a valid captcha.',
    'The captcha was not resolved on the right domain.' => 'The captcha was not resolved on the right domain.',
    'validator.credit_card.invalidDate' => 'This value should be a valid date.',
    'Please enter a message' => 'Please enter a message',
    'Please enter a permalink' => 'Please enter a permalink',
    'Please enter an id' => 'Please enter an id',
    'Please provide a valid url' => 'Please provide a valid url',
    'The file should be an image' => 'The file should be an image',
    'The message is too short|The message is too short' => 'The message is too short|The message is too short',
    'The password fields must match.' => 'The password fields must match.',
    'You must set the default locale at least for the translation fields' => 'You must set the default locale at least for the translation fields',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'An authentication exception occurred.',
    'Authentication credentials could not be found.' => 'Authentication credentials could not be found.',
    'Authentication request could not be processed due to a system problem.' => 'Authentication request could not be processed due to a system problem.',
    'Invalid credentials.' => 'Invalid credentials.',
    'Cookie has already been used by someone else.' => 'Cookie has already been used by someone else.',
    'Not privileged to request the resource.' => 'Not privileged to request the resource.',
    'Invalid CSRF token.' => 'Invalid CSRF token.',
    'No authentication provider found to support the authentication token.' => 'No authentication provider found to support the authentication token.',
    'No session available, it either timed out or cookies are not enabled.' => 'No session available, it either timed out or cookies are not enabled.',
    'No token could be found.' => 'No token could be found.',
    'Username could not be found.' => 'Username could not be found.',
    'Account has expired.' => 'Account has expired.',
    'Credentials have expired.' => 'Credentials have expired.',
    'Account is disabled.' => 'Account is disabled.',
    'Account is locked.' => 'Account is locked.',
  ),
  'KnpPaginatorBundle' => 
  array (
    'label_previous' => 'Previous',
    'label_next' => 'Next',
  ),
  'VichUploaderBundle' => 
  array (
    'download' => 'Download',
    'form.label.delete' => 'Delete?',
  ),
  'FOSUserBundle' => 
  array (
    'group.edit.submit' => 'Update group',
    'group.show.name' => 'Group name',
    'group.new.submit' => 'Create group',
    'group.flash.updated' => 'The group has been updated.',
    'group.flash.created' => 'The group has been created.',
    'group.flash.deleted' => 'The group has been deleted.',
    'security.login.username' => 'Username',
    'security.login.password' => 'Password',
    'security.login.remember_me' => 'Remember me',
    'security.login.submit' => 'Log in',
    'profile.show.username' => 'Username',
    'profile.show.email' => 'Email',
    'profile.edit.submit' => 'Update',
    'profile.flash.updated' => 'The profile has been updated.',
    'change_password.submit' => 'Change password',
    'change_password.flash.success' => 'The password has been changed.',
    'registration.check_email' => 'An email has been sent to %email%. It contains an activation link you must click to activate your account.
',
    'registration.confirmed' => 'Congrats %username%, your account is now activated.',
    'registration.back' => 'Back to the originating page.',
    'registration.submit' => 'Register',
    'registration.flash.user_created' => 'The user has been created successfully.',
    'registration.email.subject' => 'Welcome %username%!',
    'registration.email.message' => 'Hello %username%!

To finish activating your account - please click on the following link %confirmationUrl%

This link can only be used once to validate your account.

Regards,
the Team.
',
    'resetting.check_email' => 'An email has been sent. It contains a link you must click to reset your password.
Note: You can only request a new password once within %tokenLifetime% hours.

If you don\'t get an email check your spam folder or try again.
',
    'resetting.request.username' => 'Username or email address',
    'resetting.request.submit' => 'Reset password',
    'resetting.reset.submit' => 'Change password',
    'resetting.flash.success' => 'The password has been reset successfully.',
    'resetting.email.subject' => 'Reset Password',
    'resetting.email.message' => 'Hello %username%!

To reset your password - please visit %confirmationUrl%

Regards,
the Team.
',
    'layout.logout' => 'Log out',
    'layout.login' => 'Log in',
    'layout.register' => 'Register',
    'layout.logged_in_as' => 'Logged in as %username%',
    'form.group_name' => 'Group name',
    'form.username' => 'Username',
    'form.email' => 'Email',
    'form.current_password' => 'Current password',
    'form.password' => 'Password',
    'form.password_confirmation' => 'Repeat password',
    'form.new_password' => 'New password',
    'form.new_password_confirmation' => 'Repeat new password',
    'Password' => 'Password',
    'Privacy policy' => 'Privacy policy',
    'Terms of service' => 'Terms of service',
    'Welcome' => 'Welcome',
  ),
  'HWIOAuthBundle' => 
  array (
    'header.connecting' => 'Connecting',
    'header.success' => 'Successfully connected the account "%name%"!',
    'header.register' => 'Register with the account "%name%"',
    'header.registration_success' => 'Successfully registered and connected the account "%username%"!',
    'connect.confirm.cancel' => 'Cancel',
    'connect.confirm.submit' => 'Connect account',
    'connect.confirm.text' => 'Are you sure that you want to connect your %service% account "%name%" to your current account?',
    'connect.registration.cancel' => 'Cancel',
    'connect.registration.submit' => 'Register account',
  ),
  'time' => 
  array (
    'diff.ago.year' => '1 year ago|%count% years ago',
    'diff.ago.month' => '1 month ago|%count% months ago',
    'diff.ago.day' => '1 day ago|%count% days ago',
    'diff.ago.hour' => '1 hour ago|%count% hours ago',
    'diff.ago.minute' => '1 minute ago|%count% minutes ago',
    'diff.ago.second' => '1 second ago|%count% seconds ago',
    'diff.empty' => 'now',
    'diff.in.second' => 'in 1 second|in %count% seconds',
    'diff.in.hour' => 'in 1 hour|in %count% hours',
    'diff.in.minute' => 'in 1 minute|in %count% minutes',
    'diff.in.day' => 'in 1 day|in %count% days',
    'diff.in.month' => 'in 1 month|in %count% months',
    'diff.in.year' => 'in 1 year|in %count% years',
  ),
  'FOSCommentBundle' => 
  array (
    'fos_comment_comment_new_headline_first' => 'You are the first to comment !',
    'fos_comment_comment_new_headline' => 'Add a new comment',
    'fos_comment_comment_new_submit' => 'Save',
    'fos_comment_comment_new_cancel' => 'Cancel',
    'fos_comment_comment_edit_submit' => 'Save',
    'fos_comment_comment_edit_cancel' => 'Cancel',
    'fos_comment_comment_reply_reply_to' => 'Reply',
    'fos_comment_comment_reply_cancel' => 'Cancel',
    'fos_comment_comment_show_by' => 'By',
    'fos_comment_comment_show_voteup' => 'Vote up',
    'fos_comment_comment_show_votedown' => 'Vote down',
    'fos_comment_comment_show_reply' => 'Reply',
    'fos_comment_comment_vote_score' => 'Vote',
    'fos_comment_comment_tree_load_more' => 'Load More Replies',
    'fos_comment_rss_feed' => 'RSS Feed',
    'fos_comment_thread_close' => 'Close thread',
    'fos_comment_thread_open' => 'Open thread',
    'fos_comment_thread_comment_count' => 'Comments',
    'fos_comment_comment_edit' => 'Edit',
    'fos_comment_comment_delete' => 'Delete',
    'fos_comment_comment_undelete' => 'Comment undeleted',
    'fos_comment_comment_deleted' => 'Comment deleted',
  ),
  'PayumBundle' => 
  array (
    'form.credit_card.holder' => 'Holder Name',
    'form.credit_card.expire_at' => 'Expiration Date',
    'form.credit_card.number' => 'Card Number',
    'form.credit_card.security_code' => 'Security (CVV) Code',
    'form.choice.paypal_express_checkout' => 'Paypal Express Checkout',
  ),
  'messages' => 
  array (
    'coresphere_console.headline.index' => 'Console',
    'coresphere_console.working_directory' => 'Working directory',
    'coresphere_console.environment' => 'Environment',
    'coresphere_console.welcome_message' => 'Type %command% to get a list of all commands.',
    'coresphere_console.loading' => 'Loading...',
    'coresphere_console.suggestion_head' => 'Did you mean:',
    'coresphere_console.empty_response' => 'Complete!',
    '%cartElementsCount% event(s) currently in cart' => '%cartElementsCount% event(s) currently in cart',
    '%mins% left before tickets are released' => '%mins% left before tickets are released',
    '%resultsCount% attendee(s) found' => '%resultsCount% attendee(s) found',
    '%resultsCount% event date(s) found' => '%resultsCount% event date(s) found',
    '%resultsCount% event(s)' => '%resultsCount% event(s)',
    '%resultsCount% event(s) currently on sale' => '%resultsCount% event(s) currently on sale',
    '%resultsCount% event(s) found' => '%resultsCount% event(s) found',
    '%resultsCount% post(s) found' => '%resultsCount% post(s) found',
    '%resultsCount% result(s) found' => '%resultsCount% result(s) found',
    '%resultsCount% results found' => '%resultsCount% results found',
    '%resultsCount% reviews(s) found' => '%resultsCount% reviews(s) found',
    '%tickets% ticket(s) are still reserved for you, please wait until the reservation expires at %expirationDate% in order to purchase more tickets' => '%tickets% ticket(s) are still reserved for you, please wait until the reservation expires at %expirationDate% in order to purchase more tickets',
    '%websiteName% is undergoing a scheduled maintenance.' => '%websiteName% is undergoing a scheduled maintenance.',
    1 => '1',
    '1 star' => '1 star',
    10 => '10',
    11 => '11',
    12 => '12',
    13 => '13',
    14 => '14',
    15 => '15',
    2 => '2',
    '2 stars' => '2 stars',
    3 => '3',
    '3 stars' => '3 stars',
    4 => '4',
    '4 stars' => '4 stars',
    5 => '5',
    '5 stars' => '5 stars',
    6 => '6',
    7 => '7',
    8 => '8',
    9 => '9',
    'A payout can not be requested on a free event date' => 'A payout can not be requested on a free event date',
    'A payout can only be requested after at least one online successful sale' => 'A payout can only be requested after at least one online successful sale',
    'A payout is already requested for this event date' => 'A payout is already requested for this event date',
    'About the organizer' => 'About the organizer',
    'About us' => 'About us',
    'Access denied' => 'Access denied',
    'Access granted' => 'Access granted',
    'Access is denied. You may not have the appropriate permissions to access this resource.' => 'Access is denied. You may not have the appropriate permissions to access this resource.',
    'Account' => 'Account',
    'Account information' => 'Account information',
    'Account settings' => 'Account settings',
    'Account status' => 'Account status',
    'Actions' => 'Actions',
    'Active attendees' => 'Active attendees',
    'Active organizers' => 'Active organizers',
    'Add a blog post' => 'Add a blog post',
    'Add a help center article' => 'Add a help center article',
    'Add a new amenity' => 'Add a new amenity',
    'Add a new audience' => 'Add a new audience',
    'Add a new blog post' => 'Add a new blog post',
    'Add a new blog post category' => 'Add a new blog post category',
    'Add a new category' => 'Add a new category',
    'Add a new country' => 'Add a new country',
    'Add a new currency' => 'Add a new currency',
    'Add a new event' => 'Add a new event',
    'Add a new help center article' => 'Add a new help center article',
    'Add a new help center category' => 'Add a new help center category',
    'Add a new language' => 'Add a new language',
    'Add a new page' => 'Add a new page',
    'Add a new payment gateway' => 'Add a new payment gateway',
    'Add a new point of sale' => 'Add a new point of sale',
    'Add a new scanner' => 'Add a new scanner',
    'Add a new venue' => 'Add a new venue',
    'Add a new venue type' => 'Add a new venue type',
    'Add events to your favorites by clicking the heart button' => 'Add events to your favorites by clicking the heart button',
    'Add other images that represent your event to be displayed as a gallery' => 'Add other images that represent your event to be displayed as a gallery',
    'Add to calendar' => 'Add to calendar',
    'Add to cart' => 'Add to cart',
    'Add to favorites' => 'Add to favorites',
    'Add your review' => 'Add your review',
    'Add your review for %eventname%' => 'Add your review for %eventname%',
    'Added to favorites by' => 'Added to favorites by',
    'Additional note' => 'Additional note',
    'Address' => 'Address',
    'After editing a translation in the javascript domain, go to the Console page and execute the following command to update the related files: bazinga:js-translation:dump assets/js --format=js --merge-domains' => 'After editing a translation in the javascript domain, go to the Console page and execute the following command to update the related files: bazinga:js-translation:dump assets/js --format=js --merge-domains',
    'After editing a translation in the javascript domain, make sure to execute the following command to update the related files: php bin/console bazinga:js-translation:dump assets/js --format=js --merge-domains' => 'After editing a translation in the javascript domain, make sure to execute the following command to update the related files: php bin/console bazinga:js-translation:dump assets/js --format=js --merge-domains',
    'After editing a translation message, go to the Console page and execute the following command: cache:clear --env=prod in order to apply the changes in the production environment' => 'After editing a translation message, go to the Console page and execute the following command: cache:clear --env=prod in order to apply the changes in the production environment',
    'All' => 'All',
    'All categories' => 'All categories',
    'All event dates for an organizer' => 'All event dates for an organizer',
    'All orders for an organizer' => 'All orders for an organizer',
    'All payout requests for an organizer' => 'All payout requests for an organizer',
    'Allow Paypal as a payout method for the organizers to receive their revenue' => 'Allow Paypal as a payout method for the organizers to receive their revenue',
    'Allow Stripe as a payout method for the organizers to receive their revenue' => 'Allow Stripe as a payout method for the organizers to receive their revenue',
    'Allow attendees to leave reviews' => 'Allow attendees to leave reviews',
    'Allow tap to check in on the scanner app' => 'Allow tap to check in on the scanner app',
    'Already have an account?' => 'Already have an account?',
    'Alternative date and time format' => 'Alternative date and time format',
    'Amenities' => 'Amenities',
    'Amount' => 'Amount',
    'An error has occured' => 'An error has occured',
    'An error has occured while processing your request' => 'An error has occured while processing your request',
    'An error might occur if the command execution time reaches your PHP max_execution_time directive' => 'An error might occur if the command execution time reaches your PHP max_execution_time directive',
    'Anything' => 'Anything',
    'Anytime' => 'Anytime',
    'Anywhere' => 'Anywhere',
    'App Debugging' => 'App Debugging',
    'App Environment' => 'App Environment',
    'App Secret' => 'App Secret',
    'Application layout' => 'Application layout',
    'Application theme' => 'Application theme',
    'Approve' => 'Approve',
    'Approved' => 'Approved',
    'Are you ready to take your' => 'Are you ready to take your',
    'Article details' => 'Article details',
    'Articles' => 'Articles',
    'Articles count' => 'Articles count',
    'Artists' => 'Artists',
    'Assigned events' => 'Assigned events',
    'Attendance' => 'Attendance',
    'Attendee' => 'Attendee',
    'Attendee / POS' => 'Attendee / POS',
    'Attendee Name / Email' => 'Attendee Name / Email',
    'Attendee Registration' => 'Attendee Registration',
    'Attendee information' => 'Attendee information',
    'Attendee name or email, ticket reference, order reference' => 'Attendee name or email, ticket reference, order reference',
    'Attendee status' => 'Attendee status',
    'Attendee tickets' => 'Attendee tickets',
    'Attendees' => 'Attendees',
    'Attendees Check In' => 'Attendees Check In',
    'Attendees check-in' => 'Attendees check-in',
    'Attendees list' => 'Attendees list',
    'Attendees reviews' => 'Attendees reviews',
    'Attendees summary' => 'Attendees summary',
    'Audience' => 'Audience',
    'Audiences' => 'Audiences',
    'Authentification Pages' => 'Authentication Pages',
    'Authorized' => 'Authorized',
    'Automatically canceled before deletion' => 'Automatically canceled before deletion',
    'Availability' => 'Availability',
    'Available languages' => 'Available languages',
    'Availibility' => 'Availibility',
    'Avatar' => 'Avatar',
    'Awaiting payment' => 'Awaiting payment',
    'Besides the qr code scanning feature, the scanner account will be able to check in the attendees using a list and a button' => 'Besides the qr code scanning feature, the scanner account will be able to check in the attendees using a list and a button',
    'Best regards, the %website_name% team' => 'Best regards, the %website_name% team',
    'Billing information' => 'Billing information',
    'Birthdate' => 'Birthdate',
    'Blog' => 'Blog',
    'Blog Pages' => 'Blog Pages',
    'Blog page' => 'Blog page',
    'Blog post' => 'Blog post',
    'Blog posts count' => 'Blog posts count',
    'Blog settings' => 'Blog settings',
    'Bought on' => 'Bought on',
    'Bought tickets' => 'Bought tickets',
    'Browse events' => 'Browse events',
    'Buy more tickets' => 'Buy more tickets',
    'Buy tickets' => 'Buy tickets',
    'By clicking the Sign Up button, I agree to' => 'By clicking the Sign Up button, I agree to',
    'CCY' => 'CCY',
    'Cancel' => 'Cancel',
    'Canceled' => 'Canceled',
    'Captured' => 'Captured',
    'Cart' => 'Cart',
    'Cart elements' => 'Cart elements',
    'Cash / Check / Offline' => 'Cash / Check / Offline',
    'Categories' => 'Categories',
    'Categories page' => 'Categories page',
    'Category' => 'Category',
    'Ccy' => 'Ccy',
    'Change password' => 'Change password',
    'Check In' => 'Check In',
    'Check In Attendees for this event date' => 'Check In Attendees for this event date',
    'Check your email inbox' => 'Check your email inbox',
    'Checked In At' => 'Checked In At',
    'Checked In Only' => 'Checked In Only',
    'Checkout' => 'Checkout',
    'Checkout settings' => 'Checkout settings',
    'Choose a new image to replace the old one' => 'Choose a new image to replace the old one',
    'Choose a payment gateway' => 'Choose a payment gateway',
    'Choose the link destination page' => 'Choose the link destination page',
    'Choose the right image to represent your event (We recommend using at least a 1200x600px (2:1 ratio) image )' => 'Choose the right image to represent your event (We recommend using at least a 1200x600px (2:1 ratio) image )',
    'City' => 'City',
    'Clear the application cache for the development environment' => 'Clear the application cache for the development environment',
    'Clear the application cache for the production environment' => 'Clear the application cache for the production environment',
    'Click here' => 'Click here',
    'Close' => 'Close',
    'Compact' => 'Compact',
    'Configuration' => 'Configuration',
    'Confirm' => 'Confirm',
    'Confirm account' => 'Confirm account',
    'Confirm payment and place order' => 'Confirm payment and place order',
    'Confirm payout request' => 'Confirm payout request',
    'Confirmation required' => 'Confirmation required',
    'Console' => 'Console',
    'Contact' => 'Contact',
    'Contact & Social media' => 'Contact & Social media',
    'Contact Us' => 'Contact Us',
    'Contact address' => 'Contact address',
    'Contact email' => 'Contact email',
    'Contact email address' => 'Contact email address',
    'Contact fax' => 'Contact fax',
    'Contact information' => 'Contact information',
    'Contact phone' => 'Contact phone',
    'Contact phone number' => 'Contact phone number',
    'Contact the organizer' => 'Contact the organizer',
    'Contact us' => 'Contact us',
    'Contenido' => 'Contenido',
    'Content' => 'Content',
    'Contenu' => 'Contenu',
    'Cookie policy' => 'Cookie policy',
    'Cookie policy page slug' => 'Cookie policy page slug',
    'Copyright' => 'Copyright',
    'Count' => 'Count',
    'Countries' => 'Countries',
    'Country' => 'Country',
    'Country code' => 'Country code',
    'Cover photo' => 'Cover photo',
    'Cover picture' => 'Cover picture',
    'Create Account' => 'Create Account',
    'Create an account' => 'Create an account',
    'Create event' => 'Create event',
    'Create my event' => 'Create my event',
    'Created by organizer' => 'Created by organizer',
    'Creation date' => 'Creation date',
    'Creation date / Last login' => 'Creation date / Last login',
    'Credit or debit card' => 'Credit or debit card',
    'Currency' => 'Currency',
    'Currency symbol' => 'Currency symbol',
    'Currency symbol position' => 'Currency symbol position',
    'Currently in cart' => 'Currently in cart',
    'Custom css' => 'Custom css',
    'Custom hero' => 'Custom hero',
    'Custom hero background image' => 'Custom hero background image',
    'Custom hero title and paragraph translation' => 'Custom hero title and paragraph translation',
    'Custom link' => 'Custom link',
    'Dark' => 'Dark',
    'Dark blue' => 'Dark blue',
    'Dashboard' => 'Dashboard',
    'Dashboard Pages' => 'Dashboard Pages',
    'Date' => 'Date',
    'Date and time format' => 'Date and time format',
    'Date only format' => 'Date only format',
    'Dates' => 'Dates',
    'Default language' => 'Default language',
    'Delete' => 'Delete',
    'Delete permanently' => 'Delete permanently',
    'Deleted' => 'Deleted',
    'Deletion date' => 'Deletion date',
    'Descripción' => 'Descripción',
    'Description' => 'Description',
    'Details' => 'Details',
    'Development' => 'Development',
    'Development environment is used for development purposes only' => 'Development environment is used for development purposes only',
    'Disable' => 'Disable',
    'Disabled' => 'Disabled',
    'Disabled only' => 'Disabled only',
    'Display itinerary bicycling' => 'Display itinerary bicycling',
    'Display itinerary driving' => 'Display itinerary driving',
    'Display itinerary on public transportation' => 'Display itinerary on public transportation',
    'Display itinerary walking' => 'Display itinerary walking',
    'Display top 4 featured categories (footer section menu only)' => 'Display top 4 featured categories (footer section menu only)',
    'Disqus comments' => 'Disqus comments',
    'Disqus subdomain' => 'Disqus subdomain',
    'Draft' => 'Draft',
    'Draft only' => 'Draft only',
    'Early bird, General admission, VIP...' => 'Early bird, General admission, VIP...',
    'Edit' => 'Edit',
    'Edit the menu' => 'Edit the menu',
    'Edit your organizer profile' => 'Edit your organizer profile',
    'Editing the title after the event is saved won\'t change the event url' => 'Editing the title after the event is saved won\'t change the event url',
    'Elapsed only' => 'Elapsed only',
    'Elements' => 'Elements',
    'Email' => 'Email',
    'Email address' => 'Email address',
    'Empty cart' => 'Empty cart',
    'En cabeza' => 'En cabeza',
    'En-tête' => 'En-tête',
    'Enable' => 'Enable',
    'Enable Facebook Social Login' => 'Enable Facebook Social Login',
    'Enable Google Repatcha' => 'Enable Google Repatcha',
    'Enable Google Social Login' => 'Enable Google Social Login',
    'Enable comments' => 'Enable comments',
    'Enable maintenance mode to display a maintenance page for all users but the users who are granted the ROLE_ADMINISTRATOR role, if you lost your session, you can edit the MAINTENANCE_MODE parameter directly in the .env file' => 'Enable maintenance mode to display a maintenance page for all users but the users who are granted the ROLE_ADMINISTRATOR role, if you lost your session, you can edit the MAINTENANCE_MODE parameter directly in the .env file',
    'Enable newsletter' => 'Enable newsletter',
    'Enable reviews' => 'Enable reviews',
    'Enable sales for this event date ?' => 'Enable sales for this event date ?',
    'Enable sales for this ticket ?' => 'Enable sales for this ticket ?',
    'Enable to display stacktraces on error pages or if cache files should be dynamically rebuilt on each request' => 'Enable to display stacktraces on error pages or if cache files should be dynamically rebuilt on each request',
    'Enabled' => 'Enabled',
    'Enabled only' => 'Enabled only',
    'Enabling sales for an event date does not affect the tickets individual sale status' => 'Enabling sales for an event date does not affect the tickets individual sale status',
    'Encryption' => 'Encryption',
    'End date' => 'End date',
    'Ends On' => 'Ends On',
    'Enlarge' => 'Enlarge',
    'Enter the chosen primary color code (i.e #ffffff)' => 'Enter the chosen primary color code (i.e #ffffff)',
    'Enter the chosen website name with no spaces and no uppercase characters (for SEO purposes)' => 'Enter the chosen website name with no spaces and no uppercase characters (for SEO purposes)',
    'Enter the email address to be reached for inquiries' => 'Enter the email address to be reached for inquiries',
    'Enter the full website url' => 'Enter the full website url',
    'Enter the list of artists that will perform in your event (press Enter after each entry)' => 'Enter the list of artists that will perform in your event (press Enter after each entry)',
    'Enter the phone number to be called for inquiries' => 'Enter the phone number to be called for inquiries',
    'Enter the website url without http nor https' => 'Enter the website url without http nor https',
    'Enter the website url without http nor https, Please make sure to change this parameter also in .env file at the root folder of the project as it is required in some external bundle' => 'Enter the website url without http nor https, Please make sure to change this parameter also in .env file at the root folder of the project as it is required in some external bundle',
    'Error' => 'Error',
    'Etiquetas' => 'Etiquetas',
    'Event' => 'Event',
    'Event / Ticket' => 'Event / Ticket',
    'Event Categories' => 'Event Categories',
    'Event already started' => 'Event already started',
    'Event categories' => 'Event categories',
    'Event date' => 'Event date',
    'Event date is disabled' => 'Event date is disabled',
    'Event date status' => 'Event date status',
    'Event dates' => 'Event dates',
    'Event details' => 'Event details',
    'Event is not published' => 'Event is not published',
    'Event list' => 'Event list',
    'Event ticket' => 'Event ticket',
    'Event ticket is disabled' => 'Event ticket is disabled',
    'Event ticket status' => 'Event ticket status',
    'Event tickets' => 'Event tickets',
    'Event views' => 'Event views',
    'Events' => 'Events',
    'Events Pages' => 'Events Pages',
    'Events RSS feed' => 'Events RSS feed',
    'Events added' => 'Events added',
    'Events count' => 'Events count',
    'Events in %countryname%' => 'Events in %countryname%',
    'Events list' => 'Events list',
    'Events list page' => 'Events list page',
    'Events list page settings' => 'Events list page settings',
    'Events on sale' => 'Events on sale',
    'Events page' => 'Events page',
    'Events slider' => 'Events slider',
    'Events summary' => 'Events summary',
    'Execute Symfony commands' => 'Execute Symfony commands',
    'Execute command' => 'Execute command',
    'Execute this command after editing a file in the application source code or after modifying a string in the translations files' => 'Execute this command after editing a file in the application source code or after modifying a string in the translations files',
    'Execute this command if you are in the development mode and the modifications you applied in the application did take effect' => 'Execute this command if you are in the development mode and the modifications you applied in the application did take effect',
    'Explore' => 'Explore',
    'Explore events' => 'Explore events',
    'Export attendees list to a PDF file' => 'Export attendees list to a PDF file',
    'Export current orders to a CSV file' => 'Export current orders to a CSV file',
    'Export current orders to an Excel file' => 'Export current orders to an Excel file',
    'External link' => 'External link',
    'FAQ' => 'FAQ',
    'Facebook' => 'Facebook',
    'Facebook Id' => 'Facebook Id',
    'Facebook Secret' => 'Facebook Secret',
    'Facebook app id' => 'Facebook app id',
    'Facebook comments' => 'Facebook comments',
    'Facebook profile picture' => 'Facebook profile picture',
    'Facebook url' => 'Facebook url',
    'Failed' => 'Failed',
    'Favicon' => 'Favicon',
    'Favorites' => 'Favorites',
    'Fax' => 'Fax',
    'Featured' => 'Featured',
    'Featured categories' => 'Featured categories',
    'Featured only' => 'Featured only',
    'Featured order' => 'Featured order',
    'Fees' => 'Fees',
    'Fees & Taxes' => 'Fees & Taxes',
    'First Name' => 'First Name',
    'First name' => 'First name',
    'Flag' => 'Flag',
    'Fluid' => 'Fluid',
    'Follow' => 'Follow',
    'Followed by' => 'Followed by',
    'Followers' => 'Followers',
    'Following' => 'Following',
    'Food and beverage' => 'Food and beverage',
    'Food and beverage details' => 'Food and beverage details',
    'Forbidden' => 'Forbidden',
    'Forgot your password ?' => 'Forgot your password ?',
    'Free' => 'Free',
    'Free events only' => 'Free events only',
    'From date' => 'From date',
    'Full name' => 'Full name',
    'GDPR compliance' => 'GDPR compliance',
    'Gallery' => 'Gallery',
    'Gallery image' => 'Gallery image',
    'Gdpr compliance page slug' => 'Gdpr compliance page slug',
    'Gender' => 'Gender',
    'General information' => 'General information',
    'Generation date' => 'Generation date',
    'Global payment settings' => 'Global payment settings',
    'Gmail' => 'Gmail',
    'Go back' => 'Go back',
    'Go to the Pages section in the settings to add a new page' => 'Go to the Pages section in the settings to add a new page',
    'Go to the documentation to get help about getting a list id' => 'Go to the documentation to get help about getting a list id',
    'Go to the documentation to get help about getting an api key' => 'Go to the documentation to get help about getting an api key',
    'Go to the documentation to get help about getting an app ID' => 'Go to the documentation to get help about getting an app ID',
    'Go to the documentation to get help about setting up Disqus' => 'Go to the documentation to get help about setting up Disqus',
    'Google Id' => 'Google Id',
    'Google Maps' => 'Google Maps',
    'Google Maps Api Key' => 'Google Maps Api Key',
    'Google Plus' => 'Google Plus',
    'Google Recaptcha' => 'Google Recaptcha',
    'Google Recaptcha settings' => 'Google Recaptcha settings',
    'Google Secret' => 'Google Secret',
    'Google analytics Tracking ID' => 'Google analytics Tracking ID',
    'Google analytics code' => 'Google analytics code',
    'Google plus' => 'Google plus',
    'Green' => 'Green',
    'Gross Sales' => 'Gross Sales',
    'Gross sales' => 'Gross sales',
    'Gross sales by channel' => 'Gross sales by channel',
    'Gross sales per Point of sale' => 'Gross sales per Point of sale',
    'Guests' => 'Guests',
    'Header' => 'Header',
    'Header text' => 'Header text',
    'Help Center Article' => 'Help Center Article',
    'Help Center Category' => 'Help Center Category',
    'Help Center Pages' => 'Help Center Pages',
    'Help Center page' => 'Help Center page',
    'Help center' => 'Help center',
    'Here are the details' => 'Here are the details',
    'Hey' => 'Hey',
    'Hidden' => 'Hidden',
    'Hidden only' => 'Hidden only',
    'Hide' => 'Hide',
    'Hide from public directory' => 'Hide from public directory',
    'Hide slider' => 'Hide slider',
    'Home' => 'Home',
    'Homepage' => 'Homepage',
    'Homepage content settings' => 'Homepage content settings',
    'Homepage hero settings' => 'Homepage hero settings',
    'Homepage settings' => 'Homepage settings',
    'Host' => 'Host',
    'How can we help?' => 'How can we help?',
    'How it works' => 'How it works',
    'Icon' => 'Icon',
    'If you have an Youtube video that represents your event, add it in the standard format: https://www.youtube.com/watch?v=FzG4uDgje3M' => 'If you have an Youtube video that represents your event, add it in the standard format: https://www.youtube.com/watch?v=FzG4uDgje3M',
    'If you need to send the confirmation email to a different email address, you can change it before submitting' => 'If you need to send the confirmation email to a different email address, you can change it before submitting',
    'If your event has a dedicated website, enter its url here' => 'If your event has a dedicated website, enter its url here',
    'If your event is a movie for example, select the available subtitles' => 'If your event is a movie for example, select the available subtitles',
    'If your event is a movie for example, select the year of release' => 'If your event is a movie for example, select the year of release',
    'Image' => 'Image',
    'Images' => 'Images',
    'Images gallery' => 'Images gallery',
    'Impersonate' => 'Impersonate',
    'In' => 'In',
    'Information not provided' => 'Information not provided',
    'Information provided' => 'Information provided',
    'Insert at least 3 characters' => 'Insert at least 3 characters',
    'Instagram' => 'Instagram',
    'Instagram url' => 'Instagram url',
    'Invalid credentials' => 'Invalid credentials',
    'Is featured' => 'Is featured',
    'Is featured on the homepage slider?' => 'Is featured on the homepage slider?',
    'Is this event date online ?' => 'Is this event date online ?',
    'Is this ticket free ?' => 'Is this ticket free ?',
    'It wasn\'t possible to retrieve information about the provided IP' => 'It wasn\'t possible to retrieve information about the provided IP',
    'Keyword' => 'Keyword',
    'Language' => 'Language',
    'Language code' => 'Language code',
    'Languages' => 'Languages',
    'Last Name' => 'Last Name',
    'Last login' => 'Last login',
    'Last name' => 'Last name',
    'Last updated' => 'Last updated',
    'Lastest blog posts' => 'Lastest blog posts',
    'Layout settings' => 'Layout settings',
    'Layout, parameters and SEO' => 'Layout, parameters and SEO',
    'Leave a review' => 'Leave a review',
    'Leave api key empty to disable google maps project wide' => 'Leave api key empty to disable google maps project wide',
    'Leave the password empty to keep the old one' => 'Leave the password empty to keep the old one',
    'Left' => 'Left',
    'Let the other attendee know more details about your experience' => 'Let the other attendee know more details about your experience',
    'Light blue' => 'Light blue',
    'Link' => 'Link',
    'Link text' => 'Link text',
    'LinkedIn' => 'LinkedIn',
    'Linkedin' => 'Linkedin',
    'List on public directory' => 'List on public directory',
    'Listed on directory' => 'Listed on directory',
    'Listed on the directory' => 'Listed on the directory',
    'Load more' => 'Load more',
    'Loading...' => 'Loading...',
    'Local events only' => 'Local events only',
    'Location' => 'Location',
    'Locked (Payout request approved)' => 'Locked (Payout request approved)',
    'Locked (Payout request pending)' => 'Locked (Payout request pending)',
    'Login' => 'Login',
    'Logo' => 'Logo',
    'Looking for' => 'Looking for',
    'Mail server' => 'Mail server',
    'Mail server settings' => 'Mail server settings',
    'Mailchimp app id' => 'Mailchimp app id',
    'Mailchimp list id' => 'Mailchimp list id',
    'Main blog post image' => 'Main blog post image',
    'Main categories' => 'Main categories',
    'Main event image' => 'Main event image',
    'Main image' => 'Main image',
    'Maintenance mode' => 'Maintenance mode',
    'Maintenance mode custom message' => 'Maintenance mode custom message',
    'Make sure that the added payment gateways are configured to support this currency' => 'Make sure that the added payment gateways are configured to support this currency',
    'Make sure that the currency setting of your payout method matches the one currently used which is %currency%' => 'Make sure that the currency setting of your payout method matches the one currently used which is %currency%',
    'Make sure to enter a valid email address' => 'Make sure to enter a valid email address',
    'Make sure to select organizers who have added a cover photo' => 'Make sure to select organizers who have added a cover photo',
    'Make sure to select right category to let the users find it quickly' => 'Make sure to select right category to let the users find it quickly',
    'Manage amenities' => 'Manage amenities',
    'Manage articles' => 'Manage articles',
    'Manage attendees' => 'Manage attendees',
    'Manage audiences' => 'Manage audiences',
    'Manage blog' => 'Manage blog',
    'Manage blog post categories' => 'Manage blog post categories',
    'Manage blog posts' => 'Manage blog posts',
    'Manage categories' => 'Manage categories',
    'Manage countries' => 'Manage countries',
    'Manage currencies' => 'Manage currencies',
    'Manage event' => 'Manage event',
    'Manage events' => 'Manage events',
    'Manage help center' => 'Manage help center',
    'Manage help center articles' => 'Manage help center articles',
    'Manage help center categories' => 'Manage help center categories',
    'Manage languages' => 'Manage languages',
    'Manage menus' => 'Manage menus',
    'Manage orders' => 'Manage orders',
    'Manage pages' => 'Manage pages',
    'Manage posts' => 'Manage posts',
    'Manage reviews' => 'Manage reviews',
    'Manage users' => 'Manage users',
    'Manage venues' => 'Manage venues',
    'Manage venues amenities' => 'Manage venues amenities',
    'Manage venues types' => 'Manage venues types',
    'Manage website translation' => 'Manage website translation',
    'Mark as featured' => 'Mark as featured',
    'Mark as not featured' => 'Mark as not featured',
    'Max' => 'Max',
    'Member since' => 'Member since',
    'Menu elements' => 'Menu elements',
    'Menu name' => 'Menu name',
    'Menus' => 'Menus',
    'Menus settings' => 'Menus settings',
    'Message' => 'Message',
    'Message from the attendee:' => 'Message from the attendee:',
    'Method Not Supported' => 'Method Not Supported',
    'Min' => 'Min',
    'More details' => 'More details',
    'More information' => 'More information',
    'Mots clés' => 'Mots clés',
    'My Account' => 'My Account',
    'My cart' => 'My cart',
    'My events' => 'My events',
    'My favorites' => 'My favorites',
    'My orders' => 'My orders',
    'My organizer profile' => 'My organizer profile',
    'My points of sale' => 'My points of sale',
    'My review' => 'My review',
    'My reviews' => 'My reviews',
    'My scanners' => 'My scanners',
    'My tickets' => 'My tickets',
    'My venues' => 'My venues',
    'N/A' => 'N/A',
    'Name' => 'Name',
    'Name / Username' => 'Name / Username',
    'Native comments' => 'Native comments',
    'Neighborhoods' => 'Neighborhoods',
    'Net sales' => 'Net sales',
    'Net sales until' => 'Net sales until',
    'New' => 'New',
    'New payout request' => 'New payout request',
    'New quote request' => 'New quote request',
    'Newsletter' => 'Newsletter',
    'Newsletter settings' => 'Newsletter settings',
    'Next month' => 'Next month',
    'Next week' => 'Next week',
    'No' => 'No',
    'No amenites found' => 'No amenites found',
    'No articles found' => 'No articles found',
    'No attendees found' => 'No attendees found',
    'No audiences found' => 'No audiences found',
    'No blog post categories found' => 'No blog post categories found',
    'No blog posts found' => 'No blog posts found',
    'No categories found' => 'No categories found',
    'No countries found' => 'No countries found',
    'No currencies found' => 'No currencies found',
    'No event dates found' => 'No event dates found',
    'No events found' => 'No events found',
    'No events on sale' => 'No events on sale',
    'No events on sale for now' => 'No events on sale for now',
    'No languages found' => 'No languages found',
    'No link, display featured categories dropdown on hover (header menu only)' => 'No link, display featured categories dropdown on hover (header menu only)',
    'No menus found' => 'No menus found',
    'No orders found' => 'No orders found',
    'No orders found to be included in the report' => 'No orders found to be included in the report',
    'No pages found' => 'No pages found',
    'No past events found' => 'No past events found',
    'No payment gateways are currently enabled' => 'No payment gateways are currently enabled',
    'No payment gateways found' => 'No payment gateways found',
    'No payout requests found' => 'No payout requests found',
    'No points of sale found' => 'No points of sale found',
    'No reply email address' => 'No reply email address',
    'No results found' => 'No results found',
    'No review found' => 'No review found',
    'No reviews found' => 'No reviews found',
    'No sales yet' => 'No sales yet',
    'No scanners found' => 'No scanners found',
    'No ticket on sale' => 'No ticket on sale',
    'No tickets found' => 'No tickets found',
    'No tickets selected to add to cart' => 'No tickets selected to add to cart',
    'No users found' => 'No users found',
    'No venue types found' => 'No venue types found',
    'No venues found' => 'No venues found',
    'Nom' => 'Nom',
    'Nom du menu' => 'Nom du menu',
    'Nombre' => 'Nombre',
    'Nombre du menú' => 'Nombre du menú',
    'None' => 'None',
    'Not Checked In Only' => 'Not Checked In Only',
    'Not a member yet ?' => 'Not a member yet ?',
    'Not elapsed only' => 'Not elapsed only',
    'Not featured' => 'Not featured',
    'Not listed on the directory' => 'Not listed on the directory',
    'Note' => 'Note',
    'Number of blog posts per page' => 'Number of blog posts per page',
    'Number of blog posts to show' => 'Number of blog posts to show',
    'Number of events per page' => 'Number of events per page',
    'Number of events to show' => 'Number of events to show',
    'Number of featured categories to show' => 'Number of featured categories to show',
    'Number of guests' => 'Number of guests',
    'Number of seconds before the reserved tickets are released if the order is still awaiting payment' => 'Number of seconds before the reserved tickets are released if the order is still awaiting payment',
    'Number of tickets' => 'Number of tickets',
    'OR' => 'OR',
    'On sale' => 'On sale',
    'Once the payout request submitted, the event date will be locked and the sales will be suspended for the specific event date. If you wish, you can wait until the start date of the event date before requesting the payout. You can cancel the payout request any time before it is processed' => 'Once the payout request submitted, the event date will be locked and the sales will be suspended for the specific event date. If you wish, you can wait until the start date of the event date before requesting the payout. You can cancel the payout request any time before it is processed',
    'Online' => 'Online',
    'Online events only' => 'Online events only',
    'Optional attendee information' => 'Optional attendee information',
    'Optionally add a cover photo to showcase your organizer activities' => 'Optionally add a cover photo to showcase your organizer activities',
    'Orange' => 'Orange',
    'Order' => 'Order',
    'Order = ' => 'Order = ',
    'Order Date' => 'Order Date',
    'Order confirmation' => 'Order confirmation',
    'Order date' => 'Order date',
    'Order details' => 'Order details',
    'Order of appearance' => 'Order of appearance',
    'Order payment details' => 'Order payment details',
    'Order reference' => 'Order reference',
    'Order status' => 'Order status',
    'Order summary' => 'Order summary',
    'Order total' => 'Order total',
    'Orders' => 'Orders',
    'Orders placed' => 'Orders placed',
    'Orders summary' => 'Orders summary',
    'Organizer' => 'Organizer',
    'Organizer / Event / Date / Ticket' => 'Organizer / Event / Date / Ticket',
    'Organizer Profile' => 'Organizer Profile',
    'Organizer Registration' => 'Organizer Registration',
    'Organizer information' => 'Organizer information',
    'Organizer is disabled' => 'Organizer is disabled',
    'Organizer logo' => 'Organizer logo',
    'Organizer name' => 'Organizer name',
    'Organizer profile' => 'Organizer profile',
    'Organizer revenue from %website_name%' => 'Organizer revenue from %website_name%',
    'Organizers' => 'Organizers',
    'Organizers Pages' => 'Organizers Pages',
    'Organizers slider' => 'Organizers slider',
    'Organizers, attendees, this support center is intended to quickly reply to your questions, if still don\'t find answers, please contact us, w e will be happy to receive your inquiry' => 'Organizers, attendees, this support center is intended to quickly reply to your questions, if still don\'t find answers, please contact us, w e will be happy to receive your inquiry',
    'Other events by %organizername%' => 'Other events by %organizername%',
    'PERMANENTLY' => 'PERMANENTLY',
    'POS' => 'POS',
    'Page content' => 'Page content',
    'Page not found' => 'Page not found',
    'Pages' => 'Pages',
    'Paid' => 'Paid',
    'Paid orders' => 'Paid orders',
    'Palabras clave' => 'Palabras clave',
    'Paragraph' => 'Paragraph',
    'Paragraphe' => 'Paragraphe',
    'Parent' => 'Parent',
    'Parent category' => 'Parent category',
    'Password' => 'Password',
    'Password Resetting' => 'Password Resetting',
    'Past events' => 'Past events',
    'Past tickets' => 'Past tickets',
    'Pay now' => 'Pay now',
    'Payment' => 'Payment',
    'Payment details' => 'Payment details',
    'Payment gateways' => 'Payment gateways',
    'Payment method' => 'Payment method',
    'Payment of tickets purchased on %website_name%' => 'Payment of tickets purchased on %website_name%',
    'Payment settings' => 'Payment settings',
    'Payments and Fees' => 'Payments and Fees',
    'Payout already requested' => 'Payout already requested',
    'Payout method' => 'Payout method',
    'Payout methods' => 'Payout methods',
    'Payout request' => 'Payout request',
    'Payout request details' => 'Payout request details',
    'Payout request notification' => 'Payout request notification',
    'Payout request payment details' => 'Payout request payment details',
    'Payout requests' => 'Payout requests',
    'Payouts' => 'Payouts',
    'Paypal Client Id' => 'Paypal Client Id',
    'Paypal Client Secret' => 'Paypal Client Secret',
    'Paypal Express Checkout' => 'Paypal Express Checkout',
    'Pending' => 'Pending',
    'Pending payout requests' => 'Pending payout requests',
    'Percentage cut' => 'Percentage cut',
    'Phone' => 'Phone',
    'Phone number' => 'Phone number',
    'Photos' => 'Photos',
    'Pick a date' => 'Pick a date',
    'Pink' => 'Pink',
    'Please choose a 200x200 minimum image size as it is required by Facebook' => 'Please choose a 200x200 minimum image size as it is required by Facebook',
    'Please choose a 200x50 image size to ensure compatibility with the website design' => 'Please choose a 200x50 image size to ensure compatibility with the website design',
    'Please choose a 200x50 image to ensure compatibility with the website design' => 'Please choose a 200x50 image to ensure compatibility with the website design',
    'Please click on the following link to check the status of your request' => 'Please click on the following link to check the status of your request',
    'Please confirm your account by clicking the link below' => 'Please confirm your account by clicking the link below',
    'Please enter the selected payment gateway details' => 'Please enter the selected payment gateway details',
    'Please enter the subject carefully in order get the help you need' => 'Please enter the subject carefully in order get the help you need',
    'Please enter your payout method details' => 'Please enter your payout method details',
    'Please make sure to change this parameter also in .env file at the root folder of the project as it is required in some external bundle' => 'Please make sure to change this parameter also in .env file at the root folder of the project as it is required in some external bundle',
    'Please refer to this following list and use the Code column: https://en.wikipedia.org/wiki/ISO_4217' => 'Please refer to thefollowing list and use the Code column: https://en.wikipedia.org/wiki/ISO_4217',
    'Please select the tickets quantity for this order' => 'Please select the tickets quantity for this order',
    'Please select the tickets quantity you want to buy' => 'Please select the tickets quantity you want to buy',
    'Please set a payout method before submitting a payout request' => 'Please set a payout method before submitting a payout request',
    'Please wait a few seconds if the translation interface freezes at page load' => 'Please wait a few seconds if the translation interface freezes at page load',
    'Please wait a few seconds if the translation interface freezes at page load, or edit the files in translations/ folder at root of the project directly in your favorite text editor' => 'Please wait a few seconds if the translation interface freezes at page load, or edit the files in translations/ folder at root of the project directly in your favorite text editor',
    'Point of sale' => 'Point of sale',
    'Point of sale information' => 'Point of sale information',
    'Point of sales' => 'Point of sales',
    'Points of sale' => 'Points of sale',
    'Popular' => 'Popular',
    'Popularity' => 'Popularity',
    'Port' => 'Port',
    'Position' => 'Position',
    'Postal code' => 'Postal code',
    'Posts' => 'Posts',
    'Price' => 'Price',
    'Pricing' => 'Pricing',
    'Pricing and fees' => 'Pricing and fees',
    'Primary color code' => 'Primary color code',
    'Print tickets' => 'Print tickets',
    'Privacy policy' => 'Privacy policy',
    'Privacy policy page slug' => 'Privacy policy page slug',
    'Processed' => 'Processed',
    'Processed at' => 'Processed at',
    'Processing date' => 'Processing date',
    'Production' => 'Production',
    'Profile picture' => 'Profile picture',
    'Profile views' => 'Profile views',
    'Project wide date and time format, follow this link for a list of supported characters: https://unicode-org.github.io/icu/userguide/format_parse/datetime/ . Please make sure to keep the double quotes " " around the format string' => 'Project wide date and time format, follow this link for a list of supported characters: https://unicode-org.github.io/icu/userguide/format_parse/datetime/ . Please make sure to keep the double quotes " " around the format string',
    'Promotional price' => 'Promotional price',
    'Publicly show attendees' => 'Publicly show attendees',
    'Publish' => 'Publish',
    'Published events' => 'Published events',
    'Published only' => 'Published only',
    'Purple' => 'Purple',
    'Párrafo' => 'Párrafo',
    'Quantity' => 'Quantity',
    'Rating' => 'Rating',
    'Read more' => 'Read more',
    'Read time in minutes' => 'Read time in minutes',
    'Recent orders' => 'Recent orders',
    'Red' => 'Red',
    'Reference' => 'Reference',
    'Refund' => 'Refund',
    'Refund requested' => 'Refund requested',
    'Refunded' => 'Refunded',
    'Register' => 'Register',
    'Register attendees' => 'Register attendees',
    'Registered using Facebook' => 'Registered using Facebook',
    'Registered using Google' => 'Registered using Google',
    'Registration date' => 'Registration date',
    'Related posts' => 'Related posts',
    'Remove' => 'Remove',
    'Remove from favorites' => 'Remove from favorites',
    'Repeat password' => 'Repeat password',
    'Reports' => 'Reports',
    'Request a quote' => 'Request a quote',
    'Request date' => 'Request date',
    'Request payout' => 'Request payout',
    'Requested at' => 'Requested at',
    'Resend confirmation email' => 'Resend confirmation email',
    'Reset' => 'Reset',
    'Reset your password' => 'Reset your password',
    'Response' => 'Response',
    'Restore' => 'Restore',
    'Return to cart' => 'Return to cart',
    'Review date' => 'Review date',
    'Review(s)' => 'Review(s)',
    'Reviews' => 'Reviews',
    'Reviews for %eventname%' => 'Reviews for %eventname%',
    'Right' => 'Right',
    'Role' => 'Role',
    'SEO keywords' => 'SEO keywords',
    'SMTP' => 'SMTP',
    'SSL' => 'SSL',
    'SSL must be activated on your hosting server in order to use Mailchimp' => 'SSL must be activated on your hosting server in order to use Mailchimp',
    'Sale didn\'t start yet' => 'Sale didn\'t start yet',
    'Sale ended' => 'Sale ended',
    'Sale ends On' => 'Sale ends On',
    'Sale starts On' => 'Sale starts On',
    'Sales' => 'Sales',
    'Sales channel' => 'Sales channel',
    'Sales end' => 'Sales end',
    'Sales end date' => 'Sales end date',
    'Sales end in' => 'Sales end in',
    'Sales ended' => 'Sales ended',
    'Sales ended on' => 'Sales ended on',
    'Sales start date' => 'Sales start date',
    'Sales start in' => 'Sales start in',
    'Sales started' => 'Sales started',
    'Sales started on' => 'Sales started on',
    'Sandbox' => 'Sandbox',
    'Save' => 'Save',
    'Save order' => 'Save order',
    'Scanned tickets' => 'Scanned tickets',
    'Scanner' => 'Scanner',
    'Scanner App' => 'Scanner App',
    'Scanner App settings' => 'Scanner App settings',
    'Scanner information' => 'Scanner information',
    'Scanners' => 'Scanners',
    'Search' => 'Search',
    'Search blog' => 'Search blog',
    'Search blog posts' => 'Search blog posts',
    'Search for answers' => 'Search for answers',
    'Search for events' => 'Search for events',
    'Search help center' => 'Search help center',
    'Search in reviews' => 'Search in reviews',
    'Searching ...' => 'Searching ...',
    'Seated' => 'Seated',
    'Seated guests' => 'Seated guests',
    'Seated guests number' => 'Seated guests number',
    'Secret key' => 'Secret key',
    'See all' => 'See all',
    'See all %reviewscount% reviews' => 'See all %reviewscount% reviews',
    'See all categories' => 'See all categories',
    'See all events on sale' => 'See all events on sale',
    'See more articles' => 'See more articles',
    'See more events' => 'See more events',
    'Select a payout method' => 'Select a payout method',
    'Select a specific event date' => 'Select a specific event date',
    'Select a specific event ticket' => 'Select a specific event ticket',
    'Select an option' => 'Select an option',
    'Select parent of \'Point of sale\' or \'Scanner\'' => 'Select parent of \'Point of sale\' or \'Scanner\'',
    'Select the audience types that are targeted in your event' => 'Select the audience types that are targeted in your event',
    'Select the categories that represent your events types' => 'Select the categories that represent your events types',
    'Select the country that your event represents (ie: A movie\'s country of production)' => 'Select the country that your event represents (ie: A movie\'s country of production)',
    'Select the languages that will be spoken in your event' => 'Select the languages that will be spoken in your event',
    'Select the parent category to add a sub category' => 'Select the parent category to add a sub category',
    'Sell tickets online' => 'Sell tickets online',
    'Send' => 'Send',
    'Send us an email' => 'Send us an email',
    'Sendmail' => 'Sendmail',
    'Set' => 'Set',
    'Set a new password' => 'Set a new password',
    'Set a price lesser than than the original price to indicate a promotion (this price will be the SALE price)' => 'Set a price lesser than than the original price to indicate a promotion (this price will be the SALE price)',
    'Set the display order for the featured categories' => 'Set the display order for the featured categories',
    'Set the number of tickets that an attendee can buy for this ticket type' => 'Set the number of tickets that an attendee can buy for this ticket type',
    'Set the parent category to add a subcategory' => 'Set the parent category to add a subcategory',
    'Set your %payoutMethodName% payout method' => 'Set your %payoutMethodName% payout method',
    'Settings' => 'Settings',
    'Share' => 'Share',
    'Show' => 'Show',
    'Show RSS feed button' => 'Show RSS feed button',
    'Show a map at the bottom of your organizer profile page containing the venues you added' => 'Show a map at the bottom of your organizer profile page containing the venues you added',
    'Show audience filter' => 'Show audience filter',
    'Show calendar button' => 'Show calendar button',
    'Show category filter' => 'Show category filter',
    'Show date filter' => 'Show date filter',
    'Show event date stats on the scanner app' => 'Show event date stats on the scanner app',
    'Show event dates and tickets' => 'Show event dates and tickets',
    'Show events calendar' => 'Show events calendar',
    'Show events on map' => 'Show events on map',
    'Show followers' => 'Show followers',
    'Show location filter' => 'Show location filter',
    'Show map button' => 'Show map button',
    'Show reviews' => 'Show reviews',
    'Show the GDPR compliance page link' => 'Show the GDPR compliance page link',
    'Show the attendees number and list in the event page' => 'Show the attendees number and list in the event page',
    'Show the back to top button' => 'Show the back to top button',
    'Show the call to action block' => 'Show the call to action block',
    'Show the cookie policy bar at the bottom' => 'Show the cookie policy bar at the bottom',
    'Show the cookie policy page link' => 'Show the cookie policy page link',
    'Show the homepage hero seach box' => 'Show the homepage hero seach box',
    'Show the map along with the address on the venue page and event page' => 'Show the map along with the address on the venue page and event page',
    'Show the number and list of people that follow you' => 'Show the number and list of people that follow you',
    'Show the privacy policy page link' => 'Show the privacy policy page link',
    'Show the quote form on the venue page' => 'Show the quote form on the venue page',
    'Show the reviews that you received for your events' => 'Show the reviews that you received for your events',
    'Show the search box' => 'Show the search box',
    'Show the terms of service page link' => 'Show the terms of service page link',
    'Show ticket price filter' => 'Show ticket price filter',
    'Show tickets left count on cart modal' => 'Show tickets left count on cart modal',
    'Show venues map' => 'Show venues map',
    'Sign in' => 'Sign in',
    'Sign in via Facebook' => 'Sign in via Facebook',
    'Sign in via Google' => 'Sign in via Google',
    'Sign in via Twitter' => 'Sign in via Twitter',
    'Sign out' => 'Sign out',
    'Sign up' => 'Sign up',
    'Sign up via Facebook' => 'Sign up via Facebook',
    'Sign up via Google' => 'Sign up via Google',
    'Sign up via Twitter' => 'Sign up via Twitter',
    'Site key' => 'Site key',
    'Sitemap' => 'Sitemap',
    'Slug' => 'Slug',
    'Social Login' => 'Social Login',
    'Social Login settings' => 'Social Login settings',
    'Social media share image' => 'Social media share image',
    'Sold out' => 'Sold out',
    'Sort by' => 'Sort by',
    'Standing' => 'Standing',
    'Standing guests' => 'Standing guests',
    'Standing guests number' => 'Standing guests number',
    'Start date' => 'Start date',
    'Starts On' => 'Starts On',
    'State' => 'State',
    'State / City' => 'State / City',
    'Static Pages' => 'Static Pages',
    'Static pages settings' => 'Static pages settings',
    'Statistics' => 'Statistics',
    'Status' => 'Status',
    'Stick' => 'Stick',
    'Still in cart' => 'Still in cart',
    'Street' => 'Street',
    'Street 2' => 'Street 2',
    'Street address' => 'Street address',
    'Street address 2' => 'Street address 2',
    'Stripe Checkout' => 'Stripe Checkout',
    'Stripe payout' => 'Stripe payout',
    'Stripe publishable key' => 'Stripe publishable key',
    'Stripe secret key' => 'Stripe secret key',
    'Subject' => 'Subject',
    'Submit payment' => 'Submit payment',
    'Subscribe' => 'Subscribe',
    'Subscribe to our newsletter' => 'Subscribe to our newsletter',
    'Subtitles' => 'Subtitles',
    'Subtotal' => 'Subtotal',
    'Successfully executed the command' => 'Successfully executed the command',
    'Support for' => 'Support for',
    'Suspended' => 'Suspended',
    'Symbol' => 'Symbol',
    'TSL' => 'TSL',
    'Tags' => 'Tags',
    'Take your events to the next level' => 'Take your events to the next level',
    'Tell your attendees more about this ticket type' => 'Tell your attendees more about this ticket type',
    'Terms of service' => 'Terms of service',
    'Terms of service page slug' => 'Terms of service page slug',
    'Texte du lien' => 'Texte du lien',
    'Texto del enlace' => 'Texto del enlace',
    'The amenity can not be deleted because it is linked with one or more venues' => 'The amenity can not be deleted because it is linked with one or more venues',
    'The amenity can not be found' => 'The amenity can not be found',
    'The amenity has been deleted' => 'The amenity has been deleted',
    'The amenity has been disabled' => 'The amenity has been disabled',
    'The amenity has been succesfully restored' => 'The amenity has been succesfully restored',
    'The amenity has been successfully created' => 'The amenity has been successfully created',
    'The amenity has been successfully updated' => 'The amenity has been successfully updated',
    'The amenity is hidden' => 'The amenity is hidden',
    'The amenity is visible' => 'The amenity is visible',
    'The article can not be found' => 'The article can not be found',
    'The article has been deleted' => 'The article has been deleted',
    'The article has been disabled' => 'The article has been disabled',
    'The article has been succesfully restored' => 'The article has been succesfully restored',
    'The article has been successfully created' => 'The article has been successfully created',
    'The article has been successfully updated' => 'The article has been successfully updated',
    'The article is featured' => 'The article is featured',
    'The article is hidden' => 'The article is hidden',
    'The article is not featured anymore' => 'The article is not featured anymore',
    'The article is visible' => 'The article is visible',
    'The article not be found' => 'The article not be found',
    'The audience can not be deleted because it is linked with one or more events' => 'The audience can not be deleted because it is linked with one or more events',
    'The audience can not be found' => 'The audience can not be found',
    'The audience has been deleted' => 'The audience has been deleted',
    'The audience has been disabled' => 'The audience has been disabled',
    'The audience has been succesfully restored' => 'The audience has been succesfully restored',
    'The audience has been successfully created' => 'The audience has been successfully created',
    'The audience has been successfully updated' => 'The audience has been successfully updated',
    'The audience is hidden' => 'The audience is hidden',
    'The audience is visible' => 'The audience is visible',
    'The blog post can not be found' => 'The blog post can not be found',
    'The blog post category can not be deleted because it is linked with one or more blog posts' => 'The blog post category can not be deleted because it is linked with one or more blog posts',
    'The blog post category can not be found' => 'The blog post category can not be found',
    'The blog post category has been deleted' => 'The blog post category has been deleted',
    'The blog post category has been disabled' => 'The blog post category has been disabled',
    'The blog post category has been succesfully restored' => 'The blog post category has been succesfully restored',
    'The blog post category has been successfully created' => 'The blog post category has been successfully created',
    'The blog post category has been successfully updated' => 'The blog post category has been successfully updated',
    'The blog post category is hidden' => 'The blog post category is hidden',
    'The blog post category is visible' => 'The blog post category is visible',
    'The blog post has been deleted' => 'The blog post has been deleted',
    'The blog post has been disabled' => 'The blog post has been disabled',
    'The blog post has been succesfully restored' => 'The blog post has been succesfully restored',
    'The blog post has been successfully created' => 'The blog post has been successfully created',
    'The blog post has been successfully updated' => 'The blog post has been successfully updated',
    'The blog post is hidden' => 'The blog post is hidden',
    'The blog post is visible' => 'The blog post is visible',
    'The blog post not be found' => 'The blog post not be found',
    'The category can not be deleted because it is linked with one or more events' => 'The category can not be deleted because it is linked with one or more events',
    'The category can not be deleted because it is linked with one or more help center articles' => 'The category can not be deleted because it is linked with one or more help center articles',
    'The category can not be found' => 'The category can not be found',
    'The category has been deleted' => 'The category has been deleted',
    'The category has been disabled' => 'The category has been disabled',
    'The category has been succesfully restored' => 'The category has been succesfully restored',
    'The category has been successfully created' => 'The category has been successfully created',
    'The category has been successfully updated' => 'The category has been successfully updated',
    'The category is featured and is shown in the homepage categories' => 'The category is featured and is shown in the homepage categories',
    'The category is hidden' => 'The category is hidden',
    'The category is not featured anymore and is removed from the homepage categories' => 'The category is not featured anymore and is removed from the homepage categories',
    'The category is visible' => 'The category is visible',
    'The category not be found' => 'The category not be found',
    'The category was not found' => 'The category was not found',
    'The confirmation email has been resent to' => 'The confirmation email has been resent to',
    'The country can not be deleted because it is linked with one or more events' => 'The country can not be deleted because it is linked with one or more events',
    'The country can not be found' => 'The country can not be found',
    'The country has been deleted' => 'The country has been deleted',
    'The country has been disabled' => 'The country has been disabled',
    'The country has been succesfully restored' => 'The country has been succesfully restored',
    'The country has been successfully created' => 'The country has been successfully created',
    'The country has been successfully updated' => 'The country has been successfully updated',
    'The country is hidden' => 'The country is hidden',
    'The country is visible' => 'The country is visible',
    'The currency can not be found' => 'The currency can not be found',
    'The currency has been deleted' => 'The currency has been deleted',
    'The currency has been successfully created' => 'The currency has been successfully created',
    'The currency has been successfully updated' => 'The currency has been successfully updated',
    'The default locale must be selected in the available languages' => 'The default locale must be selected in the available languages',
    'The email address is not valid' => 'The email address is not valid',
    'The event can not be deleted because it has one or more orders' => 'The event can not be deleted because it has one or more orders',
    'The event can not be found' => 'The event can not be found',
    'The event date can not be found' => 'The event date can not be found',
    'The event date stats (sales and attendance) will be visible on the scanner app' => 'The event date stats (sales and attendance) will be visible on the scanner app',
    'The event has been added to your favorites' => 'The event has been added to your favorites',
    'The event has been deleted' => 'The event has been deleted',
    'The event has been deleted permanently' => 'The event has been deleted permanently',
    'The event has been published and will figure in the search results' => 'The event has been published and will figure in the search results',
    'The event has been removed from your favorites' => 'The event has been removed from your favorites',
    'The event has been succesfully restored' => 'The event has been succesfully restored',
    'The event has been successfully created' => 'The event has been successfully created',
    'The event has been successfully updated' => 'The event has been successfully updated',
    'The event has been unpublished and will not be included in the search results' => 'The event has been unpublished and will not be included in the search results',
    'The event not be found' => 'The event not be found',
    'The event ticket can not be found' => 'The event ticket can not be found',
    'The fields preceded with a red * are mandatory' => 'The fields preceded with a red * are mandatory',
    'The form contains invalid data' => 'The form contains invalid data',
    'The homepage settings can not be loaded' => 'The homepage settings can not be loaded',
    'The homepage settings could not be loaded' => 'The homepage settings could not be loaded',
    'The language can not be deleted because it is linked with one or more events' => 'The language can not be deleted because it is linked with one or more events',
    'The language can not be found' => 'The language can not be found',
    'The language has been deleted' => 'The language has been deleted',
    'The language has been disabled' => 'The language has been disabled',
    'The language has been succesfully restored' => 'The language has been succesfully restored',
    'The language has been successfully created' => 'The language has been successfully created',
    'The language has been successfully updated' => 'The language has been successfully updated',
    'The language is hidden' => 'The language is hidden',
    'The language is visible' => 'The language is visible',
    'The layout settings could not be loaded' => 'The layout settings could not be loaded',
    'The menu can not be found' => 'The menu can not be found',
    'The menu has been successfully updated' => 'The menu has been successfully updated',
    'The order can not be found' => 'The order can not be found',
    'The order has been deleted' => 'The order has been deleted',
    'The order has been permanently canceled' => 'The order has been permanently canceled',
    'The order has been permanently deleted' => 'The order has been permanently deleted',
    'The order has been soft deleted, restore it before canceling it' => 'The order has been soft deleted, restore it before canceling it',
    'The order has been succesfully restored' => 'The order has been succesfully restored',
    'The order status must be paid or awaiting payment' => 'The order status must be paid or awaiting payment',
    'The organizer can not be found' => 'The organizer can not be found',
    'The organizer not be found' => 'The organizer not be found',
    'The organizer revenue from this event date is currently zero' => 'The organizer revenue from this event date is currently zero',
    'The page can not be found' => 'The page can not be found',
    'The page has been deleted' => 'The page has been deleted',
    'The page has been successfully created' => 'The page has been successfully created',
    'The page has been successfully updated' => 'The page has been successfully updated',
    'The payment can not be found' => 'The payment can not be found',
    'The payment gateway can not be found' => 'The payment gateway can not be found',
    'The payment gateway has been successfully created' => 'The payment gateway has been successfully created',
    'The payment gateway has been successfully updated' => 'The payment gateway has been successfully updated',
    'The payout method can not be found' => 'The payout method can not be found',
    'The payout method has been successfully created' => 'The payout method has been successfully created',
    'The payout method has been successfully updated' => 'The payout method has been successfully updated',
    'The payout method is unset' => 'The payout method is unset',
    'The payout request can not be canceled because it is already processed' => 'The payout request can not be canceled because it is already processed',
    'The payout request can not be found' => 'The payout request can not be found',
    'The payout request can not be processed at this moment' => 'The payout request can not be processed at this moment',
    'The payout request has been already processed' => 'The payout request has been already processed',
    'The payout request has been deleted' => 'The payout request has been deleted',
    'The payout request has been permanently canceled' => 'The payout request has been permanently canceled',
    'The payout request has been permanently deleted' => 'The payout request has been permanently deleted',
    'The payout request has been soft deleted, restore it before canceling it' => 'The payout request has been soft deleted, restore it before canceling it',
    'The payout request has been soft deleted, restore it before viewing the details' => 'The payout request has been soft deleted, restore it before viewing the details',
    'The payout request has been succesfully restored' => 'The payout request has been succesfully restored',
    'The payout request has been successfully processed' => 'The payout request has been successfully processed',
    'The payout request has been successfully submitted, you will be notified by email once it is processed' => 'The payout request has been successfully submitted, you will be notified by email once it is processed',
    'The point of sale can not be found' => 'The point of sale can not be found',
    'The point of sale has been deleted' => 'The point of sale has been deleted',
    'The point of sale has been disabled' => 'The point of sale has been disabled',
    'The point of sale has been enabled' => 'The point of sale has been enabled',
    'The point of sale has been permenently deleted' => 'The point of sale has been permenently deleted',
    'The point of sale has been successfully created' => 'The point of sale has been successfully created',
    'The point of sale has been successfully updated' => 'The point of sale has been successfully updated',
    'The refund could not been processed at this moment' => 'The refund could not been processed at this moment',
    'The refund has already been reclined' => 'The refund has already been reclined',
    'The refund has been declined' => 'The refund has been declined',
    'The refund has been successfully processed' => 'The refund has been successfully processed',
    'The refund request has already been processed or no refund has been requested' => 'The refund request has already been processed or no refund has been requested',
    'The request method is known by the server but is not supported by the target resource' => 'The request method is known by the server but is not supported by the target resource',
    'The requested page couldn\'t be located. Checkout for any URL misspelling or' => 'The requested page couldn\'t be located. Checkout for any URL misspelling or',
    'The review can not be found' => 'The review can not be found',
    'The review has been deleted' => 'The review has been deleted',
    'The review has been deleted permanently' => 'The review has been deleted permanently',
    'The review has been enabled' => 'The review has been enabled',
    'The review has been hidden' => 'The review has been hidden',
    'The review has been succesfully restored' => 'The review has been succesfully restored',
    'The scanner account is disabled by the organizer' => 'The scanner account is disabled by the organizer',
    'The scanner can not be found' => 'The scanner can not be found',
    'The scanner has been disabled' => 'The scanner has been disabled',
    'The scanner has been enabled' => 'The scanner has been enabled',
    'The scanner has been permenently deleted' => 'The scanner has been permenently deleted',
    'The scanner has been successfully created' => 'The scanner has been successfully created',
    'The scanner has been successfully updated' => 'The scanner has been successfully updated',
    'The settings have been updated' => 'The settings have been updated',
    'The space' => 'The space',
    'The ticket can not be found' => 'The ticket can not be found',
    'The ticket has already been scanned' => 'The ticket has already been scanned',
    'The ticket has been successfully scanned' => 'The ticket has been successfully scanned',
    'The ticket is not valid for this event date' => 'The ticket is not valid for this event date',
    'The ticket was already scanned at' => 'The ticket was already scanned at',
    'The tickets has been successfully added to your cart' => 'The tickets has been successfully added to your cart',
    'The tickets have been released' => 'The tickets have been released',
    'The user can not be found' => 'The user can not be found',
    'The user cart has been emptied' => 'The user cart has been emptied',
    'The user has been deleted' => 'The user has been deleted',
    'The user has been disabled' => 'The user has been disabled',
    'The user has been enabled' => 'The user has been enabled',
    'The user has been permanently deleted' => 'The user has been permanently deleted',
    'The user has been succesfully restored' => 'The user has been succesfully restored',
    'The username already exists' => 'The username already exists',
    'The venue can not be deleted because it is linked with one or more events' => 'The venue can not be deleted because it is linked with one or more events',
    'The venue can not be found' => 'The venue can not be found',
    'The venue has been deleted' => 'The venue has been deleted',
    'The venue has been disabled' => 'The venue has been disabled',
    'The venue has been succesfully restored' => 'The venue has been succesfully restored',
    'The venue has been successfully created' => 'The venue has been successfully created',
    'The venue has been successfully updated' => 'The venue has been successfully updated',
    'The venue is hidden' => 'The venue is hidden',
    'The venue is hidden from the public venues directory' => 'The venue is hidden from the public venues directory',
    'The venue is listed on the public venues directory' => 'The venue is listed on the public venues directory',
    'The venue is visible' => 'The venue is visible',
    'The venue type can not be deleted because it is linked with one or more venues' => 'The venue type can not be deleted because it is linked with one or more venues',
    'The venue type can not be found' => 'The venue type can not be found',
    'The venue type has been deleted' => 'The venue type has been deleted',
    'The venue type has been disabled' => 'The venue type has been disabled',
    'The venue type has been succesfully restored' => 'The venue type has been succesfully restored',
    'The venue type has been successfully created' => 'The venue type has been successfully created',
    'The venue type has been successfully updated' => 'The venue type has been successfully updated',
    'The venue type is hidden' => 'The venue type is hidden',
    'The venue type is visible' => 'The venue type is visible',
    'This email address will be used to receive the quote requests, make sure to mention it if you want to show the quote form' => 'This email address will be used to receive the quote requests, make sure to mention it if you want to show the quote form',
    'This email is sent as a confirmation of your order' => 'This email is sent as a confirmation of your order',
    'This event date is locked because a payout request has been submitted' => 'This event date is locked because a payout request has been submitted',
    'This fee will be added to the ticket sale price (leave this field blank to disable additional ticket fees)' => 'This fee will be added to the ticket sale price (leave this field blank to disable additional ticket fees)',
    'This fee will be added to the ticket sale price which are bought from a point of sale, put 0 to disable additional fees for tickets which are bought from a point of sale, does not apply for free tickets, will be applied to future orders' => 'This fee will be added to the ticket sale price which are bought from a point of sale, put 0 to disable additional fees for tickets which are bought from a point of sale, does not apply for free tickets, will be applied to future orders',
    'This fee will be added to the ticket sale price which are bought online, put 0 to disable additional fees for ticket which are bought online, does not apply for free tickets, will be applied to future orders' => 'This fee will be added to the ticket sale price which are bought online, put 0 to disable additional fees for ticket which are bought online, does not apply for free tickets, will be applied to future orders',
    'This fee will be added to the ticket sale price which are bought online, put 0 to disable additional fees for tickets which are bought online, does not apply for free tickets, will be applied to future orders' => 'This fee will be added to the ticket sale price which are bought online, put 0 to disable additional fees for tickets which are bought online, does not apply for free tickets, will be applied to future orders',
    'This is a string that should be unique to your application and it is commonly used to add more entropy to security related operations' => 'This is a string that should be unique to your application and it is commonly used to add more entropy to security related operations',
    'This link can only be used once to validate your account' => 'This link can only be used once to validate your account',
    'This month' => 'This month',
    'This order has already been refunded' => 'This order has already been refunded',
    'This order is not eligible for refund because it contains tickets from different organizers' => 'This order is not eligible for refund because it contains tickets from different organizers',
    'This order is not eligible for refund because it is not paid' => 'This order is not eligible for refund because it is not paid',
    'This payout method is currently disabled' => 'This payout method is currently disabled',
    'This percentage will be deducted from each ticket sold on a point of sale, upon organizer payout request, this percentage will be taken from each ticket sold on a point of sale, will be applied to future orders' => 'This percentage will be deducted from each ticket sold on a point of sale, upon organizer payout request, this percentage will be taken from each ticket sold on a point of sale, will be applied to future orders',
    'This percentage will be deducted from each ticket sold online, upon organizer payout request, this percentage will be taken from each ticket sold online, will be applied to future orders' => 'This percentage will be deducted from each ticket sold online, upon organizer payout request, this percentage will be taken from each ticket sold online, will be applied to future orders',
    'This ticket was scanned at %scanDate%' => 'This ticket was scanned at %scanDate%',
    'This week' => 'This week',
    'This weekend' => 'This weekend',
    'Ticket' => 'Ticket',
    'Ticket description' => 'Ticket description',
    'Ticket fee' => 'Ticket fee',
    'Ticket fee (Online)' => 'Ticket fee (Online)',
    'Ticket fee (Point Of Sale)' => 'Ticket fee (Point Of Sale)',
    'Ticket fees' => 'Ticket fees',
    'Ticket name' => 'Ticket name',
    'Ticket price' => 'Ticket price',
    'Ticket price percentage cut (Online)' => 'Ticket price percentage cut (Online)',
    'Ticket price percentage cut (Point of sale)' => 'Ticket price percentage cut (Point of sale)',
    'Ticket style' => 'Ticket style',
    'Ticket type' => 'Ticket type',
    'Tickets' => 'Tickets',
    'Tickets left' => 'Tickets left',
    'Tickets per attendee' => 'Tickets per attendee',
    'Tickets sales' => 'Tickets sales',
    'Tickets sales by date' => 'Tickets sales by date',
    'Tickets sales this month' => 'Tickets sales this month',
    'Tickets sold' => 'Tickets sold',
    'Tickets sold Per Point of sale' => 'Tickets sold Per Point of sale',
    'Tickets sold by channel' => 'Tickets sold by channel',
    'Tickets types' => 'Tickets types',
    'Time\'s up' => 'Time\'s up',
    'Timeleft' => 'Timeleft',
    'Timezone' => 'Timezone',
    'Title' => 'Title',
    'Titre' => 'Titre',
    'To help attendee find your event quickly, enter some keywords that identify your event (press Enter after each entry)' => 'To help attendee find your event quickly, enter some keywords that identify your event (press Enter after each entry)',
    'To reset your password, click on the following button and follow the instructions' => 'To reset your password, click on the following button and follow the instructions',
    'To submit a new payout request for an event date, go to the My events page and click on the Request payout link next to the event' => 'To submit a new payout request for an event date, go to the My events page and click on the Request payout link next to the event',
    'Today' => 'Today',
    'Toggle display the event date details' => 'Toggle display the event date details',
    'Toggle display the search filters' => 'Toggle display the search filters',
    'Tomorrow' => 'Tomorrow',
    'Total' => 'Total',
    'Total attendees' => 'Total attendees',
    'Total attendees check-in' => 'Total attendees check-in',
    'Total gross sales' => 'Total gross sales',
    'Total orders' => 'Total orders',
    'Total sales' => 'Total sales',
    'Total tickets sales' => 'Total tickets sales',
    'Translation' => 'Translation',
    'Translations' => 'Translations',
    'Transport' => 'Transport',
    'Twitter' => 'Twitter',
    'Twitter url' => 'Twitter url',
    'Type' => 'Type',
    'Título' => 'Título',
    'Unfollow' => 'Unfollow',
    'Unknown' => 'Unknown',
    'Unstick' => 'Unstick',
    'Until date' => 'Until date',
    'Upcoming events' => 'Upcoming events',
    'Upcoming tickets' => 'Upcoming tickets',
    'Update cart' => 'Update cart',
    'Update date' => 'Update date',
    'Update the amenity' => 'Update the amenity',
    'Update the audience' => 'Update the audience',
    'Update the blog post' => 'Update the blog post',
    'Update the blog post category' => 'Update the blog post category',
    'Update the category' => 'Update the category',
    'Update the country' => 'Update the country',
    'Update the currency' => 'Update the currency',
    'Update the event' => 'Update the event',
    'Update the help center article' => 'Update the help center article',
    'Update the help center category' => 'Update the help center category',
    'Update the language' => 'Update the language',
    'Update the lapagenguage' => 'Update the page',
    'Update the payment gateway' => 'Update the payment gateway',
    'Update the point of sale' => 'Update the point of sale',
    'Update the scanner' => 'Update the scanner',
    'Update the venue' => 'Update the venue',
    'Update the venue type' => 'Update the venue type',
    'Update your %payoutMethodName% payout method' => 'Update your %payoutMethodName% payout method',
    'Used in some specific cases, follow this link for a list of supported characters: https://www.php.net/manual/en/datetime.format.php . Please make sure to keep the double quotes " " around the format string' => 'Used in some specific cases, follow this link for a list of supported characters: https://www.php.net/manual/en/datetime.format.php . Please make sure to keep the double quotes " " around the format string',
    'Useful Links' => 'Useful Links',
    'User information' => 'User information',
    'Username' => 'Username',
    'Users' => 'Users',
    'Users summary' => 'Users summary',
    'Uset' => 'Uset',
    'Venue' => 'Venue',
    'Venue / Location' => 'Venue / Location',
    'Venue image' => 'Venue image',
    'Venue name...' => 'Venue name...',
    'Venue page' => 'Venue page',
    'Venue page settings' => 'Venue page settings',
    'Venue type' => 'Venue type',
    'Venue types' => 'Venue types',
    'Venues' => 'Venues',
    'Venues Pages' => 'Venues Pages',
    'Venues count' => 'Venues count',
    'Venues page' => 'Venues page',
    'Video' => 'Video',
    'View cart' => 'View cart',
    'View detailed statistics' => 'View detailed statistics',
    'View details' => 'View details',
    'View event' => 'View event',
    'View organizer' => 'View organizer',
    'View stats' => 'View stats',
    'Views' => 'Views',
    'Visible' => 'Visible',
    'Visible only' => 'Visible only',
    'We recommend a 48x48 image' => 'We recommend a 48x48 image',
    'We recommend a 48x48 image size' => 'We recommend a 48x48 image size',
    'We will be back shortly.' => 'We will be back shortly.',
    'Website' => 'Website',
    'Website description' => 'Website description',
    'Website name' => 'Website name',
    'Website root url' => 'Website root url',
    'Website slug' => 'Website slug',
    'Website url' => 'Website url',
    'Welcome' => 'Welcome',
    'What to show in the homepage hero ?' => 'What to show in the homepage hero ?',
    'When' => 'When',
    'Where' => 'Where',
    'Will be show in the homepage, the explore menu item dropdown and in the footer' => 'Will be show in the homepage, the explore menu item dropdown and in the footer',
    'With sales only' => 'With sales only',
    'Without sales only' => 'Without sales only',
    'Year' => 'Year',
    'Yellow' => 'Yellow',
    'Yes' => 'Yes',
    'You are about to approve the payout request' => 'You are about to approve the payout request',
    'You are about to cancel this order (this action cannot be undone)' => 'You are about to cancel this order (this action cannot be undone)',
    'You are about to cancel this payout request (this action cannot be undone), the event date related to this payout request will be unlocked' => 'You are about to cancel this payout request (this action cannot be undone), the event date related to this payout request will be unlocked',
    'You are about to delete the amenity PERMANENTLY' => 'You are about to delete the amenity PERMANENTLY',
    'You are about to delete the article PERMANENTLY' => 'You are about to delete the article PERMANENTLY',
    'You are about to delete the audience PERMANENTLY' => 'You are about to delete the audience PERMANENTLY',
    'You are about to delete the blog post PERMANENTLY' => 'You are about to delete the blog post PERMANENTLY',
    'You are about to delete the blog post category PERMANENTLY' => 'You are about to delete the blog post category PERMANENTLY',
    'You are about to delete the category PERMANENTLY' => 'You are about to delete the category PERMANENTLY',
    'You are about to delete the country PERMANENTLY' => 'You are about to delete the country PERMANENTLY',
    'You are about to delete the currency PERMANENTLY' => 'You are about to delete the currency PERMANENTLY',
    'You are about to delete the event and all its related information PERMANENTLY' => 'You are about to delete the event and all its related information PERMANENTLY',
    'You are about to delete the language PERMANENTLY' => 'You are about to delete the language PERMANENTLY',
    'You are about to delete the order and all its related information (payment details, tickets...)' => 'You are about to delete the order and all its related information (payment details, tickets...)',
    'You are about to delete the page PERMANENTLY' => 'You are about to delete the page PERMANENTLY',
    'You are about to delete the payout request and all its related information' => 'You are about to delete the payout request and all its related information',
    'You are about to delete the point of sale' => 'You are about to delete the point of sale',
    'You are about to delete the point of sale PERMANENTLY' => 'You are about to delete the point of sale PERMANENTLY',
    'You are about to delete the review PERMANENTLY' => 'You are about to delete the review PERMANENTLY',
    'You are about to delete the scanner' => 'You are about to delete the scanner',
    'You are about to delete the scanner PERMANENTLY' => 'You are about to delete the scanner PERMANENTLY',
    'You are about to delete the user and all its related information (orders, events...) PERMANENTLY' => 'You are about to delete the user and all its related information (orders, events...) PERMANENTLY',
    'You are about to delete the venue PERMANENTLY' => 'You are about to delete the venue PERMANENTLY',
    'You are about to delete the venue type PERMANENTLY' => 'You are about to delete the venue type PERMANENTLY',
    'You are about to empty your cart' => 'You are about to empty your cart',
    'You are connected as "%username%' => 'You are connected as "%username%',
    'You are following this organizer' => 'You are following this organizer',
    'You are going to this event' => 'You are going to this event',
    'You are no longer following this organizer' => 'You are no longer following this organizer',
    'You are not following any organizer' => 'You are not following any organizer',
    'You can introduce the event details in multiple locales' => 'You can introduce the event details in multiple locales',
    'You did not find an answer to your inquiry? Let us know and we will be glad to give you further help' => 'You did not find an answer to your inquiry? Let us know and we will be glad to give you further help',
    'You don\'t have permission to access this resource' => 'You don\'t have permission to access this resource',
    'You have added %tickets% ticket(s) to your cart' => 'You have added %tickets% ticket(s) to your cart',
    'You have already bought %tickets% ticket(s)' => 'You have already bought %tickets% ticket(s)',
    'You have already requested a refund for this order' => 'You have already requested a refund for this order',
    'You have already requested a refund for this order and it was approved' => 'You have already requested a refund for this order and it was approved',
    'You have already requested a refund for this order and it was declined' => 'You have already requested a refund for this order and it was declined',
    'You have received a new quote request for the venue' => 'You have received a new quote request for the venue',
    'You have successfully subscribed to our newsletter' => 'You have successfully subscribed to our newsletter',
    'You must choose an event and set the status to paid in order to export attendees list to a PDF file' => 'You must choose an event and set the status to paid in order to export attendees list to a PDF file',
    'You must choose an event in order to export the attendees list' => 'You must choose an event in order to export the attendees list',
    'You must review your cart before proceeding to checkout' => 'You must review your cart before proceeding to checkout',
    'You must set the status to paid in order to export the attendees list' => 'You must set the status to paid in order to export the attendees list',
    'You must specify at least one language' => 'You must specify at least one language',
    'You order is empty' => 'You order is empty',
    'Your account settings have been updated' => 'Your account settings have been updated',
    'Your cart has been automatically updated because one or more event\'s quotas has changed' => 'Your cart has been automatically updated because one or more event\'s quotas has changed',
    'Your cart has been automatically updated because one or more events are no longer on sale' => 'Your cart has been automatically updated because one or more events are no longer on sale',
    'Your cart has been emptied' => 'Your cart has been emptied',
    'Your cart has been updated' => 'Your cart has been updated',
    'Your cart is empty' => 'Your cart is empty',
    'Your email' => 'Your email',
    'Your message has been successfully sent' => 'Your message has been successfully sent',
    'Your order has been automatically canceled because one or more event\'s quotas has changed' => 'Your order has been automatically canceled because one or more event\'s quotas has changed',
    'Your order has been automatically canceled because one or more events are no longer on sale' => 'Your order has been automatically canceled because one or more events are no longer on sale',
    'Your order has been automatically canceled because your ticket reservations has been released' => 'Your order has been automatically canceled because your ticket reservations has been released',
    'Your organizer profile has been successfully updated' => 'Your organizer profile has been successfully updated',
    'Your payment could not be processed at this time' => 'Your payment could not be processed at this time',
    'Your payment has been successfully processed' => 'Your payment has been successfully processed',
    'Your payment operation was canceled' => 'Your payment operation was canceled',
    'Your payout request has been processed' => 'Your payout request has been processed',
    'Your quote request has been successfully sent' => 'Your quote request has been successfully sent',
    'Your rating (out of 5 stars)' => 'Your rating (out of 5 stars)',
    'Your refund request has been successfully submitted to the organizer' => 'Your refund request has been successfully submitted to the organizer',
    'Your registration has been successfully processed' => 'Your registration has been successfully processed',
    'Your review has been successfully saved' => 'Your review has been successfully saved',
    'Your review headline' => 'Your review headline',
    'Your tickets are not reserved until checkout, the quantity you intend to buy might not be available if you do not proceed to checkout right away' => 'Your tickets are not reserved until checkout, the quantity you intend to buy might not be available if you do not proceed to checkout right away',
    'Your tickets bought from' => 'Your tickets bought from',
    'Youtube' => 'Youtube',
    'Youtube url' => 'Youtube url',
    'Youtube video' => 'Youtube video',
    'Youtube video url' => 'Youtube video url',
    'Zip / Postal code' => 'Zip / Postal code',
    'and' => 'and',
    'asc' => 'asc',
    'at' => 'at',
    'checked In' => 'checked In',
    'created at' => 'created at',
    'desc' => 'desc',
    'event to the next level ?' => 'event to the next level ?',
    'for' => 'for',
    'form.label.delete' => 'Delete',
    'form.password' => 'form.password',
    'form.password_confirmation' => 'form.password_confirmation',
    'image(s)' => 'image(s)',
    'left' => 'left',
    'left before tickets are released' => 'left before tickets are released',
    'min read' => 'min read',
    'my points of sale' => 'my points of sale',
    'my scanners' => 'my scanners',
    'my venues' => 'my venues',
    'orders summary' => 'orders summary',
    'out of 5 stars' => 'out of 5 stars',
    'placed on' => 'placed on',
    'return to the homepage' => 'return to the homepage',
    'review' => 'review',
    'right' => 'right',
    'ticket' => 'ticket',
    'ticket(s)' => 'ticket(s)',
    'ticket(s) sold' => 'ticket(s) sold',
    'tickets' => 'tickets',
    'tickets found in your cart' => 'tickets found in your cart',
    'tickets left' => 'tickets left',
    'tickets per attendee' => 'tickets per attendee',
    'title' => 'title',
    'to edit your profile' => 'to edit your profile',
    'to manage this event' => 'to manage this event',
    'to manage your event' => 'to manage your event',
    'to preview your profile' => 'to preview your profile',
    'to return to your dashboard' => 'to return to your dashboard',
    'user(s)' => 'user(s)',
    'view(s)' => 'view(s)',
    'views' => 'views',
    'your payout request has been processed' => 'your payout request has been processed',
    'your tickets are ready to go!' => 'your tickets are ready to go!',
    'اسم' => 'اسم',
    'اسم القائمة' => 'اسم القائمة',
    'التفاصيل' => 'التفاصيل',
    'العلامات' => 'العلامات',
    'الكلمات الرئيسية' => 'الكلمات الرئيسية',
    'عنوان' => 'عنوان',
    'فقرة' => 'فقرة',
    'محتوى' => 'محتوى',
    'نص الرابط' => 'نص الرابط',
    'نص العنوان' => 'نص العنوان',
    '关键字' => '关键字',
    '内容' => '内容',
    '名称' => '名称',
    '描述' => '描述',
    '标签' => '标签',
    '标题' => '标题',
    '段' => '段',
  ),
  'javascript' => 
  array (
    'Add' => 'Add',
    'Add a new event date' => 'Add a new event date',
    'Add a new ticket' => 'Add a new ticket',
    'An error has occured' => 'An error has occured',
    'April' => 'April',
    'August' => 'August',
    'Cancel' => 'Cancel',
    'Close' => 'Close',
    'Confirm' => 'Confirm',
    'Confirmation required' => 'Confirmation required',
    'December' => 'December',
    'Duplicate this event date' => 'Duplicate this event date',
    'Duplicate this ticket' => 'Duplicate this ticket',
    'Email address' => 'Email address',
    'February' => 'February',
    'Insert at least 3 characters' => 'Insert at least 3 characters',
    'January' => 'January',
    'July' => 'July',
    'June' => 'June',
    'Load more' => 'Load more',
    'Loading...' => 'Loading...',
    'Make sure to enter a valid email address' => 'Make sure to enter a valid email address',
    'March' => 'March',
    'May' => 'May',
    'Message' => 'Message',
    'Move down' => 'Move down',
    'Move up' => 'Move up',
    'No results found' => 'No results found',
    'Note' => 'Note',
    'November' => 'November',
    'October' => 'October',
    'Please select the tickets quantity for this order' => 'Please select the tickets quantity for this order',
    'Please select the tickets quantity you want to buy' => 'Please select the tickets quantity you want to buy',
    'Read more' => 'Read more',
    'Remove' => 'Remove',
    'Remove this event date' => 'Remove this event date',
    'Remove this ticket' => 'Remove this ticket',
    'Return to cart' => 'Return to cart',
    'Searching ...' => 'Searching ...',
    'Select an option' => 'Select an option',
    'September' => 'September',
    'Stick' => 'Stick',
    'The email address is not valid' => 'The email address is not valid',
    'The tickets have been released' => 'The tickets have been released',
    'This feature is disabled in demo mode' => 'This feature is disabled in demo mode',
    'Time\'s up' => 'Time\'s up',
    'Unstick' => 'Unstick',
    'days' => 'days',
    'hr' => 'hr',
    'javascript string translation' => 'javascript string translation',
    'min' => 'min',
    'sec' => 'sec',
    'weeks' => 'weeks',
  ),
));
$catalogue->addFallbackCatalogue($catalogueEn);

return $catalogue;
