<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* Dashboard/Shared/Venue/index.html.twig */
class __TwigTemplate_b3808c176d2723b3028d5e68a796959b655f8efaccab57535a606e5dbd5fd6ed extends \Twig\Template
{
    private $source;
    private $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->blocks = [
            'title' => [$this, 'block_title'],
            'content' => [$this, 'block_content'],
            'javascripts' => [$this, 'block_javascripts'],
        ];
    }

    protected function doGetParent(array $context)
    {
        // line 1
        return "Global/layout.html.twig";
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        $macros = $this->macros;
        $__internal_319393461309892924ff6e74d6d6e64287df64b63545b994e100d4ab223aed02 = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_319393461309892924ff6e74d6d6e64287df64b63545b994e100d4ab223aed02->enter($__internal_319393461309892924ff6e74d6d6e64287df64b63545b994e100d4ab223aed02_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "Dashboard/Shared/Venue/index.html.twig"));

        // line 3
        if ($this->extensions['Symfony\Bridge\Twig\Extension\SecurityExtension']->isGranted("ROLE_ADMINISTRATOR")) {
            // line 4
            $context["pagetitle"] = $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Manage venues");
        } else {
            // line 6
            $context["pagetitle"] = $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("My venues");
        }
        // line 1
        $this->parent = $this->loadTemplate("Global/layout.html.twig", "Dashboard/Shared/Venue/index.html.twig", 1);
        $this->parent->display($context, array_merge($this->blocks, $blocks));
        
        $__internal_319393461309892924ff6e74d6d6e64287df64b63545b994e100d4ab223aed02->leave($__internal_319393461309892924ff6e74d6d6e64287df64b63545b994e100d4ab223aed02_prof);

    }

    // line 9
    public function block_title($context, array $blocks = [])
    {
        $macros = $this->macros;
        $__internal_319393461309892924ff6e74d6d6e64287df64b63545b994e100d4ab223aed02 = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_319393461309892924ff6e74d6d6e64287df64b63545b994e100d4ab223aed02->enter($__internal_319393461309892924ff6e74d6d6e64287df64b63545b994e100d4ab223aed02_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        echo twig_escape_filter($this->env, (isset($context["pagetitle"]) || array_key_exists("pagetitle", $context) ? $context["pagetitle"] : (function () { throw new RuntimeError('Variable "pagetitle" does not exist.', 9, $this->source); })()), "html", null, true);
        
        $__internal_319393461309892924ff6e74d6d6e64287df64b63545b994e100d4ab223aed02->leave($__internal_319393461309892924ff6e74d6d6e64287df64b63545b994e100d4ab223aed02_prof);

    }

    // line 11
    public function block_content($context, array $blocks = [])
    {
        $macros = $this->macros;
        $__internal_319393461309892924ff6e74d6d6e64287df64b63545b994e100d4ab223aed02 = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_319393461309892924ff6e74d6d6e64287df64b63545b994e100d4ab223aed02->enter($__internal_319393461309892924ff6e74d6d6e64287df64b63545b994e100d4ab223aed02_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "content"));

        // line 12
        echo "
    ";
        // line 13
        $context["navigation"] = [0 => ["dashboard_index" => $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Dashboard"), "current" => (isset($context["pagetitle"]) || array_key_exists("pagetitle", $context) ? $context["pagetitle"] : (function () { throw new RuntimeError('Variable "pagetitle" does not exist.', 13, $this->source); })())]];
        // line 14
        echo "    ";
        $this->loadTemplate("Global/navigation.html.twig", "Dashboard/Shared/Venue/index.html.twig", 14)->display(twig_array_merge($context, (isset($context["navigation"]) || array_key_exists("navigation", $context) ? $context["navigation"] : (function () { throw new RuntimeError('Variable "navigation" does not exist.', 14, $this->source); })())));
        // line 15
        echo "
    <section class=\"section-content padding-y bg-white\">
        <div class=\"";
        // line 17
        echo twig_escape_filter($this->env, twig_get_attribute($this->env, $this->source, (isset($context["services"]) || array_key_exists("services", $context) ? $context["services"] : (function () { throw new RuntimeError('Variable "services" does not exist.', 17, $this->source); })()), "getSetting", [0 => "app_layout"], "method", false, false, false, 17), "html", null, true);
        echo "\">
            <div class=\"row\">
                <aside class=\"col-lg-3 pt-3 pt-lg-0\">
                    ";
        // line 20
        $this->loadTemplate("Dashboard/sidebar.html.twig", "Dashboard/Shared/Venue/index.html.twig", 20)->display($context);
        // line 21
        echo "                </aside>
                <div class=\"col-lg-9 mt-4 mt-lg-0\">

                    <div class=\"box shadow-none bg-gray mb-4\">
                        <div class=\"row\">
                            <div class=\"col-sm-12 col-lg-2 text-center text-lg-left mb-3 mb-lg-0\">
                                <span class=\"center-lg-y text-muted\">";
        // line 27
        echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("%resultsCount% result(s) found", ["%resultsCount%" => twig_get_attribute($this->env, $this->source, (isset($context["venues"]) || array_key_exists("venues", $context) ? $context["venues"] : (function () { throw new RuntimeError('Variable "venues" does not exist.', 27, $this->source); })()), "getTotalItemCount", [], "any", false, false, false, 27)]), "html", null, true);
        echo "</span>
                            </div>
                            <div class=\"col-sm-12 col-lg-4 text-center mb-3 mb-lg-0\">
                                <form>
                                    <ul class=\"list-inline\">
                                        <li class=\"list-inline-item dropdown\"><a href=\"#\" class=\"dropdown-toggle\" data-toggle=\"dropdown\">";
        // line 32
        echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Search"), "html", null, true);
        echo "</a>
                                            <div class=\"dropdown-menu dropdown-menu-arrow p-3\" style=\"min-width:300px;max-width:500px;\">
                                                <label for=\"keyword\">";
        // line 34
        echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Keyword"), "html", null, true);
        echo "</label>
                                                <input id=\"keyword\" name=\"keyword\" type=\"text\" class=\"form-control\" value=\"";
        // line 35
        echo twig_escape_filter($this->env, twig_get_attribute($this->env, $this->source, twig_get_attribute($this->env, $this->source, (isset($context["app"]) || array_key_exists("app", $context) ? $context["app"] : (function () { throw new RuntimeError('Variable "app" does not exist.', 35, $this->source); })()), "request", [], "any", false, false, false, 35), "get", [0 => "keyword"], "method", false, false, false, 35), "html", null, true);
        echo "\">
                                            </div>
                                        </li>
                                        ";
        // line 38
        if ($this->extensions['Symfony\Bridge\Twig\Extension\SecurityExtension']->isGranted("ROLE_ADMINISTRATOR")) {
            // line 39
            echo "                                            <li class=\"list-inline-item dropdown\"><a href=\"#\" class=\"dropdown-toggle\" data-toggle=\"dropdown\">";
            echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Listed on directory"), "html", null, true);
            echo "</a>
                                                <div class=\"dropdown-menu dropdown-menu-arrow p-3\" style=\"min-width:450px;max-width:550px;\">
                                                    <div class=\"custom-control custom-checkbox custom-control-inline\">
                                                        <input type=\"radio\" class=\"custom-control-input\" id=\"directory-all\" name=\"directory\" value=\"all\">
                                                        <label class=\"custom-control-label\" for=\"directory-all\">";
            // line 43
            echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("All"), "html", null, true);
            echo "</label>
                                                    </div>
                                                    <div class=\"custom-control custom-checkbox custom-control-inline\">
                                                        <input type=\"radio\" class=\"custom-control-input\" id=\"directory-yes\" name=\"directory\" value=\"1\">
                                                        <label class=\"custom-control-label\" for=\"directory-yes\">";
            // line 47
            echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Yes"), "html", null, true);
            echo "</label>
                                                    </div>
                                                    <div class=\"custom-control custom-checkbox custom-control-inline\">
                                                        <input type=\"radio\" class=\"custom-control-input\" id=\"directory-no\" name=\"directory\" value=\"0\">
                                                        <label class=\"custom-control-label\" for=\"directory-no\">";
            // line 51
            echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("No"), "html", null, true);
            echo "</label>
                                                    </div>
                                                </div>
                                            </li>
                                        ";
        }
        // line 56
        echo "                                        <li class=\"list-inline-item ml-3\"><button type=\"submit\" class=\"btn btn-primary\"><i class=\"fas fa-search\"></i></button></li>
                                    </ul>
                                </form>
                            </div>
                            <div class=\"col-sm-12 col-lg-6 text-center text-lg-right\">
                                <label for=\"sortable-select\" class=\"display-inline\">";
        // line 61
        echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Sort by"), "html", null, true);
        echo "
                                    <select id=\"sortable-select\" class=\"form-control display-inline-block bg-white select2 ml-3\" data-placeholder=\"";
        // line 62
        echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Select an option"), "html", null, true);
        echo "\" style=\"width: 50%;\">
                                        ";
        // line 63
        echo $this->extensions['Knp\Bundle\PaginatorBundle\Twig\Extension\PaginationExtension']->sortable($this->env, (isset($context["venues"]) || array_key_exists("venues", $context) ? $context["venues"] : (function () { throw new RuntimeError('Variable "venues" does not exist.', 63, $this->source); })()), ((($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Creation date") . " (") . $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("desc")) . ")"), "v.createdAt", ["direction" => "desc", "criteria" => "v.createdAt"]);
        echo "
                                        ";
        // line 64
        echo $this->extensions['Knp\Bundle\PaginatorBundle\Twig\Extension\PaginationExtension']->sortable($this->env, (isset($context["venues"]) || array_key_exists("venues", $context) ? $context["venues"] : (function () { throw new RuntimeError('Variable "venues" does not exist.', 64, $this->source); })()), ((($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Creation date") . " (") . $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("asc")) . ")"), "v.createdAt", ["direction" => "asc", "criteria" => "v.createdAt"]);
        echo "
                                    </select>
                                </label>
                                ";
        // line 67
        if ($this->extensions['Symfony\Bridge\Twig\Extension\SecurityExtension']->isGranted("ROLE_ADMINISTRATOR")) {
            // line 68
            echo "                                    <a href=\"";
            echo $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("dashboard_administrator_venue_add");
            echo "\" class=\"btn btn-primary ml-3\" data-toggle=\"tooltip\" title=\"";
            echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Add a new venue"), "html", null, true);
            echo "\"><i class=\"fas fa-plus\"></i></a>
                                    ";
        } elseif ($this->extensions['Symfony\Bridge\Twig\Extension\SecurityExtension']->isGranted("ROLE_ORGANIZER")) {
            // line 70
            echo "                                    <a href=\"";
            echo $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("dashboard_organizer_venue_add");
            echo "\" class=\"btn btn-primary ml-3\" data-toggle=\"tooltip\" title=\"";
            echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Add a new venue"), "html", null, true);
            echo "\"><i class=\"fas fa-plus\"></i></a>
                                    ";
        }
        // line 72
        echo "                            </div>
                        </div>
                    </div>

                    ";
        // line 76
        if ((twig_get_attribute($this->env, $this->source, (isset($context["venues"]) || array_key_exists("venues", $context) ? $context["venues"] : (function () { throw new RuntimeError('Variable "venues" does not exist.', 76, $this->source); })()), "getTotalItemCount", [], "any", false, false, false, 76) > 0)) {
            // line 77
            echo "
                        <div class=\"row\">

                            <div class=\"col-12\">
                                <div class=\"card\">
                                    <div class=\"table-responsive\">
                                        <table class=\"table table-hover table-vcenter text-nowrap\">
                                            <thead>
                                                <tr>
                                                    <th>";
            // line 86
            echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Name"), "html", null, true);
            echo "</th>
                                                    <th>";
            // line 87
            echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Image"), "html", null, true);
            echo "</th>
                                                        ";
            // line 88
            if ($this->extensions['Symfony\Bridge\Twig\Extension\SecurityExtension']->isGranted("ROLE_ADMINISTRATOR")) {
                // line 89
                echo "                                                        <th>";
                echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Organizer"), "html", null, true);
                echo "</th>
                                                        ";
            }
            // line 91
            echo "                                                    <th>";
            echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Events count"), "html", null, true);
            echo "</th>
                                                    <th>";
            // line 92
            echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Status"), "html", null, true);
            echo "</th>
                                                    <th class=\"text-center\"><i class=\"fas fa-cog\"></i></th>
                                                </tr>
                                            </thead>
                                            <tbody>

                                                ";
            // line 98
            $context['_parent'] = $context;
            $context['_seq'] = twig_ensure_traversable((isset($context["venues"]) || array_key_exists("venues", $context) ? $context["venues"] : (function () { throw new RuntimeError('Variable "venues" does not exist.', 98, $this->source); })()));
            foreach ($context['_seq'] as $context["_key"] => $context["venue"]) {
                // line 99
                echo "
                                                    <tr>
                                                        <td>
                                                            <a href=\"";
                // line 102
                echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("venue", ["slug" => twig_get_attribute($this->env, $this->source, $context["venue"], "slug", [], "any", false, false, false, 102)]), "html", null, true);
                echo "\">";
                echo twig_escape_filter($this->env, twig_get_attribute($this->env, $this->source, $context["venue"], "name", [], "any", false, false, false, 102), "html", null, true);
                echo "</a>
                                                        </td>
                                                        <td>
                                                            <a class=\"fancybox\" href=\"";
                // line 105
                echo twig_escape_filter($this->env, (((twig_length_filter($this->env, twig_get_attribute($this->env, $this->source, $context["venue"], "images", [], "any", false, false, false, 105)) > 0)) ? ($this->extensions['Symfony\Bridge\Twig\Extension\AssetExtension']->getAssetUrl(twig_get_attribute($this->env, $this->source, $context["venue"], "getFirstImageOrPlaceholder", [], "any", false, false, false, 105))) : (twig_get_attribute($this->env, $this->source, $context["venue"], "getFirstImageOrPlaceholder", [], "any", false, false, false, 105))), "html", null, true);
                echo "\" data-toggle=\"tooltip\" title=\"";
                echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Enlarge"), "html", null, true);
                echo "\">
                                                                <img src=\"";
                // line 106
                echo twig_escape_filter($this->env, (((twig_length_filter($this->env, twig_get_attribute($this->env, $this->source, $context["venue"], "images", [], "any", false, false, false, 106)) > 0)) ? ($this->extensions['Symfony\Bridge\Twig\Extension\AssetExtension']->getAssetUrl(twig_get_attribute($this->env, $this->source, $context["venue"], "getFirstImageOrPlaceholder", [], "any", false, false, false, 106))) : (twig_get_attribute($this->env, $this->source, $context["venue"], "getFirstImageOrPlaceholder", [], "any", false, false, false, 106))), "html", null, true);
                echo "\" class=\"img-thumbnail img-50-50\" />
                                                            </a>
                                                        </td>
                                                        ";
                // line 109
                if ($this->extensions['Symfony\Bridge\Twig\Extension\SecurityExtension']->isGranted("ROLE_ADMINISTRATOR")) {
                    // line 110
                    echo "                                                            <td>
                                                                ";
                    // line 111
                    ((twig_get_attribute($this->env, $this->source, $context["venue"], "organizer", [], "any", false, false, false, 111)) ? (print (twig_escape_filter($this->env, twig_get_attribute($this->env, $this->source, twig_get_attribute($this->env, $this->source, $context["venue"], "organizer", [], "any", false, false, false, 111), "name", [], "any", false, false, false, 111), "html", null, true))) : (print ("Added by administrator")));
                    echo "
                                                            </td>
                                                        ";
                }
                // line 114
                echo "                                                        <td>
                                                            ";
                // line 115
                echo twig_escape_filter($this->env, twig_length_filter($this->env, twig_get_attribute($this->env, $this->source, $context["venue"], "eventdates", [], "any", false, false, false, 115)), "html", null, true);
                echo "
                                                        </td>
                                                        <td>
                                                            ";
                // line 118
                if (twig_get_attribute($this->env, $this->source, $context["venue"], "hidden", [], "any", false, false, false, 118)) {
                    // line 119
                    echo "                                                                <span class=\"badge badge-danger\"><i class=\"fas fa-eye-slash fa-fw\"></i> ";
                    echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Hidden"), "html", null, true);
                    echo "</span>
                                                            ";
                } else {
                    // line 121
                    echo "                                                                <span class=\"badge badge-success\"><i class=\"fas fa-eye fa-fw\"></i> ";
                    echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Visible"), "html", null, true);
                    echo "</span>
                                                            ";
                }
                // line 123
                echo "                                                            <br>
                                                            <br>
                                                            ";
                // line 125
                if (twig_get_attribute($this->env, $this->source, $context["venue"], "listedondirectory", [], "any", false, false, false, 125)) {
                    // line 126
                    echo "                                                                <span class=\"badge badge-success\"><i class=\"fas fa-eye fa-fw\"></i> ";
                    echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Listed on the directory"), "html", null, true);
                    echo "</span>
                                                            ";
                } else {
                    // line 128
                    echo "                                                                <span class=\"badge badge-danger\"><i class=\"fas fa-eye-slash fa-fw\"></i> ";
                    echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Not listed on the directory"), "html", null, true);
                    echo "</span>
                                                            ";
                }
                // line 130
                echo "                                                            ";
                if (twig_get_attribute($this->env, $this->source, $context["venue"], "deletedAt", [], "any", false, false, false, 130)) {
                    // line 131
                    echo "                                                                <br>
                                                                <br>
                                                                <span class=\"badge badge-danger\"><i class=\"fas fa-times fa-fw\"></i> ";
                    // line 133
                    echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Deleted"), "html", null, true);
                    echo "</span>
                                                            ";
                }
                // line 135
                echo "                                                        </td>
                                                        <td class=\"text-center\">
                                                            <div class=\"item-action dropdown\">
                                                                <a href=\"javascript:void(0)\" data-toggle=\"dropdown\" data-boundary=\"window\" class=\"icon\"><i class=\"fas fa-ellipsis-v\"></i></a>
                                                                <div class=\"dropdown-menu dropdown-menu-right\">
                                                                    ";
                // line 140
                if ($this->extensions['Symfony\Bridge\Twig\Extension\SecurityExtension']->isGranted("ROLE_ADMINISTRATOR")) {
                    // line 141
                    echo "                                                                        <a href=\"";
                    echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("dashboard_administrator_venue_edit", ["slug" => twig_get_attribute($this->env, $this->source, $context["venue"], "slug", [], "any", false, false, false, 141)]), "html", null, true);
                    echo "\" class=\"dropdown-item\"><i class=\"dropdown-icon fas fa-edit fa-fw text-muted\"></i> ";
                    echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Edit"), "html", null, true);
                    echo "</a>
                                                                        ";
                    // line 142
                    if (twig_get_attribute($this->env, $this->source, $context["venue"], "hidden", [], "any", false, false, false, 142)) {
                        // line 143
                        echo "                                                                            <a href=\"";
                        echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("dashboard_administrator_venue_show", ["slug" => twig_get_attribute($this->env, $this->source, $context["venue"], "slug", [], "any", false, false, false, 143)]), "html", null, true);
                        echo "\" class=\"dropdown-item\"><i class=\"dropdown-icon fas fa-eye fa-fw text-muted\"></i> ";
                        echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Show"), "html", null, true);
                        echo "</a>
                                                                        ";
                    } else {
                        // line 145
                        echo "                                                                            <a href=\"";
                        echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("dashboard_administrator_venue_hide", ["slug" => twig_get_attribute($this->env, $this->source, $context["venue"], "slug", [], "any", false, false, false, 145)]), "html", null, true);
                        echo "\" class=\"dropdown-item\"><i class=\"dropdown-icon fas fa-eye-slash fa-fw text-muted\"></i> ";
                        echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Hide"), "html", null, true);
                        echo " </a>
                                                                        ";
                    }
                    // line 147
                    echo "                                                                        ";
                    if (twig_get_attribute($this->env, $this->source, $context["venue"], "listedondirectory", [], "any", false, false, false, 147)) {
                        // line 148
                        echo "                                                                            <a href=\"";
                        echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("dashboard_administrator_venue_hidefromdirectory", ["slug" => twig_get_attribute($this->env, $this->source, $context["venue"], "slug", [], "any", false, false, false, 148)]), "html", null, true);
                        echo "\" class=\"dropdown-item\"><i class=\"dropdown-icon fas fa-minus-square fa-fw text-muted\"></i> ";
                        echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Hide from public directory"), "html", null, true);
                        echo " </a>
                                                                        ";
                    } else {
                        // line 150
                        echo "                                                                            <a href=\"";
                        echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("dashboard_administrator_venue_listondirectory", ["slug" => twig_get_attribute($this->env, $this->source, $context["venue"], "slug", [], "any", false, false, false, 150)]), "html", null, true);
                        echo "\" class=\"dropdown-item\"><i class=\"dropdown-icon fas fa-plus-square fa-fw text-muted\"></i> ";
                        echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("List on public directory"), "html", null, true);
                        echo "</a>
                                                                        ";
                    }
                    // line 152
                    echo "                                                                        ";
                    if (twig_get_attribute($this->env, $this->source, $context["venue"], "deletedAt", [], "any", false, false, false, 152)) {
                        // line 153
                        echo "                                                                            <a href=\"";
                        echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("dashboard_administrator_venue_restore", ["slug" => twig_get_attribute($this->env, $this->source, $context["venue"], "slug", [], "any", false, false, false, 153)]), "html", null, true);
                        echo "\" class=\"dropdown-item\"><i class=\"dropdown-icon fas fa-trash-restore fa-fw text-muted\"></i> ";
                        echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Restore"), "html", null, true);
                        echo "</a>
                                                                            <span data-target=\"";
                        // line 154
                        echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("dashboard_administrator_venue_delete", ["slug" => twig_get_attribute($this->env, $this->source, $context["venue"], "slug", [], "any", false, false, false, 154)]), "html", null, true);
                        echo "\" class=\"dropdown-item requires-confirmation\" data-confirmation-text=\"";
                        echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("You are about to delete the venue PERMANENTLY"), "html", null, true);
                        echo "\"><i class=\"dropdown-icon fas fa-trash fa-fw text-muted\"></i> ";
                        echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Delete permanently"), "html", null, true);
                        echo "</span>
                                                                        ";
                    } else {
                        // line 156
                        echo "                                                                            <a href=\"";
                        echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("dashboard_administrator_venue_disable", ["slug" => twig_get_attribute($this->env, $this->source, $context["venue"], "slug", [], "any", false, false, false, 156)]), "html", null, true);
                        echo "\" class=\"dropdown-item\"><i class=\"dropdown-icon fas fa-times fa-fw text-muted\"></i> ";
                        echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Delete"), "html", null, true);
                        echo " </a>
                                                                        ";
                    }
                    // line 158
                    echo "                                                                    ";
                } elseif ($this->extensions['Symfony\Bridge\Twig\Extension\SecurityExtension']->isGranted("ROLE_ORGANIZER")) {
                    // line 159
                    echo "                                                                        <a href=\"";
                    echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("dashboard_organizer_venue_edit", ["slug" => twig_get_attribute($this->env, $this->source, $context["venue"], "slug", [], "any", false, false, false, 159)]), "html", null, true);
                    echo "\" class=\"dropdown-item\"><i class=\"dropdown-icon fas fa-edit fa-fw text-muted\"></i> ";
                    echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Edit"), "html", null, true);
                    echo "</a>
                                                                        ";
                    // line 160
                    if (twig_get_attribute($this->env, $this->source, $context["venue"], "hidden", [], "any", false, false, false, 160)) {
                        // line 161
                        echo "                                                                            <a href=\"";
                        echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("dashboard_organizer_venue_show", ["slug" => twig_get_attribute($this->env, $this->source, $context["venue"], "slug", [], "any", false, false, false, 161)]), "html", null, true);
                        echo "\" class=\"dropdown-item\"><i class=\"dropdown-icon fas fa-eye fa-fw text-muted\"></i> ";
                        echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Show"), "html", null, true);
                        echo "</a>
                                                                        ";
                    } else {
                        // line 163
                        echo "                                                                            <a href=\"";
                        echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("dashboard_organizer_venue_hide", ["slug" => twig_get_attribute($this->env, $this->source, $context["venue"], "slug", [], "any", false, false, false, 163)]), "html", null, true);
                        echo "\" class=\"dropdown-item\"><i class=\"dropdown-icon fas fa-eye-slash fa-fw text-muted\"></i> ";
                        echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Hide"), "html", null, true);
                        echo " </a>
                                                                        ";
                    }
                    // line 165
                    echo "                                                                        ";
                    if (twig_get_attribute($this->env, $this->source, $context["venue"], "deletedAt", [], "any", false, false, false, 165)) {
                        // line 166
                        echo "                                                                            <span data-target=\"";
                        echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("dashboard_organizer_venue_delete", ["slug" => twig_get_attribute($this->env, $this->source, $context["venue"], "slug", [], "any", false, false, false, 166)]), "html", null, true);
                        echo "\" class=\"dropdown-item requires-confirmation\" data-confirmation-text=\"";
                        echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("You are about to delete the venue PERMANENTLY"), "html", null, true);
                        echo "\"><i class=\"dropdown-icon fas fa-trash fa-fw text-muted\"></i> ";
                        echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Delete permanently"), "html", null, true);
                        echo "</span>
                                                                        ";
                    } else {
                        // line 168
                        echo "                                                                            <a href=\"";
                        echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("dashboard_organizer_venue_disable", ["slug" => twig_get_attribute($this->env, $this->source, $context["venue"], "slug", [], "any", false, false, false, 168)]), "html", null, true);
                        echo "\" class=\"dropdown-item\"><i class=\"dropdown-icon fas fa-times fa-fw text-muted\"></i> ";
                        echo twig_escape_filter($this->env, $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("Delete"), "html", null, true);
                        echo " </a>
                                                                        ";
                    }
                    // line 170
                    echo "                                                                    ";
                }
                // line 171
                echo "                                                                </div>
                                                            </div>
                                                        </td>
                                                    </tr>

                                                ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_iterated'], $context['_key'], $context['venue'], $context['_parent'], $context['loop']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 177
            echo "                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                ";
            // line 181
            echo $this->extensions['Knp\Bundle\PaginatorBundle\Twig\Extension\PaginationExtension']->render($this->env, (isset($context["venues"]) || array_key_exists("venues", $context) ? $context["venues"] : (function () { throw new RuntimeError('Variable "venues" does not exist.', 181, $this->source); })()), null, [], ["align" => "center"]);
            echo "
                            </div>

                        </div>

                    ";
        } else {
            // line 187
            echo "
                        ";
            // line 188
            $this->loadTemplate("Global/message.html.twig", "Dashboard/Shared/Venue/index.html.twig", 188)->display(twig_array_merge($context, ["type" => "info", "message" => $this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("No venues found"), "icon" => "fas fa-exclamation-circle"]));
            // line 189
            echo "
                    ";
        }
        // line 191
        echo "                </div>
            </div>

        </div>
    </section>

";
        
        $__internal_319393461309892924ff6e74d6d6e64287df64b63545b994e100d4ab223aed02->leave($__internal_319393461309892924ff6e74d6d6e64287df64b63545b994e100d4ab223aed02_prof);

    }

    // line 199
    public function block_javascripts($context, array $blocks = [])
    {
        $macros = $this->macros;
        $__internal_319393461309892924ff6e74d6d6e64287df64b63545b994e100d4ab223aed02 = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_319393461309892924ff6e74d6d6e64287df64b63545b994e100d4ab223aed02->enter($__internal_319393461309892924ff6e74d6d6e64287df64b63545b994e100d4ab223aed02_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "javascripts"));

        // line 200
        echo "
    <script>

        \$(document).ready(function () {
            if (getURLParameter('directory') != \"null\") {
                \$('input[type=\"radio\"][name=\"directory\"][value=\"' + getURLParameter('directory') + '\"]').attr(\"checked\", \"checked\");
            }
        });

    </script>

";
        
        $__internal_319393461309892924ff6e74d6d6e64287df64b63545b994e100d4ab223aed02->leave($__internal_319393461309892924ff6e74d6d6e64287df64b63545b994e100d4ab223aed02_prof);

    }

    public function getTemplateName()
    {
        return "Dashboard/Shared/Venue/index.html.twig";
    }

    public function isTraitable()
    {
        return false;
    }

    public function getDebugInfo()
    {
        return array (  538 => 200,  531 => 199,  518 => 191,  514 => 189,  512 => 188,  509 => 187,  500 => 181,  494 => 177,  483 => 171,  480 => 170,  472 => 168,  462 => 166,  459 => 165,  451 => 163,  443 => 161,  441 => 160,  434 => 159,  431 => 158,  423 => 156,  414 => 154,  407 => 153,  404 => 152,  396 => 150,  388 => 148,  385 => 147,  377 => 145,  369 => 143,  367 => 142,  360 => 141,  358 => 140,  351 => 135,  346 => 133,  342 => 131,  339 => 130,  333 => 128,  327 => 126,  325 => 125,  321 => 123,  315 => 121,  309 => 119,  307 => 118,  301 => 115,  298 => 114,  292 => 111,  289 => 110,  287 => 109,  281 => 106,  275 => 105,  267 => 102,  262 => 99,  258 => 98,  249 => 92,  244 => 91,  238 => 89,  236 => 88,  232 => 87,  228 => 86,  217 => 77,  215 => 76,  209 => 72,  201 => 70,  193 => 68,  191 => 67,  185 => 64,  181 => 63,  177 => 62,  173 => 61,  166 => 56,  158 => 51,  151 => 47,  144 => 43,  136 => 39,  134 => 38,  128 => 35,  124 => 34,  119 => 32,  111 => 27,  103 => 21,  101 => 20,  95 => 17,  91 => 15,  88 => 14,  86 => 13,  83 => 12,  76 => 11,  63 => 9,  55 => 1,  52 => 6,  49 => 4,  47 => 3,  37 => 1,);
    }

    public function getSourceContext()
    {
        return new Source("{% extends \"Global/layout.html.twig\" %}

{% if is_granted('ROLE_ADMINISTRATOR') %}
    {% set pagetitle = 'Manage venues' | trans %}
{% else %}
    {% set pagetitle = 'My venues' | trans %}
{% endif %}

{% block title %}{{pagetitle}}{% endblock %}

{% block content %}

    {% set navigation = [{ \"dashboard_index\": ('Dashboard' | trans), \"current\":(pagetitle) }] %}
    {% include \"Global/navigation.html.twig\" with navigation %}

    <section class=\"section-content padding-y bg-white\">
        <div class=\"{{ services.getSetting(\"app_layout\") }}\">
            <div class=\"row\">
                <aside class=\"col-lg-3 pt-3 pt-lg-0\">
                    {% include \"Dashboard/sidebar.html.twig\" %}
                </aside>
                <div class=\"col-lg-9 mt-4 mt-lg-0\">

                    <div class=\"box shadow-none bg-gray mb-4\">
                        <div class=\"row\">
                            <div class=\"col-sm-12 col-lg-2 text-center text-lg-left mb-3 mb-lg-0\">
                                <span class=\"center-lg-y text-muted\">{{ \"%resultsCount% result(s) found\"|trans({'%resultsCount%': venues.getTotalItemCount}) }}</span>
                            </div>
                            <div class=\"col-sm-12 col-lg-4 text-center mb-3 mb-lg-0\">
                                <form>
                                    <ul class=\"list-inline\">
                                        <li class=\"list-inline-item dropdown\"><a href=\"#\" class=\"dropdown-toggle\" data-toggle=\"dropdown\">{{ \"Search\"|trans }}</a>
                                            <div class=\"dropdown-menu dropdown-menu-arrow p-3\" style=\"min-width:300px;max-width:500px;\">
                                                <label for=\"keyword\">{{ \"Keyword\"|trans }}</label>
                                                <input id=\"keyword\" name=\"keyword\" type=\"text\" class=\"form-control\" value=\"{{ app.request.get('keyword') }}\">
                                            </div>
                                        </li>
                                        {% if is_granted('ROLE_ADMINISTRATOR') %}
                                            <li class=\"list-inline-item dropdown\"><a href=\"#\" class=\"dropdown-toggle\" data-toggle=\"dropdown\">{{ \"Listed on directory\"|trans }}</a>
                                                <div class=\"dropdown-menu dropdown-menu-arrow p-3\" style=\"min-width:450px;max-width:550px;\">
                                                    <div class=\"custom-control custom-checkbox custom-control-inline\">
                                                        <input type=\"radio\" class=\"custom-control-input\" id=\"directory-all\" name=\"directory\" value=\"all\">
                                                        <label class=\"custom-control-label\" for=\"directory-all\">{{ 'All'|trans }}</label>
                                                    </div>
                                                    <div class=\"custom-control custom-checkbox custom-control-inline\">
                                                        <input type=\"radio\" class=\"custom-control-input\" id=\"directory-yes\" name=\"directory\" value=\"1\">
                                                        <label class=\"custom-control-label\" for=\"directory-yes\">{{ 'Yes'|trans }}</label>
                                                    </div>
                                                    <div class=\"custom-control custom-checkbox custom-control-inline\">
                                                        <input type=\"radio\" class=\"custom-control-input\" id=\"directory-no\" name=\"directory\" value=\"0\">
                                                        <label class=\"custom-control-label\" for=\"directory-no\">{{ 'No'|trans }}</label>
                                                    </div>
                                                </div>
                                            </li>
                                        {% endif %}
                                        <li class=\"list-inline-item ml-3\"><button type=\"submit\" class=\"btn btn-primary\"><i class=\"fas fa-search\"></i></button></li>
                                    </ul>
                                </form>
                            </div>
                            <div class=\"col-sm-12 col-lg-6 text-center text-lg-right\">
                                <label for=\"sortable-select\" class=\"display-inline\">{{ \"Sort by\"|trans }}
                                    <select id=\"sortable-select\" class=\"form-control display-inline-block bg-white select2 ml-3\" data-placeholder=\"{{ \"Select an option\"|trans }}\" style=\"width: 50%;\">
                                        {{ knp_pagination_sortable(venues, \"Creation date\"|trans ~ ' (' ~ \"desc\"|trans ~ ')', \"v.createdAt\", {\"direction\": \"desc\", \"criteria\": \"v.createdAt\"}) }}
                                        {{ knp_pagination_sortable(venues, \"Creation date\"|trans ~ ' (' ~ \"asc\"|trans ~ ')', \"v.createdAt\", {\"direction\": \"asc\", \"criteria\": \"v.createdAt\"}) }}
                                    </select>
                                </label>
                                {% if is_granted('ROLE_ADMINISTRATOR') %}
                                    <a href=\"{{ path('dashboard_administrator_venue_add') }}\" class=\"btn btn-primary ml-3\" data-toggle=\"tooltip\" title=\"{{'Add a new venue' | trans}}\"><i class=\"fas fa-plus\"></i></a>
                                    {% elseif is_granted('ROLE_ORGANIZER')  %}
                                    <a href=\"{{ path('dashboard_organizer_venue_add') }}\" class=\"btn btn-primary ml-3\" data-toggle=\"tooltip\" title=\"{{'Add a new venue' | trans}}\"><i class=\"fas fa-plus\"></i></a>
                                    {% endif %}
                            </div>
                        </div>
                    </div>

                    {% if venues.getTotalItemCount > 0 %}

                        <div class=\"row\">

                            <div class=\"col-12\">
                                <div class=\"card\">
                                    <div class=\"table-responsive\">
                                        <table class=\"table table-hover table-vcenter text-nowrap\">
                                            <thead>
                                                <tr>
                                                    <th>{{'Name' | trans}}</th>
                                                    <th>{{'Image' | trans}}</th>
                                                        {% if is_granted('ROLE_ADMINISTRATOR') %}
                                                        <th>{{'Organizer' | trans}}</th>
                                                        {% endif %}
                                                    <th>{{'Events count' | trans}}</th>
                                                    <th>{{'Status' | trans}}</th>
                                                    <th class=\"text-center\"><i class=\"fas fa-cog\"></i></th>
                                                </tr>
                                            </thead>
                                            <tbody>

                                                {% for venue in venues %}

                                                    <tr>
                                                        <td>
                                                            <a href=\"{{ path(\"venue\", {slug: venue.slug}) }}\">{{ venue.name }}</a>
                                                        </td>
                                                        <td>
                                                            <a class=\"fancybox\" href=\"{{ venue.images|length > 0 ? asset(venue.getFirstImageOrPlaceholder) : venue.getFirstImageOrPlaceholder }}\" data-toggle=\"tooltip\" title=\"{{ \"Enlarge\"|trans }}\">
                                                                <img src=\"{{ venue.images|length > 0 ? asset(venue.getFirstImageOrPlaceholder) : venue.getFirstImageOrPlaceholder }}\" class=\"img-thumbnail img-50-50\" />
                                                            </a>
                                                        </td>
                                                        {% if is_granted('ROLE_ADMINISTRATOR') %}
                                                            <td>
                                                                {{ venue.organizer ? venue.organizer.name : \"Added by administrator\" }}
                                                            </td>
                                                        {% endif %}
                                                        <td>
                                                            {{ venue.eventdates|length }}
                                                        </td>
                                                        <td>
                                                            {% if venue.hidden %}
                                                                <span class=\"badge badge-danger\"><i class=\"fas fa-eye-slash fa-fw\"></i> {{ \"Hidden\"|trans }}</span>
                                                            {% else %}
                                                                <span class=\"badge badge-success\"><i class=\"fas fa-eye fa-fw\"></i> {{ \"Visible\"|trans }}</span>
                                                            {% endif %}
                                                            <br>
                                                            <br>
                                                            {% if venue.listedondirectory %}
                                                                <span class=\"badge badge-success\"><i class=\"fas fa-eye fa-fw\"></i> {{ \"Listed on the directory\"|trans }}</span>
                                                            {% else %}
                                                                <span class=\"badge badge-danger\"><i class=\"fas fa-eye-slash fa-fw\"></i> {{ \"Not listed on the directory\"|trans }}</span>
                                                            {% endif %}
                                                            {% if venue.deletedAt %}
                                                                <br>
                                                                <br>
                                                                <span class=\"badge badge-danger\"><i class=\"fas fa-times fa-fw\"></i> {{ \"Deleted\"|trans }}</span>
                                                            {% endif %}
                                                        </td>
                                                        <td class=\"text-center\">
                                                            <div class=\"item-action dropdown\">
                                                                <a href=\"javascript:void(0)\" data-toggle=\"dropdown\" data-boundary=\"window\" class=\"icon\"><i class=\"fas fa-ellipsis-v\"></i></a>
                                                                <div class=\"dropdown-menu dropdown-menu-right\">
                                                                    {% if is_granted('ROLE_ADMINISTRATOR') %}
                                                                        <a href=\"{{ path('dashboard_administrator_venue_edit', { slug : venue.slug }) }}\" class=\"dropdown-item\"><i class=\"dropdown-icon fas fa-edit fa-fw text-muted\"></i> {{ \"Edit\"|trans }}</a>
                                                                        {% if venue.hidden %}
                                                                            <a href=\"{{ path('dashboard_administrator_venue_show', { slug : venue.slug }) }}\" class=\"dropdown-item\"><i class=\"dropdown-icon fas fa-eye fa-fw text-muted\"></i> {{ \"Show\"|trans }}</a>
                                                                        {% else %}
                                                                            <a href=\"{{ path('dashboard_administrator_venue_hide', { slug : venue.slug }) }}\" class=\"dropdown-item\"><i class=\"dropdown-icon fas fa-eye-slash fa-fw text-muted\"></i> {{ \"Hide\"|trans }} </a>
                                                                        {% endif %}
                                                                        {% if venue.listedondirectory %}
                                                                            <a href=\"{{ path('dashboard_administrator_venue_hidefromdirectory', { slug : venue.slug }) }}\" class=\"dropdown-item\"><i class=\"dropdown-icon fas fa-minus-square fa-fw text-muted\"></i> {{ \"Hide from public directory\"|trans }} </a>
                                                                        {% else %}
                                                                            <a href=\"{{ path('dashboard_administrator_venue_listondirectory', { slug : venue.slug }) }}\" class=\"dropdown-item\"><i class=\"dropdown-icon fas fa-plus-square fa-fw text-muted\"></i> {{ \"List on public directory\"|trans }}</a>
                                                                        {% endif %}
                                                                        {% if venue.deletedAt %}
                                                                            <a href=\"{{ path('dashboard_administrator_venue_restore', { slug : venue.slug }) }}\" class=\"dropdown-item\"><i class=\"dropdown-icon fas fa-trash-restore fa-fw text-muted\"></i> {{ \"Restore\"|trans }}</a>
                                                                            <span data-target=\"{{ path('dashboard_administrator_venue_delete', { slug : venue.slug }) }}\" class=\"dropdown-item requires-confirmation\" data-confirmation-text=\"{{ \"You are about to delete the venue PERMANENTLY\"|trans }}\"><i class=\"dropdown-icon fas fa-trash fa-fw text-muted\"></i> {{ \"Delete permanently\"|trans }}</span>
                                                                        {% else %}
                                                                            <a href=\"{{ path('dashboard_administrator_venue_disable', { slug : venue.slug }) }}\" class=\"dropdown-item\"><i class=\"dropdown-icon fas fa-times fa-fw text-muted\"></i> {{ \"Delete\"|trans }} </a>
                                                                        {% endif %}
                                                                    {% elseif is_granted('ROLE_ORGANIZER') %}
                                                                        <a href=\"{{ path('dashboard_organizer_venue_edit', { slug : venue.slug }) }}\" class=\"dropdown-item\"><i class=\"dropdown-icon fas fa-edit fa-fw text-muted\"></i> {{ \"Edit\"|trans }}</a>
                                                                        {% if venue.hidden %}
                                                                            <a href=\"{{ path('dashboard_organizer_venue_show', { slug : venue.slug }) }}\" class=\"dropdown-item\"><i class=\"dropdown-icon fas fa-eye fa-fw text-muted\"></i> {{ \"Show\"|trans }}</a>
                                                                        {% else %}
                                                                            <a href=\"{{ path('dashboard_organizer_venue_hide', { slug : venue.slug }) }}\" class=\"dropdown-item\"><i class=\"dropdown-icon fas fa-eye-slash fa-fw text-muted\"></i> {{ \"Hide\"|trans }} </a>
                                                                        {% endif %}
                                                                        {% if venue.deletedAt %}
                                                                            <span data-target=\"{{ path('dashboard_organizer_venue_delete', { slug : venue.slug }) }}\" class=\"dropdown-item requires-confirmation\" data-confirmation-text=\"{{ \"You are about to delete the venue PERMANENTLY\"|trans }}\"><i class=\"dropdown-icon fas fa-trash fa-fw text-muted\"></i> {{ \"Delete permanently\"|trans }}</span>
                                                                        {% else %}
                                                                            <a href=\"{{ path('dashboard_organizer_venue_disable', { slug : venue.slug }) }}\" class=\"dropdown-item\"><i class=\"dropdown-icon fas fa-times fa-fw text-muted\"></i> {{ \"Delete\"|trans }} </a>
                                                                        {% endif %}
                                                                    {% endif %}
                                                                </div>
                                                            </div>
                                                        </td>
                                                    </tr>

                                                {% endfor %}
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                {{ knp_pagination_render(venues, null, {}, {'align': 'center'}) }}
                            </div>

                        </div>

                    {% else %}

                        {% include \"Global/message.html.twig\" with { type: \"info\", message: ('No venues found'|trans), icon: \"fas fa-exclamation-circle\" } %}

                    {% endif %}
                </div>
            </div>

        </div>
    </section>

{% endblock %}

{% block javascripts %}

    <script>

        \$(document).ready(function () {
            if (getURLParameter('directory') != \"null\") {
                \$('input[type=\"radio\"][name=\"directory\"][value=\"' + getURLParameter('directory') + '\"]').attr(\"checked\", \"checked\");
            }
        });

    </script>

{% endblock %}", "Dashboard/Shared/Venue/index.html.twig", "/home/wacndcwl/ievntz.com/templates/Dashboard/Shared/Venue/index.html.twig");
    }
}
